/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.functions.html;

import com.google.clearsilver.jsilver.functions.TextFilter;
import java.io.IOException;

public abstract class BaseUrlValidateFunction
implements TextFilter {
    public void filter(String string, Appendable appendable) throws IOException {
        if (!this.isValidUri(string)) {
            appendable.append('#');
            return;
        }
        this.applyEscaping(string, appendable);
    }

    protected abstract void applyEscaping(String var1, Appendable var2) throws IOException;

    protected boolean isValidUri(String string) {
        String string2 = this.toLowerCaseAsciiOnly(string.substring(0, Math.min(string.length(), 8)));
        if (string2.startsWith("http://") || string2.startsWith("https://") || string2.startsWith("ftp://") || string2.startsWith("mailto:")) {
            return true;
        }
        int n = string.indexOf(47);
        if (n != -1) {
            return string.lastIndexOf(58, n - 1) == -1;
        }
        return string.indexOf(58) == -1;
    }

    private String toLowerCaseAsciiOnly(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            cArray[i] = Character.UnicodeBlock.of(c) == Character.UnicodeBlock.BASIC_LATIN ? (int)Character.toLowerCase(c) : 63;
        }
        return new String(cArray);
    }
}

