/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.interpreter;

import com.google.clearsilver.jsilver.autoescape.AutoEscapeOptions;
import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.data.DefaultDataContext;
import com.google.clearsilver.jsilver.functions.FunctionExecutor;
import com.google.clearsilver.jsilver.interpreter.TemplateInterpreter;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import com.google.clearsilver.jsilver.syntax.TemplateSyntaxTree;
import com.google.clearsilver.jsilver.template.DefaultRenderingContext;
import com.google.clearsilver.jsilver.template.RenderingContext;
import com.google.clearsilver.jsilver.template.Template;
import com.google.clearsilver.jsilver.template.TemplateLoader;
import java.io.IOException;

public class InterpretedTemplate
implements Template {
    private final TemplateLoader loader;
    private final TemplateSyntaxTree syntaxTree;
    private final String name;
    private final FunctionExecutor functionExecutor;
    private final EscapeMode escapeMode;
    private final AutoEscapeOptions autoEscapeOptions;

    public InterpretedTemplate(TemplateLoader templateLoader, TemplateSyntaxTree templateSyntaxTree, String string, FunctionExecutor functionExecutor, AutoEscapeOptions autoEscapeOptions, EscapeMode escapeMode) {
        this.loader = templateLoader;
        this.syntaxTree = templateSyntaxTree;
        this.name = string;
        this.functionExecutor = functionExecutor;
        this.escapeMode = escapeMode;
        this.autoEscapeOptions = autoEscapeOptions;
    }

    public void render(Data data, Appendable appendable, ResourceLoader resourceLoader) throws IOException {
        this.render(this.createRenderingContext(data, appendable, resourceLoader));
    }

    public void render(RenderingContext renderingContext) throws IOException {
        TemplateInterpreter templateInterpreter = new TemplateInterpreter(this, this.loader, renderingContext, this.functionExecutor);
        renderingContext.pushExecutionContext(this);
        this.syntaxTree.apply(templateInterpreter);
        renderingContext.popExecutionContext();
    }

    public RenderingContext createRenderingContext(Data data, Appendable appendable, ResourceLoader resourceLoader) {
        DefaultDataContext defaultDataContext = new DefaultDataContext(data);
        return new DefaultRenderingContext(defaultDataContext, resourceLoader, appendable, this.functionExecutor, this.autoEscapeOptions);
    }

    public String getTemplateName() {
        return this.name;
    }

    public EscapeMode getEscapeMode() {
        return this.escapeMode;
    }

    public String getDisplayName() {
        return this.name;
    }
}

