/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.interpreter;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.interpreter.OptimizerProvider;
import com.google.clearsilver.jsilver.interpreter.TemplateFactory;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import com.google.clearsilver.jsilver.syntax.TemplateSyntaxTree;
import java.util.ArrayList;
import java.util.List;

public class OptimizingTemplateFactory
implements TemplateFactory {
    private final TemplateFactory wrapped;
    private final List<OptimizerProvider> optimizers;

    public OptimizingTemplateFactory(TemplateFactory templateFactory, OptimizerProvider ... optimizerProviderArray) {
        this.wrapped = templateFactory;
        this.optimizers = new ArrayList<OptimizerProvider>();
        for (OptimizerProvider optimizerProvider : optimizerProviderArray) {
            if (optimizerProvider == null) continue;
            this.optimizers.add(optimizerProvider);
        }
    }

    private void optimize(TemplateSyntaxTree templateSyntaxTree) {
        for (OptimizerProvider optimizerProvider : this.optimizers) {
            templateSyntaxTree.apply(optimizerProvider.getOptimizer());
        }
    }

    public TemplateSyntaxTree createTemp(String string, EscapeMode escapeMode) {
        TemplateSyntaxTree templateSyntaxTree = this.wrapped.createTemp(string, escapeMode);
        this.optimize(templateSyntaxTree);
        return templateSyntaxTree;
    }

    public TemplateSyntaxTree find(String string, ResourceLoader resourceLoader, EscapeMode escapeMode) {
        TemplateSyntaxTree templateSyntaxTree = this.wrapped.find(string, resourceLoader, escapeMode);
        this.optimize(templateSyntaxTree);
        return templateSyntaxTree;
    }
}

