/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.interpreter;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.data.DataContext;
import com.google.clearsilver.jsilver.exceptions.ExceptionUtil;
import com.google.clearsilver.jsilver.exceptions.JSilverIOException;
import com.google.clearsilver.jsilver.exceptions.JSilverInterpreterException;
import com.google.clearsilver.jsilver.functions.FunctionExecutor;
import com.google.clearsilver.jsilver.interpreter.ExpressionEvaluator;
import com.google.clearsilver.jsilver.interpreter.InterpretedMacro;
import com.google.clearsilver.jsilver.interpreter.VariableLocator;
import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.AAltCommand;
import com.google.clearsilver.jsilver.syntax.node.AAutoescapeCommand;
import com.google.clearsilver.jsilver.syntax.node.ACallCommand;
import com.google.clearsilver.jsilver.syntax.node.ADataCommand;
import com.google.clearsilver.jsilver.syntax.node.ADefCommand;
import com.google.clearsilver.jsilver.syntax.node.AEachCommand;
import com.google.clearsilver.jsilver.syntax.node.AEscapeCommand;
import com.google.clearsilver.jsilver.syntax.node.AEvarCommand;
import com.google.clearsilver.jsilver.syntax.node.AHardIncludeCommand;
import com.google.clearsilver.jsilver.syntax.node.AHardLincludeCommand;
import com.google.clearsilver.jsilver.syntax.node.AIfCommand;
import com.google.clearsilver.jsilver.syntax.node.AIncludeCommand;
import com.google.clearsilver.jsilver.syntax.node.ALincludeCommand;
import com.google.clearsilver.jsilver.syntax.node.ALoopCommand;
import com.google.clearsilver.jsilver.syntax.node.ALoopIncCommand;
import com.google.clearsilver.jsilver.syntax.node.ALoopToCommand;
import com.google.clearsilver.jsilver.syntax.node.ALvarCommand;
import com.google.clearsilver.jsilver.syntax.node.ANameCommand;
import com.google.clearsilver.jsilver.syntax.node.ANameVariable;
import com.google.clearsilver.jsilver.syntax.node.ASetCommand;
import com.google.clearsilver.jsilver.syntax.node.AUvarCommand;
import com.google.clearsilver.jsilver.syntax.node.AVarCommand;
import com.google.clearsilver.jsilver.syntax.node.AWithCommand;
import com.google.clearsilver.jsilver.syntax.node.PCommand;
import com.google.clearsilver.jsilver.syntax.node.PExpression;
import com.google.clearsilver.jsilver.syntax.node.PPosition;
import com.google.clearsilver.jsilver.syntax.node.PVariable;
import com.google.clearsilver.jsilver.syntax.node.TCsOpen;
import com.google.clearsilver.jsilver.syntax.node.TWord;
import com.google.clearsilver.jsilver.template.Macro;
import com.google.clearsilver.jsilver.template.RenderingContext;
import com.google.clearsilver.jsilver.template.Template;
import com.google.clearsilver.jsilver.template.TemplateLoader;
import com.google.clearsilver.jsilver.values.Value;
import com.google.clearsilver.jsilver.values.VariableValue;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateInterpreter
extends DepthFirstAdapter {
    private final Template template;
    private final ExpressionEvaluator expressionEvaluator;
    private final VariableLocator variableLocator;
    private final TemplateLoader templateLoader;
    private final RenderingContext context;
    private final DataContext dataContext;

    public TemplateInterpreter(Template template, TemplateLoader templateLoader, RenderingContext renderingContext, FunctionExecutor functionExecutor) {
        this.template = template;
        this.templateLoader = templateLoader;
        this.context = renderingContext;
        this.dataContext = renderingContext.getDataContext();
        this.expressionEvaluator = new ExpressionEvaluator(this.dataContext, functionExecutor);
        this.variableLocator = new VariableLocator(this.expressionEvaluator);
    }

    @Override
    public void caseADataCommand(ADataCommand aDataCommand) {
        this.context.writeUnescaped(aDataCommand.getData().getText());
    }

    @Override
    public void caseAVarCommand(AVarCommand aVarCommand) {
        this.setLastPosition(aVarCommand.getPosition());
        Value value = this.expressionEvaluator.evaluate(aVarCommand.getExpression());
        this.writeVariable(value);
    }

    @Override
    public void caseAUvarCommand(AUvarCommand aUvarCommand) {
        this.setLastPosition(aUvarCommand.getPosition());
        Value value = this.expressionEvaluator.evaluate(aUvarCommand.getExpression());
        this.context.writeUnescaped(value.asString());
    }

    @Override
    public void caseALvarCommand(ALvarCommand aLvarCommand) {
        this.setLastPosition(aLvarCommand.getPosition());
        this.evaluateVariable(aLvarCommand.getExpression(), "[lvar expression]");
    }

    @Override
    public void caseAEvarCommand(AEvarCommand aEvarCommand) {
        this.setLastPosition(aEvarCommand.getPosition());
        this.evaluateVariable(aEvarCommand.getExpression(), "[evar expression]");
    }

    private void evaluateVariable(PExpression pExpression, String string) {
        Value value = this.expressionEvaluator.evaluate(pExpression);
        Template template = this.templateLoader.createTemp(string, value.asString(), this.context.getAutoEscapeMode());
        try {
            template.render(this.context);
        }
        catch (IOException iOException) {
            throw new JSilverInterpreterException(iOException.getMessage());
        }
    }

    @Override
    public void caseAHardLincludeCommand(AHardLincludeCommand aHardLincludeCommand) {
        this.setLastPosition(aHardLincludeCommand.getPosition());
        this.include(aHardLincludeCommand.getExpression(), false);
    }

    @Override
    public void caseALincludeCommand(ALincludeCommand aLincludeCommand) {
        this.setLastPosition(aLincludeCommand.getPosition());
        this.include(aLincludeCommand.getExpression(), true);
    }

    @Override
    public void caseAHardIncludeCommand(AHardIncludeCommand aHardIncludeCommand) {
        this.setLastPosition(aHardIncludeCommand.getPosition());
        this.include(aHardIncludeCommand.getExpression(), false);
    }

    @Override
    public void caseAIncludeCommand(AIncludeCommand aIncludeCommand) {
        this.setLastPosition(aIncludeCommand.getPosition());
        this.include(aIncludeCommand.getExpression(), true);
    }

    @Override
    public void caseASetCommand(ASetCommand aSetCommand) {
        this.setLastPosition(aSetCommand.getPosition());
        String string = this.variableLocator.getVariableName(aSetCommand.getVariable());
        try {
            Data data = this.dataContext.findVariable(string, true);
            Value value = this.expressionEvaluator.evaluate(aSetCommand.getExpression());
            data.setValue(value.asString());
            data.setEscapeMode(value.getEscapeMode());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new UnsupportedOperationException(this.createUnsupportedOperationMessage(aSetCommand, this.context.getIncludedTemplateNames()), unsupportedOperationException);
        }
    }

    @Override
    public void caseANameCommand(ANameCommand aNameCommand) {
        this.setLastPosition(aNameCommand.getPosition());
        String string = this.variableLocator.getVariableName(aNameCommand.getVariable());
        Data data = this.dataContext.findVariable(string, false);
        if (data != null) {
            this.context.writeEscaped(data.getSymlink().getName());
        }
    }

    @Override
    public void caseAIfCommand(AIfCommand aIfCommand) {
        this.setLastPosition(aIfCommand.getPosition());
        Value value = this.expressionEvaluator.evaluate(aIfCommand.getExpression());
        if (value.asBoolean()) {
            aIfCommand.getBlock().apply(this);
        } else {
            aIfCommand.getOtherwise().apply(this);
        }
    }

    @Override
    public void caseAEscapeCommand(AEscapeCommand aEscapeCommand) {
        this.setLastPosition(aEscapeCommand.getPosition());
        Value value = this.expressionEvaluator.evaluate(aEscapeCommand.getExpression());
        String string = value.asString();
        this.context.pushEscapingFunction(string);
        aEscapeCommand.getCommand().apply(this);
        this.context.popEscapingFunction();
    }

    @Override
    public void caseAAutoescapeCommand(AAutoescapeCommand aAutoescapeCommand) {
        this.setLastPosition(aAutoescapeCommand.getPosition());
        Value value = this.expressionEvaluator.evaluate(aAutoescapeCommand.getExpression());
        String string = value.asString();
        EscapeMode escapeMode = EscapeMode.computeEscapeMode(string);
        this.context.pushAutoEscapeMode(escapeMode);
        aAutoescapeCommand.getCommand().apply(this);
        this.context.popAutoEscapeMode();
    }

    @Override
    public void caseAWithCommand(AWithCommand aWithCommand) {
        this.setLastPosition(aWithCommand.getPosition());
        VariableLocator variableLocator = new VariableLocator(this.expressionEvaluator);
        String string = variableLocator.getVariableName(aWithCommand.getVariable());
        Value value = this.expressionEvaluator.evaluate(aWithCommand.getExpression());
        if (value instanceof VariableValue && ((VariableValue)value).getReference() == null) {
            return;
        }
        this.dataContext.pushVariableScope();
        this.setTempVariable(string, value);
        aWithCommand.getCommand().apply(this);
        this.dataContext.popVariableScope();
    }

    @Override
    public void caseALoopToCommand(ALoopToCommand aLoopToCommand) {
        this.setLastPosition(aLoopToCommand.getPosition());
        int n = this.expressionEvaluator.evaluate(aLoopToCommand.getExpression()).asNumber();
        if (n < 0) {
            return;
        }
        this.loop(aLoopToCommand.getVariable(), 0, n, 1, aLoopToCommand.getCommand());
    }

    @Override
    public void caseALoopCommand(ALoopCommand aLoopCommand) {
        this.setLastPosition(aLoopCommand.getPosition());
        int n = this.expressionEvaluator.evaluate(aLoopCommand.getStart()).asNumber();
        int n2 = this.expressionEvaluator.evaluate(aLoopCommand.getEnd()).asNumber();
        if (n2 < n) {
            return;
        }
        this.loop(aLoopCommand.getVariable(), n, n2, 1, aLoopCommand.getCommand());
    }

    @Override
    public void caseALoopIncCommand(ALoopIncCommand aLoopIncCommand) {
        this.setLastPosition(aLoopIncCommand.getPosition());
        int n = this.expressionEvaluator.evaluate(aLoopIncCommand.getStart()).asNumber();
        int n2 = this.expressionEvaluator.evaluate(aLoopIncCommand.getEnd()).asNumber();
        int n3 = this.expressionEvaluator.evaluate(aLoopIncCommand.getIncrement()).asNumber();
        if (n3 == 0) {
            return;
        }
        if (n3 > 0 && n > n2) {
            return;
        }
        if (n3 < 0 && n < n2) {
            return;
        }
        this.loop(aLoopIncCommand.getVariable(), n, n2, n3, aLoopIncCommand.getCommand());
    }

    @Override
    public void caseAEachCommand(AEachCommand aEachCommand) {
        VariableValue variableValue;
        Data data;
        this.setLastPosition(aEachCommand.getPosition());
        Value value = this.expressionEvaluator.evaluate(aEachCommand.getExpression());
        if (value instanceof VariableValue && (data = (variableValue = (VariableValue)value).getReference()) != null) {
            this.each(aEachCommand.getVariable(), variableValue.getName(), data, aEachCommand.getCommand());
        }
    }

    @Override
    public void caseAAltCommand(AAltCommand aAltCommand) {
        this.setLastPosition(aAltCommand.getPosition());
        Value value = this.expressionEvaluator.evaluate(aAltCommand.getExpression());
        if (value.asBoolean()) {
            this.writeVariable(value);
        } else {
            aAltCommand.getCommand().apply(this);
        }
    }

    private void writeVariable(Value value) {
        if (this.template.getEscapeMode().isAutoEscapingMode()) {
            this.autoEscapeAndWriteVariable(value);
        } else if (value.isPartiallyEscaped()) {
            this.context.writeUnescaped(value.asString());
        } else {
            this.context.writeEscaped(value.asString());
        }
    }

    private void autoEscapeAndWriteVariable(Value value) {
        if (this.isTrustedValue(value) || value.isPartiallyEscaped()) {
            this.context.writeUnescaped(value.asString());
        } else {
            this.context.writeEscaped(value.asString());
        }
    }

    private boolean isTrustedValue(Value value) {
        return this.context.getAutoEscapeOptions().getPropagateEscapeStatus() && !value.getEscapeMode().equals((Object)EscapeMode.ESCAPE_NONE);
    }

    @Override
    public void caseADefCommand(ADefCommand aDefCommand) {
        String string = this.makeWord(aDefCommand.getMacro());
        LinkedList<PVariable> linkedList = aDefCommand.getArguments();
        String[] stringArray = new String[linkedList.size()];
        int n = 0;
        for (PVariable pVariable : linkedList) {
            if (!(pVariable instanceof ANameVariable)) {
                throw new JSilverInterpreterException("Invalid name for macro '" + string + "' argument " + n + " : " + pVariable);
            }
            stringArray[n++] = ((ANameVariable)pVariable).getWord().getText();
        }
        this.context.registerMacro(string, new InterpretedMacro(aDefCommand.getCommand(), this.template, string, stringArray, this, this.context));
    }

    private String makeWord(LinkedList<TWord> linkedList) {
        if (linkedList.size() == 1) {
            return linkedList.getFirst().getText();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (TWord tWord : linkedList) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(tWord.getText());
        }
        return stringBuilder.toString();
    }

    @Override
    public void caseACallCommand(ACallCommand aCallCommand) {
        String string = this.makeWord(aCallCommand.getMacro());
        Macro macro = this.context.findMacro(string);
        if (aCallCommand.getArguments().size() != macro.getArgumentCount()) {
            throw new JSilverInterpreterException("Number of arguments to macro " + string + " (" + aCallCommand.getArguments().size() + ") does not match " + "number of expected arguments (" + macro.getArgumentCount() + ")");
        }
        int n = aCallCommand.getArguments().size();
        if (n > 0) {
            Value[] valueArray = new Value[n];
            Iterator iterator = aCallCommand.getArguments().iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                valueArray[n2] = this.expressionEvaluator.evaluate((PExpression)iterator.next());
                ++n2;
            }
            this.dataContext.pushVariableScope();
            for (n2 = 0; n2 < valueArray.length; ++n2) {
                this.setTempVariable(macro.getArgumentName(n2), valueArray[n2]);
            }
        }
        try {
            macro.render(this.context);
        }
        catch (IOException iOException) {
            throw new JSilverIOException(iOException);
        }
        if (n > 0) {
            this.dataContext.popVariableScope();
        }
    }

    private void each(PVariable pVariable, String string, Data data, PCommand pCommand) {
        VariableLocator variableLocator = new VariableLocator(this.expressionEvaluator);
        String string2 = variableLocator.getVariableName(pVariable);
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append('.');
        int n = stringBuilder.length();
        this.dataContext.pushVariableScope();
        for (Data data2 : data.getChildren()) {
            stringBuilder.delete(n, stringBuilder.length());
            stringBuilder.append(data2.getName());
            this.setTempVariable(string2, Value.variableValue(stringBuilder.toString(), this.dataContext));
            pCommand.apply(this);
        }
        this.dataContext.popVariableScope();
    }

    private void loop(PVariable pVariable, int n, int n2, int n3, PCommand pCommand) {
        VariableLocator variableLocator = new VariableLocator(this.expressionEvaluator);
        String string = variableLocator.getVariableName(pVariable);
        this.dataContext.pushVariableScope();
        int n4 = n;
        while (n3 > 0 ? n4 <= n2 : n4 >= n2) {
            this.dataContext.createLocalVariableByValue(string, String.valueOf(n4), n4 == n, n4 == n2);
            pCommand.apply(this);
            n4 += n3;
        }
        this.dataContext.popVariableScope();
    }

    private void include(PExpression pExpression, boolean bl) {
        Value value = this.expressionEvaluator.evaluate(pExpression);
        String string = value.asString();
        if (!this.context.pushIncludeStackEntry(string)) {
            throw new JSilverInterpreterException(this.createIncludeLoopErrorMessage(string, this.context.getIncludedTemplateNames()));
        }
        this.loadAndRenderIncludedTemplate(string, bl);
        if (!this.context.popIncludeStackEntry(string)) {
            throw new IllegalStateException("Unable to find on include stack: " + string);
        }
    }

    private String createIncludeLoopErrorMessage(String string, Iterable<String> iterable) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("File included twice: ");
        stringBuilder.append(string);
        stringBuilder.append(" Include stack:");
        for (String string2 : iterable) {
            stringBuilder.append("\n -> ");
            stringBuilder.append(string2);
        }
        stringBuilder.append("\n -> ");
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private String createUnsupportedOperationMessage(PCommand pCommand, Iterable<String> iterable) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("exception thrown while parsing node: ");
        stringBuilder.append(pCommand.toString());
        stringBuilder.append(" (class ").append(pCommand.getClass().getSimpleName()).append(")");
        stringBuilder.append("\nTemplate include stack: ");
        Iterator<String> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(" -> ");
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    private void loadAndRenderIncludedTemplate(String string, boolean bl) {
        Template template = null;
        try {
            template = this.templateLoader.load(string, this.context.getResourceLoader(), this.context.getAutoEscapeMode());
        }
        catch (RuntimeException runtimeException) {
            if (bl && ExceptionUtil.isFileNotFoundException(runtimeException)) {
                return;
            }
            throw runtimeException;
        }
        try {
            template.render(this.context);
        }
        catch (IOException iOException) {
            throw new JSilverInterpreterException(iOException.getMessage());
        }
    }

    private void setLastPosition(PPosition pPosition) {
        pPosition.apply(this);
    }

    @Override
    public void caseTCsOpen(TCsOpen tCsOpen) {
        int n = tCsOpen.getLine();
        int n2 = tCsOpen.getPos();
        this.context.setCurrentPosition(n, n2);
    }

    private void setTempVariable(String string, Value value) {
        if (value instanceof VariableValue) {
            this.dataContext.createLocalVariableByPath(string, ((VariableValue)value).getName());
        } else {
            this.dataContext.createLocalVariableByValue(string, value.asString(), value.getEscapeMode());
        }
    }
}

