/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.interpreter;

import com.google.clearsilver.jsilver.interpreter.ExpressionEvaluator;
import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.ADecNumberVariable;
import com.google.clearsilver.jsilver.syntax.node.ADescendVariable;
import com.google.clearsilver.jsilver.syntax.node.AExpandVariable;
import com.google.clearsilver.jsilver.syntax.node.AHexNumberVariable;
import com.google.clearsilver.jsilver.syntax.node.ANameVariable;
import com.google.clearsilver.jsilver.syntax.node.PVariable;
import com.google.clearsilver.jsilver.values.Value;

public class VariableLocator
extends DepthFirstAdapter {
    private StringBuilder currentName;
    private final ExpressionEvaluator expressionEvaluator;

    public VariableLocator(ExpressionEvaluator expressionEvaluator) {
        this.expressionEvaluator = expressionEvaluator;
    }

    private String quickEval(PVariable pVariable) {
        if (pVariable instanceof ANameVariable) {
            return ((ANameVariable)pVariable).getWord().getText();
        }
        if (pVariable instanceof ADecNumberVariable) {
            return ((ADecNumberVariable)pVariable).getDecNumber().getText();
        }
        if (pVariable instanceof AHexNumberVariable) {
            return ((AHexNumberVariable)pVariable).getHexNumber().getText();
        }
        return null;
    }

    public String getVariableName(PVariable pVariable) {
        String string = this.quickEval(pVariable);
        if (string != null) {
            return string;
        }
        StringBuilder stringBuilder = this.currentName;
        this.currentName = new StringBuilder(10);
        pVariable.apply(this);
        string = this.currentName.toString();
        this.currentName = stringBuilder;
        return string;
    }

    public void caseANameVariable(ANameVariable aNameVariable) {
        this.descendVariable(aNameVariable.getWord().getText());
    }

    public void caseADecNumberVariable(ADecNumberVariable aDecNumberVariable) {
        this.descendVariable(aDecNumberVariable.getDecNumber().getText());
    }

    public void caseAHexNumberVariable(AHexNumberVariable aHexNumberVariable) {
        this.descendVariable(aHexNumberVariable.getHexNumber().getText());
    }

    public void caseADescendVariable(ADescendVariable aDescendVariable) {
        aDescendVariable.getParent().apply(this);
        aDescendVariable.getChild().apply(this);
    }

    public void caseAExpandVariable(AExpandVariable aExpandVariable) {
        aExpandVariable.getParent().apply(this);
        Value value = this.expressionEvaluator.evaluate(aExpandVariable.getChild());
        this.descendVariable(value.asString());
    }

    private void descendVariable(String string) {
        if (this.currentName.length() != 0) {
            this.currentName.append('.');
        }
        this.currentName.append(string);
    }
}

