/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.precompiler;

import com.google.clearsilver.jsilver.autoescape.AutoEscapeOptions;
import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.compiler.BaseCompiledTemplate;
import com.google.clearsilver.jsilver.functions.FunctionExecutor;
import com.google.clearsilver.jsilver.precompiler.PrecompiledTemplateMapKey;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import com.google.clearsilver.jsilver.template.DelegatingTemplateLoader;
import com.google.clearsilver.jsilver.template.Template;
import com.google.clearsilver.jsilver.template.TemplateLoader;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrecompiledTemplateLoader
implements DelegatingTemplateLoader {
    private final TemplateLoader nextLoader;
    private final Map<Object, BaseCompiledTemplate> templateMap;
    private final AutoEscapeOptions autoEscapeOptions;

    public PrecompiledTemplateLoader(TemplateLoader templateLoader, Map<Object, String> map, FunctionExecutor functionExecutor, AutoEscapeOptions autoEscapeOptions) {
        this.nextLoader = templateLoader;
        this.autoEscapeOptions = autoEscapeOptions;
        this.templateMap = this.makeTemplateMap(map, functionExecutor);
    }

    private Map<Object, BaseCompiledTemplate> makeTemplateMap(Map<Object, String> map, FunctionExecutor functionExecutor) {
        HashMap<Object, BaseCompiledTemplate> hashMap = new HashMap<Object, BaseCompiledTemplate>();
        ClassLoader classLoader = this.getClass().getClassLoader();
        for (Map.Entry<Object, String> entry : map.entrySet()) {
            String string = entry.getValue();
            BaseCompiledTemplate baseCompiledTemplate = this.loadTemplateObject(string, classLoader);
            baseCompiledTemplate.setFunctionExecutor(functionExecutor);
            baseCompiledTemplate.setTemplateName(entry.getKey().toString());
            baseCompiledTemplate.setTemplateLoader(this);
            if (entry.getKey() instanceof PrecompiledTemplateMapKey) {
                PrecompiledTemplateMapKey precompiledTemplateMapKey = (PrecompiledTemplateMapKey)entry.getKey();
                baseCompiledTemplate.setEscapeMode(precompiledTemplateMapKey.getEscapeMode());
            } else {
                baseCompiledTemplate.setEscapeMode(EscapeMode.ESCAPE_NONE);
            }
            baseCompiledTemplate.setAutoEscapeOptions(this.autoEscapeOptions);
            hashMap.put(entry.getKey(), baseCompiledTemplate);
        }
        return ImmutableMap.copyOf(hashMap);
    }

    @VisibleForTesting
    protected BaseCompiledTemplate loadTemplateObject(String string, ClassLoader classLoader) {
        try {
            Class<?> clazz = classLoader.loadClass(string);
            return (BaseCompiledTemplate)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Class not found: " + string, classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new Error(instantiationException);
        }
    }

    @Override
    public void setTemplateLoaderDelegate(TemplateLoader templateLoader) {
        for (BaseCompiledTemplate baseCompiledTemplate : this.templateMap.values()) {
            baseCompiledTemplate.setTemplateLoader(templateLoader);
        }
    }

    @Override
    public Template load(String string, ResourceLoader resourceLoader, EscapeMode escapeMode) {
        Object object = resourceLoader.getKey(string);
        PrecompiledTemplateMapKey precompiledTemplateMapKey = new PrecompiledTemplateMapKey(object, escapeMode);
        Template template = this.templateMap.get(precompiledTemplateMapKey);
        if (template != null) {
            return template;
        }
        return this.nextLoader.load(string, resourceLoader, escapeMode);
    }

    @Override
    public Template createTemp(String string, String string2, EscapeMode escapeMode) {
        return this.nextLoader.createTemp(string, string2, escapeMode);
    }
}

