/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.resourceloader;

import com.google.clearsilver.jsilver.exceptions.JSilverTemplateNotFoundException;
import com.google.clearsilver.jsilver.resourceloader.BufferedResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class ClassLoaderResourceLoader
extends BufferedResourceLoader {
    private final ClassLoader classLoader;
    private String basePath;

    public ClassLoaderResourceLoader(ClassLoader classLoader, String string) {
        this.classLoader = classLoader;
        this.basePath = string;
    }

    public ClassLoaderResourceLoader(ClassLoader classLoader) {
        this(classLoader, ".");
    }

    public Reader open(String string) throws IOException {
        String string2 = this.basePath + '/' + string;
        InputStream inputStream = this.classLoader.getResourceAsStream(string2);
        return inputStream == null ? null : this.buffer(new InputStreamReader(inputStream, this.getCharacterSet()));
    }

    public Reader openOrFail(String string) throws JSilverTemplateNotFoundException, IOException {
        Reader reader = this.open(string);
        if (reader == null) {
            throw new JSilverTemplateNotFoundException("No class loader resource '" + string + "' in '" + this.basePath + "'");
        }
        return reader;
    }
}

