/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.resourceloader;

import com.google.clearsilver.jsilver.exceptions.JSilverTemplateNotFoundException;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeResourceLoader
implements ResourceLoader {
    private final List<ResourceLoader> loaders = new ArrayList<ResourceLoader>();

    public CompositeResourceLoader(Iterable<ResourceLoader> iterable) {
        for (ResourceLoader resourceLoader : iterable) {
            this.add(resourceLoader);
        }
    }

    public CompositeResourceLoader(ResourceLoader ... resourceLoaderArray) {
        for (ResourceLoader resourceLoader : resourceLoaderArray) {
            this.add(resourceLoader);
        }
    }

    public void add(ResourceLoader resourceLoader) {
        this.loaders.add(resourceLoader);
    }

    @Override
    public Reader open(String string) throws IOException {
        for (ResourceLoader resourceLoader : this.loaders) {
            Reader reader = resourceLoader.open(string);
            if (reader == null) continue;
            return new ReaderTracer(reader, resourceLoader);
        }
        return null;
    }

    @Override
    public Reader openOrFail(String string) throws JSilverTemplateNotFoundException, IOException {
        Reader reader = this.open(string);
        if (reader == null) {
            throw new JSilverTemplateNotFoundException(string);
        }
        return reader;
    }

    @Override
    public void close(Reader reader) throws IOException {
        if (!(reader instanceof ReaderTracer)) {
            throw new IllegalArgumentException("I can't close a reader I didn't open.");
        }
        reader.close();
    }

    @Override
    public Object getKey(String string) {
        return string;
    }

    @Override
    public Object getResourceVersionId(String string) {
        for (ResourceLoader resourceLoader : this.loaders) {
            Object object = resourceLoader.getResourceVersionId(string);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    private static class ReaderTracer
    extends FilterReader {
        private final ResourceLoader originalLoader;

        public ReaderTracer(Reader reader, ResourceLoader resourceLoader) {
            super(reader);
            this.originalLoader = resourceLoader;
        }

        public void close() throws IOException {
            this.originalLoader.close(this.in);
        }
    }
}

