/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.syntax;

import com.google.clearsilver.jsilver.autoescape.AutoEscapeContext;
import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.exceptions.JSilverAutoEscapingException;
import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.AAltCommand;
import com.google.clearsilver.jsilver.syntax.node.AAutoescapeCommand;
import com.google.clearsilver.jsilver.syntax.node.ACallCommand;
import com.google.clearsilver.jsilver.syntax.node.AContentTypeCommand;
import com.google.clearsilver.jsilver.syntax.node.ACsOpenPosition;
import com.google.clearsilver.jsilver.syntax.node.ADataCommand;
import com.google.clearsilver.jsilver.syntax.node.ADefCommand;
import com.google.clearsilver.jsilver.syntax.node.AEscapeCommand;
import com.google.clearsilver.jsilver.syntax.node.AEvarCommand;
import com.google.clearsilver.jsilver.syntax.node.AHardIncludeCommand;
import com.google.clearsilver.jsilver.syntax.node.AHardLincludeCommand;
import com.google.clearsilver.jsilver.syntax.node.AIfCommand;
import com.google.clearsilver.jsilver.syntax.node.AIncludeCommand;
import com.google.clearsilver.jsilver.syntax.node.ALincludeCommand;
import com.google.clearsilver.jsilver.syntax.node.ALvarCommand;
import com.google.clearsilver.jsilver.syntax.node.ANameCommand;
import com.google.clearsilver.jsilver.syntax.node.AStringExpression;
import com.google.clearsilver.jsilver.syntax.node.AUvarCommand;
import com.google.clearsilver.jsilver.syntax.node.AVarCommand;
import com.google.clearsilver.jsilver.syntax.node.Node;
import com.google.clearsilver.jsilver.syntax.node.PCommand;
import com.google.clearsilver.jsilver.syntax.node.PPosition;
import com.google.clearsilver.jsilver.syntax.node.Start;
import com.google.clearsilver.jsilver.syntax.node.TCsOpen;
import com.google.clearsilver.jsilver.syntax.node.TString;

public class AutoEscaper
extends DepthFirstAdapter {
    private AutoEscapeContext autoEscapeContext;
    private boolean skipAutoEscape;
    private final EscapeMode escapeMode;
    private final String templateName;
    private boolean contentTypeCalled;

    public AutoEscaper(EscapeMode escapeMode, String string) {
        this.templateName = string;
        if (escapeMode.equals((Object)EscapeMode.ESCAPE_NONE)) {
            throw new JSilverAutoEscapingException("AutoEscaper called when no escaping is required", string);
        }
        this.escapeMode = escapeMode;
        if (escapeMode.isAutoEscapingMode()) {
            this.autoEscapeContext = new AutoEscapeContext(escapeMode, string);
            this.skipAutoEscape = false;
        } else {
            this.autoEscapeContext = null;
        }
    }

    public AutoEscaper(EscapeMode escapeMode) {
        this(escapeMode, null);
    }

    public void caseStart(Start start) {
        if (!this.escapeMode.isAutoEscapingMode()) {
            this.handleExplicitEscapeMode(start);
        } else {
            AutoEscapeContext.AutoEscapeState autoEscapeState = this.autoEscapeContext.getCurrentState();
            super.caseStart(start);
            AutoEscapeContext.AutoEscapeState autoEscapeState2 = this.autoEscapeContext.getCurrentState();
            if (!this.autoEscapeContext.isPermittedStateChangeForIncludes(autoEscapeState, autoEscapeState2)) {
                if (this.contentTypeCalled) {
                    return;
                }
                throw new JSilverAutoEscapingException("Template starts in context " + (Object)((Object)autoEscapeState) + " but ends in different context " + (Object)((Object)autoEscapeState2), this.templateName);
            }
        }
    }

    private void handleExplicitEscapeMode(Start start) {
        AStringExpression aStringExpression = new AStringExpression(new TString("\"" + this.escapeMode.getEscapeCommand() + "\""));
        PCommand pCommand = start.getPCommand();
        AEscapeCommand aEscapeCommand = new AEscapeCommand(new ACsOpenPosition(new TCsOpen("<?cs ", 0, 0)), aStringExpression, (PCommand)pCommand.clone());
        pCommand.replaceBy(aEscapeCommand);
    }

    public void caseADataCommand(ADataCommand aDataCommand) {
        String string = aDataCommand.getData().getText();
        this.autoEscapeContext.setCurrentPosition(aDataCommand.getData().getLine(), aDataCommand.getData().getPos());
        this.autoEscapeContext.parseData(string);
    }

    public void caseADefCommand(ADefCommand aDefCommand) {
    }

    public void caseAIfCommand(AIfCommand aIfCommand) {
        AutoEscapeContext.AutoEscapeState autoEscapeState;
        this.setCurrentPosition(aIfCommand.getPosition());
        AutoEscapeContext autoEscapeContext = this.autoEscapeContext.cloneCurrentEscapeContext();
        int n = this.autoEscapeContext.getLineNumber();
        int n2 = this.autoEscapeContext.getColumnNumber();
        if (aIfCommand.getBlock() != null) {
            aIfCommand.getBlock().apply(this);
        }
        AutoEscapeContext.AutoEscapeState autoEscapeState2 = this.autoEscapeContext.getCurrentState();
        this.autoEscapeContext = autoEscapeContext;
        if (aIfCommand.getOtherwise() != null) {
            aIfCommand.getOtherwise().apply(this);
        }
        if (!autoEscapeState2.equals((Object)(autoEscapeState = this.autoEscapeContext.getCurrentState()))) {
            throw new JSilverAutoEscapingException("'if/else' branches have different ending contexts " + (Object)((Object)autoEscapeState2) + " and " + (Object)((Object)autoEscapeState), this.templateName, n, n2);
        }
    }

    public void caseAEscapeCommand(AEscapeCommand aEscapeCommand) {
        boolean bl = this.skipAutoEscape;
        this.skipAutoEscape = true;
        aEscapeCommand.getCommand().apply(this);
        this.skipAutoEscape = bl;
    }

    public void caseACallCommand(ACallCommand aCallCommand) {
        this.saveAutoEscapingContext(aCallCommand, aCallCommand.getPosition());
    }

    public void caseALvarCommand(ALvarCommand aLvarCommand) {
        this.saveAutoEscapingContext(aLvarCommand, aLvarCommand.getPosition());
    }

    public void caseAEvarCommand(AEvarCommand aEvarCommand) {
        this.saveAutoEscapingContext(aEvarCommand, aEvarCommand.getPosition());
    }

    public void caseALincludeCommand(ALincludeCommand aLincludeCommand) {
        this.saveAutoEscapingContext(aLincludeCommand, aLincludeCommand.getPosition());
    }

    public void caseAIncludeCommand(AIncludeCommand aIncludeCommand) {
        this.saveAutoEscapingContext(aIncludeCommand, aIncludeCommand.getPosition());
    }

    public void caseAHardLincludeCommand(AHardLincludeCommand aHardLincludeCommand) {
        this.saveAutoEscapingContext(aHardLincludeCommand, aHardLincludeCommand.getPosition());
    }

    public void caseAHardIncludeCommand(AHardIncludeCommand aHardIncludeCommand) {
        this.saveAutoEscapingContext(aHardIncludeCommand, aHardIncludeCommand.getPosition());
    }

    public void caseAVarCommand(AVarCommand aVarCommand) {
        this.applyAutoEscaping(aVarCommand, aVarCommand.getPosition());
    }

    public void caseAAltCommand(AAltCommand aAltCommand) {
        this.applyAutoEscaping(aAltCommand, aAltCommand.getPosition());
    }

    public void caseANameCommand(ANameCommand aNameCommand) {
        this.applyAutoEscaping(aNameCommand, aNameCommand.getPosition());
    }

    public void caseAUvarCommand(AUvarCommand aUvarCommand) {
        this.setCurrentPosition(aUvarCommand.getPosition());
        this.autoEscapeContext.insertText();
    }

    public void caseAContentTypeCommand(AContentTypeCommand aContentTypeCommand) {
        this.setCurrentPosition(aContentTypeCommand.getPosition());
        String string = aContentTypeCommand.getString().getText();
        string = string.substring(1, string.length() - 1);
        this.autoEscapeContext.setContentType(string);
        this.contentTypeCalled = true;
    }

    private void applyAutoEscaping(PCommand pCommand, PPosition pPosition) {
        this.setCurrentPosition(pPosition);
        if (this.skipAutoEscape) {
            return;
        }
        AStringExpression aStringExpression = new AStringExpression(new TString("\"" + this.getEscaping() + "\""));
        AEscapeCommand aEscapeCommand = new AEscapeCommand(pPosition, aStringExpression, (PCommand)pCommand.clone());
        pCommand.replaceBy(aEscapeCommand);
        this.autoEscapeContext.insertText();
    }

    private void setCurrentPosition(PPosition pPosition) {
        pPosition.apply(this);
    }

    public void caseACsOpenPosition(ACsOpenPosition aCsOpenPosition) {
        TCsOpen tCsOpen = aCsOpenPosition.getCsOpen();
        this.autoEscapeContext.setCurrentPosition(tCsOpen.getLine(), tCsOpen.getPos());
    }

    private void saveAutoEscapingContext(Node node, PPosition pPosition) {
        this.setCurrentPosition(pPosition);
        if (this.skipAutoEscape) {
            return;
        }
        EscapeMode escapeMode = this.autoEscapeContext.getEscapeModeForCurrentState();
        AStringExpression aStringExpression = new AStringExpression(new TString("\"" + escapeMode.getEscapeCommand() + "\""));
        AAutoescapeCommand aAutoescapeCommand = new AAutoescapeCommand(pPosition, aStringExpression, (PCommand)node.clone());
        node.replaceBy(aAutoescapeCommand);
        this.autoEscapeContext.insertText();
    }

    private String getEscaping() {
        return this.autoEscapeContext.getEscapingFunctionForCurrentState();
    }
}

