/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.syntax;

import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.AAltCommand;
import com.google.clearsilver.jsilver.syntax.node.ACallCommand;
import com.google.clearsilver.jsilver.syntax.node.ADataCommand;
import com.google.clearsilver.jsilver.syntax.node.ADefCommand;
import com.google.clearsilver.jsilver.syntax.node.AEachCommand;
import com.google.clearsilver.jsilver.syntax.node.AEvarCommand;
import com.google.clearsilver.jsilver.syntax.node.AHardIncludeCommand;
import com.google.clearsilver.jsilver.syntax.node.AHardLincludeCommand;
import com.google.clearsilver.jsilver.syntax.node.AIfCommand;
import com.google.clearsilver.jsilver.syntax.node.AIncludeCommand;
import com.google.clearsilver.jsilver.syntax.node.ALincludeCommand;
import com.google.clearsilver.jsilver.syntax.node.ALoopCommand;
import com.google.clearsilver.jsilver.syntax.node.ALoopIncCommand;
import com.google.clearsilver.jsilver.syntax.node.ALoopToCommand;
import com.google.clearsilver.jsilver.syntax.node.ALvarCommand;
import com.google.clearsilver.jsilver.syntax.node.ANameCommand;
import com.google.clearsilver.jsilver.syntax.node.AUvarCommand;
import com.google.clearsilver.jsilver.syntax.node.AVarCommand;
import com.google.clearsilver.jsilver.syntax.node.AWithCommand;
import com.google.clearsilver.jsilver.syntax.node.EOF;
import com.google.clearsilver.jsilver.syntax.node.TData;
import java.util.ArrayList;
import java.util.List;

public class DataCommandConsolidator
extends DepthFirstAdapter {
    private int currentBlockNestingLevel = 0;
    private final List<ADataCommand> datas = new ArrayList<ADataCommand>();
    private int datasBlockNestingLevel = -1;

    private void barrier() {
        if (this.datas.size() > 1) {
            ADataCommand aDataCommand = this.datas.remove(this.datas.size() - 1);
            StringBuilder stringBuilder = new StringBuilder();
            for (ADataCommand aDataCommand2 : this.datas) {
                stringBuilder.append(aDataCommand2.getData().getText());
                aDataCommand2.replaceBy(null);
            }
            stringBuilder.append(aDataCommand.getData().getText());
            aDataCommand.replaceBy(new ADataCommand(new TData(stringBuilder.toString())));
        }
        this.datas.clear();
        this.datasBlockNestingLevel = -1;
    }

    private void blockEntry() {
        assert (this.datasBlockNestingLevel <= this.currentBlockNestingLevel);
        ++this.currentBlockNestingLevel;
    }

    private void blockExit() {
        assert (this.datasBlockNestingLevel <= this.currentBlockNestingLevel);
        if (this.datasBlockNestingLevel == this.currentBlockNestingLevel) {
            this.barrier();
        }
        --this.currentBlockNestingLevel;
    }

    public void caseADataCommand(ADataCommand aDataCommand) {
        assert (this.datasBlockNestingLevel <= this.currentBlockNestingLevel);
        if (this.currentBlockNestingLevel != this.datasBlockNestingLevel) {
            this.barrier();
        }
        this.datas.add(aDataCommand);
        this.datasBlockNestingLevel = this.currentBlockNestingLevel;
    }

    public void inAVarCommand(AVarCommand aVarCommand) {
        this.barrier();
    }

    public void inALvarCommand(ALvarCommand aLvarCommand) {
        this.barrier();
    }

    public void inAUvarCommand(AUvarCommand aUvarCommand) {
        this.barrier();
    }

    public void inAEvarCommand(AEvarCommand aEvarCommand) {
        this.barrier();
    }

    public void inANameCommand(ANameCommand aNameCommand) {
        this.barrier();
    }

    public void inALoopCommand(ALoopCommand aLoopCommand) {
        this.blockEntry();
    }

    public void inALoopIncCommand(ALoopIncCommand aLoopIncCommand) {
        this.blockEntry();
    }

    public void inALoopToCommand(ALoopToCommand aLoopToCommand) {
        this.blockEntry();
    }

    public void inAEachCommand(AEachCommand aEachCommand) {
        this.blockEntry();
    }

    public void inAWithCommand(AWithCommand aWithCommand) {
        this.blockEntry();
    }

    public void outALoopCommand(ALoopCommand aLoopCommand) {
        this.blockExit();
    }

    public void outALoopIncCommand(ALoopIncCommand aLoopIncCommand) {
        this.blockExit();
    }

    public void outALoopToCommand(ALoopToCommand aLoopToCommand) {
        this.blockExit();
    }

    public void outAEachCommand(AEachCommand aEachCommand) {
        this.blockExit();
    }

    public void outAWithCommand(AWithCommand aWithCommand) {
        this.blockExit();
    }

    public void caseADefCommand(ADefCommand aDefCommand) {
        DataCommandConsolidator dataCommandConsolidator = new DataCommandConsolidator();
        aDefCommand.getCommand().apply(dataCommandConsolidator);
        dataCommandConsolidator.barrier();
    }

    public void inACallCommand(ACallCommand aCallCommand) {
        this.barrier();
    }

    public void caseAIfCommand(AIfCommand aIfCommand) {
        if (aIfCommand.getBlock() != null) {
            this.blockEntry();
            aIfCommand.getBlock().apply(this);
            this.blockExit();
        }
        if (aIfCommand.getOtherwise() != null) {
            this.blockEntry();
            aIfCommand.getOtherwise().apply(this);
            this.blockExit();
        }
    }

    public void inAAltCommand(AAltCommand aAltCommand) {
        this.blockEntry();
    }

    public void outAAltCommand(AAltCommand aAltCommand) {
        this.blockExit();
    }

    public void caseAIncludeCommand(AIncludeCommand aIncludeCommand) {
        this.barrier();
    }

    public void caseAHardIncludeCommand(AHardIncludeCommand aHardIncludeCommand) {
        this.barrier();
    }

    public void caseALincludeCommand(ALincludeCommand aLincludeCommand) {
        this.barrier();
    }

    public void caseAHardLincludeCommand(AHardLincludeCommand aHardLincludeCommand) {
        this.barrier();
    }

    public void caseEOF(EOF eOF) {
        this.barrier();
    }
}

