/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.syntax;

import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.AAltCommand;
import com.google.clearsilver.jsilver.syntax.node.ACallCommand;
import com.google.clearsilver.jsilver.syntax.node.ADataCommand;
import com.google.clearsilver.jsilver.syntax.node.ADefCommand;
import com.google.clearsilver.jsilver.syntax.node.AEachCommand;
import com.google.clearsilver.jsilver.syntax.node.AEscapeCommand;
import com.google.clearsilver.jsilver.syntax.node.AEvarCommand;
import com.google.clearsilver.jsilver.syntax.node.AIfCommand;
import com.google.clearsilver.jsilver.syntax.node.ALoopCommand;
import com.google.clearsilver.jsilver.syntax.node.ALoopIncCommand;
import com.google.clearsilver.jsilver.syntax.node.ALoopToCommand;
import com.google.clearsilver.jsilver.syntax.node.ALvarCommand;
import com.google.clearsilver.jsilver.syntax.node.ANameCommand;
import com.google.clearsilver.jsilver.syntax.node.ANoopCommand;
import com.google.clearsilver.jsilver.syntax.node.ASetCommand;
import com.google.clearsilver.jsilver.syntax.node.AUvarCommand;
import com.google.clearsilver.jsilver.syntax.node.AVarCommand;
import com.google.clearsilver.jsilver.syntax.node.AWithCommand;
import com.google.clearsilver.jsilver.syntax.node.Start;
import com.google.clearsilver.jsilver.syntax.node.TData;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuralWhitespaceStripper
extends DepthFirstAdapter {
    private static final String IWS = "[^\\S\\n]*";
    private static final Pattern INLINE_WHITESPACE = Pattern.compile("[^\\S\\n]*");
    private static final Pattern STARTS_WITH_NEWLINE = Pattern.compile("^[^\\S\\n]*\\n");
    private static final Pattern ENDS_WITH_NEWLINE = Pattern.compile("\\n[^\\S\\n]*$");
    private static final Pattern LEADING_WHITESPACE_AND_NEWLINE = Pattern.compile("^[^\\S\\n]*\\n(.*)$", 32);
    private static final Pattern TRAILING_WHITESPACE = Pattern.compile("^(.*?)[^\\S\\n]*$", 32);
    private boolean maybeChompWhitespace = true;
    private boolean currentLineContainsInlineComplexCommand = false;
    private ADataCommand firstChompedData = null;
    private List<ADataCommand> whitespaceData = new ArrayList<ADataCommand>();

    private static boolean isInlineWhitespace(String string) {
        return INLINE_WHITESPACE.matcher(string).matches();
    }

    private static boolean startsWithNewline(String string) {
        return STARTS_WITH_NEWLINE.matcher(string).find();
    }

    private static boolean endsWithNewline(String string) {
        return ENDS_WITH_NEWLINE.matcher(string).find();
    }

    private static String stripLeadingWhitespaceAndNewline(String string) {
        Matcher matcher = LEADING_WHITESPACE_AND_NEWLINE.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalStateException("Text '" + string + "' should have leading whitespace/newline.");
        }
        return matcher.group(1);
    }

    private static String stripTrailingWhitespace(String string) {
        Matcher matcher = TRAILING_WHITESPACE.matcher(string);
        if (!matcher.matches()) {
            throw new AssertionError((Object)"Error in regular expression");
        }
        return matcher.group(1);
    }

    private static ADataCommand stripLeadingWhitespaceAndNewline(ADataCommand aDataCommand) {
        if (aDataCommand != null) {
            String string = StructuralWhitespaceStripper.stripLeadingWhitespaceAndNewline(aDataCommand.getData().getText());
            if (string.isEmpty()) {
                aDataCommand.replaceBy(new ANoopCommand());
                aDataCommand = null;
            } else {
                aDataCommand.setData(new TData(string));
            }
        }
        return aDataCommand;
    }

    private static void stripTrailingWhitespace(ADataCommand aDataCommand) {
        if (aDataCommand != null) {
            String string = StructuralWhitespaceStripper.stripTrailingWhitespace(aDataCommand.getData().getText());
            if (string.isEmpty()) {
                aDataCommand.replaceBy(new ANoopCommand());
            } else {
                aDataCommand.setData(new TData(string));
            }
        }
    }

    private static void removeWhitespace(List<ADataCommand> list) {
        for (ADataCommand aDataCommand : list) {
            aDataCommand.replaceBy(new ANoopCommand());
        }
        list.clear();
    }

    @Override
    public void caseStart(Start start) {
        super.caseStart(start);
        if (this.maybeChompWhitespace) {
            StructuralWhitespaceStripper.stripTrailingWhitespace(this.firstChompedData);
            StructuralWhitespaceStripper.removeWhitespace(this.whitespaceData);
            this.firstChompedData = null;
        }
        if (this.firstChompedData != null) {
            throw new IllegalStateException("Unexpected first data node.");
        }
        if (!this.whitespaceData.isEmpty()) {
            throw new IllegalStateException("Unexpected data nodes.");
        }
    }

    @Override
    public void caseADataCommand(ADataCommand aDataCommand) {
        String string = aDataCommand.getData().getText();
        if (this.maybeChompWhitespace) {
            if (StructuralWhitespaceStripper.isInlineWhitespace(string)) {
                this.whitespaceData.add(aDataCommand);
                return;
            }
            if (StructuralWhitespaceStripper.startsWithNewline(string)) {
                StructuralWhitespaceStripper.stripTrailingWhitespace(this.firstChompedData);
                StructuralWhitespaceStripper.removeWhitespace(this.whitespaceData);
                aDataCommand = StructuralWhitespaceStripper.stripLeadingWhitespaceAndNewline(aDataCommand);
                this.currentLineContainsInlineComplexCommand = false;
            } else {
                this.abortWhitespaceChompingForCurrentLine();
            }
        }
        this.maybeChompWhitespace = StructuralWhitespaceStripper.endsWithNewline(string);
        this.firstChompedData = this.maybeChompWhitespace ? aDataCommand : null;
    }

    private void abortWhitespaceChompingForCurrentLine() {
        this.maybeChompWhitespace = false;
        this.currentLineContainsInlineComplexCommand = false;
        this.whitespaceData.clear();
    }

    @Override
    public void inAAltCommand(AAltCommand aAltCommand) {
        this.abortWhitespaceChompingForCurrentLine();
    }

    @Override
    public void inACallCommand(ACallCommand aCallCommand) {
        this.abortWhitespaceChompingForCurrentLine();
    }

    @Override
    public void inAEvarCommand(AEvarCommand aEvarCommand) {
        this.abortWhitespaceChompingForCurrentLine();
    }

    @Override
    public void inALvarCommand(ALvarCommand aLvarCommand) {
        this.abortWhitespaceChompingForCurrentLine();
    }

    @Override
    public void inANameCommand(ANameCommand aNameCommand) {
        this.abortWhitespaceChompingForCurrentLine();
    }

    @Override
    public void inASetCommand(ASetCommand aSetCommand) {
        this.abortWhitespaceChompingForCurrentLine();
    }

    @Override
    public void inAUvarCommand(AUvarCommand aUvarCommand) {
        this.abortWhitespaceChompingForCurrentLine();
    }

    @Override
    public void inAVarCommand(AVarCommand aVarCommand) {
        this.abortWhitespaceChompingForCurrentLine();
    }

    public void enterComplexCommand() {
        this.currentLineContainsInlineComplexCommand = true;
    }

    public void exitComplexCommand() {
        if (this.currentLineContainsInlineComplexCommand) {
            this.abortWhitespaceChompingForCurrentLine();
        }
    }

    @Override
    public void caseAAltCommand(AAltCommand aAltCommand) {
        this.enterComplexCommand();
        super.caseAAltCommand(aAltCommand);
        this.exitComplexCommand();
    }

    @Override
    public void caseADefCommand(ADefCommand aDefCommand) {
        this.enterComplexCommand();
        super.caseADefCommand(aDefCommand);
        this.exitComplexCommand();
    }

    @Override
    public void caseAEachCommand(AEachCommand aEachCommand) {
        this.enterComplexCommand();
        super.caseAEachCommand(aEachCommand);
        this.exitComplexCommand();
    }

    @Override
    public void caseAEscapeCommand(AEscapeCommand aEscapeCommand) {
        this.enterComplexCommand();
        super.caseAEscapeCommand(aEscapeCommand);
        this.exitComplexCommand();
    }

    @Override
    public void caseAIfCommand(AIfCommand aIfCommand) {
        this.enterComplexCommand();
        super.caseAIfCommand(aIfCommand);
        this.exitComplexCommand();
    }

    @Override
    public void caseALoopCommand(ALoopCommand aLoopCommand) {
        this.enterComplexCommand();
        super.caseALoopCommand(aLoopCommand);
        this.exitComplexCommand();
    }

    @Override
    public void caseALoopIncCommand(ALoopIncCommand aLoopIncCommand) {
        this.enterComplexCommand();
        super.caseALoopIncCommand(aLoopIncCommand);
        this.exitComplexCommand();
    }

    @Override
    public void caseALoopToCommand(ALoopToCommand aLoopToCommand) {
        this.enterComplexCommand();
        super.caseALoopToCommand(aLoopToCommand);
        this.exitComplexCommand();
    }

    @Override
    public void caseAWithCommand(AWithCommand aWithCommand) {
        this.enterComplexCommand();
        super.caseAWithCommand(aWithCommand);
        this.exitComplexCommand();
    }
}

