/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.syntax;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.exceptions.JSilverIOException;
import com.google.clearsilver.jsilver.syntax.SyntaxTreeBuilder;
import com.google.clearsilver.jsilver.syntax.TemplateSyntaxTree;
import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.EOF;
import com.google.clearsilver.jsilver.syntax.node.Node;
import com.google.clearsilver.jsilver.syntax.node.Start;
import com.google.clearsilver.jsilver.syntax.node.Token;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class SyntaxTreeDumper
extends DepthFirstAdapter {
    private final Appendable out;
    private final String newLine = System.getProperty("line.separator");
    private int indent;

    public SyntaxTreeDumper(Appendable appendable) {
        this.out = appendable;
    }

    public SyntaxTreeDumper() {
        this(System.out);
    }

    public void defaultIn(Node node) {
        this.write(this.nodeName(node) + " {");
        ++this.indent;
    }

    public void defaultOut(Node node) {
        --this.indent;
        this.write("}");
    }

    public void defaultCase(Node node) {
        this.write(this.nodeName(node));
    }

    private String nodeName(Node node) {
        if (node instanceof Start || node instanceof EOF) {
            return node.getClass().getSimpleName();
        }
        if (node instanceof Token) {
            Token token = (Token)node;
            String string = token.getClass().getSimpleName().substring(1);
            return string + " [line:" + token.getLine() + ",pos:" + token.getPos() + "] \"" + this.escape(token.getText()) + "\"";
        }
        String string = node.getClass().getSuperclass().getSimpleName().substring(1);
        String string2 = node.getClass().getSimpleName().substring(1);
        string2 = string2.substring(0, string2.length() - string.length());
        return "<" + string2 + ">" + string;
    }

    private String escape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block7;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block7;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block7;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private void write(String string) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.indent; ++i) {
                stringBuilder.append("  ");
            }
            stringBuilder.append(string);
            stringBuilder.append(this.newLine);
            this.out.append(stringBuilder);
        }
        catch (IOException iOException) {
            throw new JSilverIOException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.err.println("Provide filename of template.");
            return;
        }
        String string = stringArray[0];
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        try {
            SyntaxTreeBuilder syntaxTreeBuilder = new SyntaxTreeBuilder();
            TemplateSyntaxTree templateSyntaxTree = syntaxTreeBuilder.parse(bufferedReader, string, EscapeMode.ESCAPE_NONE);
            templateSyntaxTree.apply(new SyntaxTreeDumper(System.out));
        }
        finally {
            ((Reader)bufferedReader).close();
        }
    }
}

