/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.syntax;

import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.AAddExpression;
import com.google.clearsilver.jsilver.syntax.node.ADecimalExpression;
import com.google.clearsilver.jsilver.syntax.node.ADivideExpression;
import com.google.clearsilver.jsilver.syntax.node.AEqExpression;
import com.google.clearsilver.jsilver.syntax.node.AFunctionExpression;
import com.google.clearsilver.jsilver.syntax.node.AHexExpression;
import com.google.clearsilver.jsilver.syntax.node.AModuloExpression;
import com.google.clearsilver.jsilver.syntax.node.AMultiplyExpression;
import com.google.clearsilver.jsilver.syntax.node.ANameVariable;
import com.google.clearsilver.jsilver.syntax.node.ANeExpression;
import com.google.clearsilver.jsilver.syntax.node.ANegativeExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericAddExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericEqExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericNeExpression;
import com.google.clearsilver.jsilver.syntax.node.ASubtractExpression;
import com.google.clearsilver.jsilver.syntax.node.PExpression;
import com.google.clearsilver.jsilver.syntax.node.PVariable;

public class TypeResolver
extends DepthFirstAdapter {
    public void caseAAddExpression(AAddExpression aAddExpression) {
        super.caseAAddExpression(aAddExpression);
        PExpression pExpression = aAddExpression.getLeft();
        PExpression pExpression2 = aAddExpression.getRight();
        if (TypeResolver.isNumeric(pExpression) || TypeResolver.isNumeric(pExpression2)) {
            aAddExpression.replaceBy(new ANumericAddExpression(pExpression, pExpression2));
        }
    }

    public void caseAEqExpression(AEqExpression aEqExpression) {
        super.caseAEqExpression(aEqExpression);
        PExpression pExpression = aEqExpression.getLeft();
        PExpression pExpression2 = aEqExpression.getRight();
        if (TypeResolver.isNumeric(pExpression) || TypeResolver.isNumeric(pExpression2)) {
            aEqExpression.replaceBy(new ANumericEqExpression(pExpression, pExpression2));
        }
    }

    public void caseANeExpression(ANeExpression aNeExpression) {
        super.caseANeExpression(aNeExpression);
        PExpression pExpression = aNeExpression.getLeft();
        PExpression pExpression2 = aNeExpression.getRight();
        if (TypeResolver.isNumeric(pExpression) || TypeResolver.isNumeric(pExpression2)) {
            aNeExpression.replaceBy(new ANumericNeExpression(pExpression, pExpression2));
        }
    }

    static boolean isNumeric(PExpression pExpression) {
        return pExpression instanceof ANumericExpression || pExpression instanceof ANumericAddExpression || pExpression instanceof ASubtractExpression || pExpression instanceof AMultiplyExpression || pExpression instanceof ADivideExpression || pExpression instanceof AModuloExpression || pExpression instanceof ADecimalExpression || pExpression instanceof AHexExpression || pExpression instanceof ANegativeExpression || TypeResolver.isNumericFunction(pExpression);
    }

    static boolean isNumericFunction(PExpression pExpression) {
        String string;
        if (!(pExpression instanceof AFunctionExpression)) {
            return false;
        }
        PVariable pVariable = ((AFunctionExpression)pExpression).getName();
        return pVariable instanceof ANameVariable && ("max".equals(string = ((ANameVariable)pVariable).getWord().getText()) || "min".equals(string) || "abs".equals(string) || "subcount".equals(string));
    }
}

