/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.syntax;

import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.AAddExpression;
import com.google.clearsilver.jsilver.syntax.node.AEscapeCommand;
import com.google.clearsilver.jsilver.syntax.node.AFunctionExpression;
import com.google.clearsilver.jsilver.syntax.node.AMultipleCommand;
import com.google.clearsilver.jsilver.syntax.node.ANameVariable;
import com.google.clearsilver.jsilver.syntax.node.AStringExpression;
import com.google.clearsilver.jsilver.syntax.node.AVarCommand;
import com.google.clearsilver.jsilver.syntax.node.Node;
import com.google.clearsilver.jsilver.syntax.node.PCommand;
import com.google.clearsilver.jsilver.syntax.node.PExpression;
import com.google.clearsilver.jsilver.syntax.node.PPosition;
import com.google.clearsilver.jsilver.syntax.node.PVariable;
import com.google.clearsilver.jsilver.syntax.node.TString;
import java.util.Collection;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarOptimizer
extends DepthFirstAdapter {
    private final Collection<String> escaperNames;
    private static final String ESCAPE_SUFFIX = "_escape";

    public VarOptimizer(Collection<String> collection) {
        this.escaperNames = collection;
    }

    @Override
    public void caseAMultipleCommand(AMultipleCommand aMultipleCommand) {
        super.caseAMultipleCommand(aMultipleCommand);
        aMultipleCommand.replaceBy(VarOptimizer.optimizeEscapeSequences(aMultipleCommand));
    }

    @Override
    public void caseAVarCommand(AVarCommand aVarCommand) {
        super.caseAVarCommand(aVarCommand);
        aVarCommand.replaceBy(this.optimizeVarCommands(aVarCommand));
    }

    private PCommand optimizeVarCommands(AVarCommand aVarCommand) {
        LinkedList<PExpression> linkedList;
        AFunctionExpression aFunctionExpression;
        String string;
        PExpression pExpression = aVarCommand.getExpression();
        PPosition pPosition = aVarCommand.getPosition();
        if (pExpression instanceof AAddExpression) {
            AAddExpression aAddExpression = (AAddExpression)pExpression;
            AMultipleCommand aMultipleCommand = new AMultipleCommand();
            VarOptimizer.addToContents(aMultipleCommand, this.optimizedVarCommandOf(pPosition, aAddExpression.getLeft()));
            VarOptimizer.addToContents(aMultipleCommand, this.optimizedVarCommandOf(pPosition, aAddExpression.getRight()));
            return VarOptimizer.optimizeEscapeSequences(aMultipleCommand);
        }
        if (pExpression instanceof AFunctionExpression && this.escaperNames.contains(string = VarOptimizer.escapeNameOf(aFunctionExpression = (AFunctionExpression)pExpression)) && (linkedList = aFunctionExpression.getArgs()).size() == 1) {
            return new AEscapeCommand(pPosition, VarOptimizer.quotedStringExpressionOf(string), this.optimizedVarCommandOf(pPosition, linkedList.getFirst()));
        }
        return aVarCommand;
    }

    private PCommand optimizedVarCommandOf(PPosition pPosition, PExpression pExpression) {
        return this.optimizeVarCommands(new AVarCommand(VarOptimizer.cloneOf(pPosition), VarOptimizer.cloneOf(pExpression)));
    }

    private static <T extends Node> T cloneOf(T t) {
        return (T)((Node)t.clone());
    }

    private static void addToContents(AMultipleCommand aMultipleCommand, PCommand pCommand) {
        if (pCommand instanceof AMultipleCommand) {
            aMultipleCommand.getCommand().addAll(((AMultipleCommand)pCommand).getCommand());
        } else {
            aMultipleCommand.getCommand().add(pCommand);
        }
    }

    private static String escapeNameOf(AFunctionExpression aFunctionExpression) {
        PVariable pVariable = aFunctionExpression.getName();
        if (!(pVariable instanceof ANameVariable)) {
            return null;
        }
        String string = ((ANameVariable)pVariable).getWord().getText();
        if (!string.endsWith(ESCAPE_SUFFIX)) {
            return null;
        }
        return string.substring(0, string.length() - ESCAPE_SUFFIX.length());
    }

    private static AStringExpression quotedStringExpressionOf(String string) {
        assert (string.indexOf(34) == -1);
        return new AStringExpression(new TString('\"' + string + '\"'));
    }

    private static PCommand optimizeEscapeSequences(AMultipleCommand aMultipleCommand) {
        AEscapeCommand aEscapeCommand = null;
        LinkedList<PCommand> linkedList = new LinkedList<PCommand>();
        for (PCommand pCommand : aMultipleCommand.getCommand()) {
            AEscapeCommand aEscapeCommand2 = VarOptimizer.asSimpleEscapeCommand(pCommand);
            if (VarOptimizer.isSameEscaper(aEscapeCommand2, aEscapeCommand)) {
                VarOptimizer.addToContents(VarOptimizer.contentsOf(aEscapeCommand), aEscapeCommand2.getCommand());
                continue;
            }
            linkedList.add(pCommand);
            aEscapeCommand = aEscapeCommand2;
        }
        assert (!linkedList.isEmpty());
        return linkedList.size() > 1 ? new AMultipleCommand(linkedList) : (PCommand)linkedList.getFirst();
    }

    private static AMultipleCommand contentsOf(AEscapeCommand aEscapeCommand) {
        PCommand pCommand = aEscapeCommand.getCommand();
        if (pCommand instanceof AMultipleCommand) {
            return (AMultipleCommand)pCommand;
        }
        AMultipleCommand aMultipleCommand = new AMultipleCommand();
        aMultipleCommand.getCommand().add(pCommand);
        aEscapeCommand.setCommand(aMultipleCommand);
        return aMultipleCommand;
    }

    private static AEscapeCommand asSimpleEscapeCommand(PCommand pCommand) {
        if (!(pCommand instanceof AEscapeCommand)) {
            return null;
        }
        AEscapeCommand aEscapeCommand = (AEscapeCommand)pCommand;
        if (!(aEscapeCommand.getExpression() instanceof AStringExpression)) {
            return null;
        }
        return aEscapeCommand;
    }

    private static boolean isSameEscaper(AEscapeCommand aEscapeCommand, AEscapeCommand aEscapeCommand2) {
        if (aEscapeCommand == null || aEscapeCommand2 == null) {
            return false;
        }
        return VarOptimizer.simpleNameOf(aEscapeCommand).equals(VarOptimizer.simpleNameOf(aEscapeCommand2));
    }

    private static String simpleNameOf(AEscapeCommand aEscapeCommand) {
        return ((AStringExpression)aEscapeCommand.getExpression()).getValue().getText();
    }
}

