/*
 * Decompiled with CFR 0.152.
 */
package com.google.streamhtmlparser.util;

import com.google.common.collect.ImmutableSortedSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HtmlUtils {
    private static final String META_REDIRECT_REGEX = "^\\s*\\d*\\s*;\\s*URL\\s*=\\s*['\"]?";
    private static final Pattern META_REDIRECT_PATTERN = Pattern.compile("^\\s*\\d*\\s*;\\s*URL\\s*=\\s*['\"]?", 2);
    private static final Set<String> REGEXP_TOKEN_PREFIXS = ImmutableSortedSet.of((Comparable[])new String[]{"abstract", "break", "case", "catch", "class", "const", "continue", "debugger", "default", "delete", "do", "else", "enum", "eval", "export", "extends", "field", "final", "finally", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "native", "new", "package", "private", "protected", "public", "return", "static", "switch", "synchronized", "throw", "throws", "transient", "try", "typeof", "var", "void", "volatile", "while", "with"});
    private static final Set<String> ATTRIBUTE_EXPECTS_URI = ImmutableSortedSet.of((Comparable[])new String[]{"action", "archive", "background", "cite", "classid", "codebase", "data", "dynsrc", "href", "longdesc", "src", "usemap"});
    private static final Set<Character> JAVASCRIPT_WHITESPACE = ImmutableSortedSet.of((Comparable[])new Character[]{Character.valueOf('\t'), Character.valueOf('\n'), Character.valueOf('\u000b'), Character.valueOf('\f'), Character.valueOf('\r'), Character.valueOf(' '), Character.valueOf('\u00a0'), Character.valueOf('\u2028'), Character.valueOf('\u2029')});
    private static final Set<Character> HTML_WHITESPACE = ImmutableSortedSet.of((Comparable)Character.valueOf(' '), (Comparable)Character.valueOf('\t'), (Comparable)Character.valueOf('\n'), (Comparable)Character.valueOf('\r'), (Comparable)Character.valueOf('\u200b'));

    private HtmlUtils() {
    }

    public static boolean isAttributeJavascript(String string) {
        return string != null && string.startsWith("on");
    }

    public static boolean isAttributeStyle(String string) {
        return "style".equals(string);
    }

    public static boolean isAttributeUri(String string) {
        return ATTRIBUTE_EXPECTS_URI.contains(string);
    }

    public static boolean isHtmlSpace(char c) {
        return HTML_WHITESPACE.contains(Character.valueOf(c));
    }

    public static boolean isJavascriptWhitespace(char c) {
        return JAVASCRIPT_WHITESPACE.contains(Character.valueOf(c));
    }

    public static boolean isJavascriptIdentifier(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '$';
    }

    public static boolean isJavascriptRegexpPrefix(String string) {
        return REGEXP_TOKEN_PREFIXS.contains(string);
    }

    public static String encodeCharForAscii(char c) {
        if (c == '\'') {
            return "\\'";
        }
        if (c == '\\') {
            return "\\\\";
        }
        if (c >= ' ' && c <= '~') {
            return String.format("%c", Character.valueOf(c));
        }
        if (c == '\n') {
            return "\\n";
        }
        if (c == '\r') {
            return "\\r";
        }
        if (c == '\t') {
            return "\\t";
        }
        return String.format("\\u%04x", c);
    }

    public static META_REDIRECT_TYPE parseContentAttributeForUrl(String string) {
        if (string == null) {
            return META_REDIRECT_TYPE.NONE;
        }
        Matcher matcher = META_REDIRECT_PATTERN.matcher(string);
        if (!matcher.find()) {
            return META_REDIRECT_TYPE.NONE;
        }
        if (string.length() > matcher.end()) {
            return META_REDIRECT_TYPE.URL;
        }
        return META_REDIRECT_TYPE.URL_START;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum META_REDIRECT_TYPE {
        NONE,
        URL_START,
        URL;

    }
}

