/*
 * Decompiled with CFR 0.152.
 */
package org.clearsilver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.TimeZone;
import org.clearsilver.CSFileLoader;
import org.clearsilver.HDF;

public abstract class DelegatedHdf
implements HDF {
    private final HDF hdf;

    public DelegatedHdf(HDF hDF) {
        if (hDF == null) {
            throw new NullPointerException("Null HDF is not allowed in constructor of DelegatedHdf.");
        }
        this.hdf = hDF;
    }

    public static HDF getFullyUnwrappedHdf(HDF hDF) {
        while (hDF instanceof DelegatedHdf) {
            hDF = ((DelegatedHdf)hDF).getHdf();
        }
        return hDF;
    }

    public HDF getHdf() {
        return this.hdf;
    }

    protected abstract DelegatedHdf newDelegatedHdf(HDF var1);

    public void close() {
        this.getHdf().close();
    }

    public boolean readFile(String string) throws IOException, FileNotFoundException {
        return this.getHdf().readFile(string);
    }

    public CSFileLoader getFileLoader() {
        return this.getHdf().getFileLoader();
    }

    public void setFileLoader(CSFileLoader cSFileLoader) {
        this.getHdf().setFileLoader(cSFileLoader);
    }

    public boolean writeFile(String string) throws IOException {
        return this.getHdf().writeFile(string);
    }

    public boolean readString(String string) {
        return this.getHdf().readString(string);
    }

    public String writeString() {
        return this.getHdf().writeString();
    }

    public int getIntValue(String string, int n) {
        return this.getHdf().getIntValue(string, n);
    }

    public String getValue(String string, String string2) {
        return this.getHdf().getValue(string, string2);
    }

    public void setValue(String string, String string2) {
        this.getHdf().setValue(string, string2);
    }

    public void removeTree(String string) {
        this.getHdf().removeTree(string);
    }

    public void setSymLink(String string, String string2) {
        this.getHdf().setSymLink(string, string2);
    }

    public void exportDate(String string, TimeZone timeZone, Date date) {
        this.getHdf().exportDate(string, timeZone, date);
    }

    public void exportDate(String string, String string2, int n) {
        this.getHdf().exportDate(string, string2, n);
    }

    public DelegatedHdf getObj(String string) {
        HDF hDF = this.getHdf().getObj(string);
        return hDF != null ? this.newDelegatedHdf(hDF) : null;
    }

    public DelegatedHdf getChild(String string) {
        HDF hDF = this.getHdf().getChild(string);
        return hDF != null ? this.newDelegatedHdf(hDF) : null;
    }

    public DelegatedHdf getRootObj() {
        HDF hDF = this.getHdf().getRootObj();
        return hDF != null ? this.newDelegatedHdf(hDF) : null;
    }

    public boolean belongsToSameRoot(HDF hDF) {
        return DelegatedHdf.getFullyUnwrappedHdf(this).belongsToSameRoot(DelegatedHdf.getFullyUnwrappedHdf(hDF));
    }

    public DelegatedHdf getOrCreateObj(String string) {
        HDF hDF = this.getHdf().getOrCreateObj(string);
        return hDF != null ? this.newDelegatedHdf(hDF) : null;
    }

    public String objName() {
        return this.getHdf().objName();
    }

    public String objValue() {
        return this.getHdf().objValue();
    }

    public DelegatedHdf objChild() {
        HDF hDF = this.getHdf().objChild();
        return hDF != null ? this.newDelegatedHdf(hDF) : null;
    }

    public DelegatedHdf objNext() {
        HDF hDF = this.getHdf().objNext();
        return hDF != null ? this.newDelegatedHdf(hDF) : null;
    }

    public void copy(String string, HDF hDF) {
        if (hDF != null && hDF instanceof DelegatedHdf) {
            hDF = ((DelegatedHdf)hDF).getHdf();
        }
        this.getHdf().copy(string, hDF);
    }

    public String dump() {
        return this.getHdf().dump();
    }
}

