/*
 * Decompiled with CFR 0.152.
 */
package org.clearsilver.jni;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.clearsilver.CS;
import org.clearsilver.CSFileLoader;
import org.clearsilver.HDF;
import org.clearsilver.jni.JNI;
import org.clearsilver.jni.JniHdf;

public class JniCs
implements CS {
    long csptr;
    protected JniHdf globalHDF = null;
    protected JniHdf localHDF;
    private CSFileLoader fileLoader = null;

    JniCs(JniHdf jniHdf) {
        this.localHDF = jniHdf;
        this.csptr = this._init(jniHdf.hdfptr);
    }

    JniCs(JniHdf jniHdf, JniHdf jniHdf2) {
        this(jniHdf);
        this.globalHDF = jniHdf2;
        if (jniHdf2 != null) {
            this._setGlobalHdf(this.csptr, jniHdf2.hdfptr);
        }
    }

    public void setGlobalHDF(HDF hDF) {
        JniHdf jniHdf = JniHdf.cast(hDF);
        this._setGlobalHdf(this.csptr, jniHdf.hdfptr);
        this.globalHDF = jniHdf;
    }

    public HDF getGlobalHDF() {
        return this.globalHDF;
    }

    public void close() {
        if (this.csptr != 0L) {
            this._dealloc(this.csptr);
            this.csptr = 0L;
        }
    }

    protected void finalize() {
        this.close();
    }

    public void parseFile(String string) throws IOException {
        if (this.csptr == 0L) {
            throw new NullPointerException("CS is closed.");
        }
        this._parseFile(this.csptr, string, this.fileLoader != null);
    }

    public void parseStr(String string) {
        if (this.csptr == 0L) {
            throw new NullPointerException("CS is closed.");
        }
        this._parseStr(this.csptr, string);
    }

    public String render() {
        if (this.csptr == 0L) {
            throw new NullPointerException("CS is closed.");
        }
        return this._render(this.csptr, this.fileLoader != null);
    }

    protected String fileLoad(String string) throws IOException, FileNotFoundException {
        if (this.csptr == 0L) {
            throw new NullPointerException("CS is closed.");
        }
        CSFileLoader cSFileLoader = this.fileLoader;
        if (cSFileLoader == null) {
            throw new NullPointerException("No fileLoader specified.");
        }
        String string2 = cSFileLoader.load(this.localHDF, string);
        if (string2 == null) {
            throw new NullPointerException("CSFileLoader.load() returned null");
        }
        return string2;
    }

    public CSFileLoader getFileLoader() {
        return this.fileLoader;
    }

    public void setFileLoader(CSFileLoader cSFileLoader) {
        this.fileLoader = cSFileLoader;
    }

    private native long _init(long var1);

    private native void _dealloc(long var1);

    private native void _parseFile(long var1, String var3, boolean var4) throws IOException;

    private native void _parseStr(long var1, String var3);

    private native String _render(long var1, boolean var3);

    private native void _setGlobalHdf(long var1, long var3);

    static {
        JNI.loadLibrary();
    }
}

