/*
 * Decompiled with CFR 0.152.
 */
package org.clearsilver.jni;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.clearsilver.CSFileLoader;
import org.clearsilver.HDF;
import org.clearsilver.jni.JNI;

public class JniHdf
implements HDF {
    long hdfptr;
    JniHdf root;
    private CSFileLoader fileLoader = null;

    static JniHdf cast(HDF hDF) {
        if (!(hDF instanceof JniHdf)) {
            throw new IllegalArgumentException("HDF object not of type JniHdf.  Make sure you use the same ClearsilverFactory to construct all related HDF and CS objects.");
        }
        return (JniHdf)hDF;
    }

    public JniHdf() {
        this.hdfptr = JniHdf._init();
        this.root = null;
    }

    protected JniHdf(long l, JniHdf jniHdf) {
        this.hdfptr = l;
        this.root = jniHdf.root != null ? jniHdf.root : jniHdf;
    }

    protected JniHdf newHdf(long l, HDF hDF) {
        return new JniHdf(l, JniHdf.cast(hDF));
    }

    public void close() {
        if (this.root == null && this.hdfptr != 0L) {
            JniHdf._dealloc(this.hdfptr);
            this.hdfptr = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public boolean readFile(String string) throws IOException {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        return this._readFile(this.hdfptr, string, this.fileLoader != null);
    }

    protected String fileLoad(String string) throws IOException {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        CSFileLoader cSFileLoader = this.fileLoader;
        if (cSFileLoader == null) {
            throw new NullPointerException("No fileLoader specified.");
        }
        String string2 = cSFileLoader.load(this, string);
        if (string2 == null) {
            throw new NullPointerException("CSFileLoader.load() returned null");
        }
        return string2;
    }

    public CSFileLoader getFileLoader() {
        return this.fileLoader;
    }

    public void setFileLoader(CSFileLoader cSFileLoader) {
        this.fileLoader = cSFileLoader;
    }

    public boolean writeFile(String string) throws IOException {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        return JniHdf._writeFile(this.hdfptr, string);
    }

    public boolean readString(String string) {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        return JniHdf._readString(this.hdfptr, string);
    }

    public String writeString() {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        return JniHdf._writeString(this.hdfptr);
    }

    public int getIntValue(String string, int n) {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        return JniHdf._getIntValue(this.hdfptr, string, n);
    }

    public String getValue(String string, String string2) {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        return JniHdf._getValue(this.hdfptr, string, string2);
    }

    public void setValue(String string, String string2) {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        JniHdf._setValue(this.hdfptr, string, string2);
    }

    public void removeTree(String string) {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        JniHdf._removeTree(this.hdfptr, string);
    }

    public void setSymLink(String string, String string2) {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        JniHdf._setSymLink(this.hdfptr, string, string2);
    }

    public void exportDate(String string, TimeZone timeZone, Date date) {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        String string2 = Integer.toString(calendar.get(13));
        this.setValue(string + ".sec", string2.length() == 1 ? "0" + string2 : string2);
        String string3 = Integer.toString(calendar.get(12));
        this.setValue(string + ".min", string3.length() == 1 ? "0" + string3 : string3);
        this.setValue(string + ".24hour", Integer.toString(calendar.get(11)));
        this.setValue(string + ".hour", Integer.toString(calendar.get(10) == 0 ? 12 : calendar.get(10)));
        this.setValue(string + ".am", calendar.get(9) == 0 ? "1" : "0");
        this.setValue(string + ".mday", Integer.toString(calendar.get(5)));
        this.setValue(string + ".mon", Integer.toString(calendar.get(2) + 1));
        this.setValue(string + ".year", Integer.toString(calendar.get(1)));
        this.setValue(string + ".2yr", Integer.toString(calendar.get(1)).substring(2));
        this.setValue(string + ".wday", Integer.toString(calendar.get(7) - 1));
        boolean bl = timeZone.getRawOffset() < 0;
        int n = Math.abs(timeZone.getRawOffset() / 1000);
        String string4 = Integer.toString(n / 3600);
        String string5 = Integer.toString(n / 60 - n / 3600 * 60);
        String string6 = (bl ? "-" : "+") + (string4.length() == 1 ? "0" + string4 : string4) + (string5.length() == 1 ? "0" + string5 : string5);
        this.setValue(string + ".tzoffset", string6);
    }

    public void exportDate(String string, String string2, int n) {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        TimeZone timeZone = TimeZone.getTimeZone(string2);
        if (timeZone == null) {
            throw new RuntimeException("Unknown timezone: " + string2);
        }
        Date date = new Date((long)n * 1000L);
        this.exportDate(string, timeZone, date);
    }

    public JniHdf getObj(String string) {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        long l = JniHdf._getObj(this.hdfptr, string);
        if (l == 0L) {
            return null;
        }
        return this.newHdf(l, this);
    }

    public JniHdf getChild(String string) {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        long l = JniHdf._getChild(this.hdfptr, string);
        if (l == 0L) {
            return null;
        }
        return this.newHdf(l, this);
    }

    public JniHdf getRootObj() {
        return this.root != null ? this.root : this;
    }

    public boolean belongsToSameRoot(HDF hDF) {
        JniHdf jniHdf = JniHdf.cast(hDF);
        return this.getRootObj() == jniHdf.getRootObj();
    }

    public JniHdf getOrCreateObj(String string) {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        long l = JniHdf._getObj(this.hdfptr, string);
        if (l == 0L) {
            JniHdf._setValue(this.hdfptr, string, "");
            l = JniHdf._getObj(this.hdfptr, string);
            if (l == 0L) {
                return null;
            }
        }
        return this.newHdf(l, this);
    }

    public String objName() {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        return JniHdf._objName(this.hdfptr);
    }

    public String objValue() {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        return JniHdf._objValue(this.hdfptr);
    }

    public JniHdf objChild() {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        long l = JniHdf._objChild(this.hdfptr);
        if (l == 0L) {
            return null;
        }
        return this.newHdf(l, this);
    }

    public JniHdf objNext() {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        long l = JniHdf._objNext(this.hdfptr);
        if (l == 0L) {
            return null;
        }
        return this.newHdf(l, this);
    }

    public void copy(String string, HDF hDF) {
        JniHdf jniHdf = JniHdf.cast(hDF);
        if (this.hdfptr == 0L || jniHdf.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        JniHdf._copy(this.hdfptr, string, jniHdf.hdfptr);
    }

    public String dump() {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        return JniHdf._dump(this.hdfptr);
    }

    private static native long _init();

    private static native void _dealloc(long var0);

    private native boolean _readFile(long var1, String var3, boolean var4) throws IOException;

    private static native boolean _writeFile(long var0, String var2);

    private static native boolean _readString(long var0, String var2);

    private static native String _writeString(long var0);

    private static native int _getIntValue(long var0, String var2, int var3);

    private static native String _getValue(long var0, String var2, String var3);

    private static native void _setValue(long var0, String var2, String var3);

    private static native void _removeTree(long var0, String var2);

    private static native void _setSymLink(long var0, String var2, String var3);

    private static native long _getObj(long var0, String var2);

    private static native long _getChild(long var0, String var2);

    private static native long _objChild(long var0);

    private static native long _objNext(long var0);

    private static native String _objName(long var0);

    private static native String _objValue(long var0);

    private static native void _copy(long var0, String var2, long var3);

    private static native String _dump(long var0);

    static {
        JNI.loadLibrary();
    }
}

