/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AllocationInfo;
import com.android.ddmlib.Client;
import com.android.ddmlib.HeapSegment;
import com.android.ddmlib.NativeAllocationInfo;
import com.android.ddmlib.NativeLibraryMapInfo;
import com.android.ddmlib.ThreadInfo;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientData {
    private static final String PRE_INITIALIZED = "<pre-initialized>";
    public static final String HEAP_MAX_SIZE_BYTES = "maxSizeInBytes";
    public static final String HEAP_SIZE_BYTES = "sizeInBytes";
    public static final String HEAP_BYTES_ALLOCATED = "bytesAllocated";
    public static final String HEAP_OBJECTS_ALLOCATED = "objectsAllocated";
    public static final String FEATURE_PROFILING = "method-trace-profiling";
    public static final String FEATURE_PROFILING_STREAMING = "method-trace-profiling-streaming";
    public static final String FEATURE_HPROF = "hprof-heap-dump";
    public static final String FEATURE_HPROF_STREAMING = "hprof-heap-dump-streaming";
    private static IHprofDumpHandler sHprofDumpHandler;
    private static IMethodProfilingHandler sMethodProfilingHandler;
    private boolean mIsDdmAware;
    private final int mPid;
    private String mVmIdentifier;
    private String mClientDescription;
    private DebuggerStatus mDebuggerInterest;
    private final HashSet<String> mFeatures = new HashSet();
    private TreeMap<Integer, ThreadInfo> mThreadMap;
    private final HeapData mHeapData = new HeapData();
    private final HeapData mNativeHeapData = new HeapData();
    private HashMap<Integer, HashMap<String, Long>> mHeapInfoMap = new HashMap();
    private ArrayList<NativeLibraryMapInfo> mNativeLibMapInfo = new ArrayList();
    private ArrayList<NativeAllocationInfo> mNativeAllocationList = new ArrayList();
    private int mNativeTotalMemory;
    private AllocationInfo[] mAllocations;
    private AllocationTrackingStatus mAllocationStatus = AllocationTrackingStatus.UNKNOWN;
    private String mPendingHprofDump;
    private MethodProfilingStatus mProfilingStatus = MethodProfilingStatus.UNKNOWN;
    private String mPendingMethodProfiling;

    public static void setHprofDumpHandler(IHprofDumpHandler iHprofDumpHandler) {
        sHprofDumpHandler = iHprofDumpHandler;
    }

    static IHprofDumpHandler getHprofDumpHandler() {
        return sHprofDumpHandler;
    }

    public static void setMethodProfilingHandler(IMethodProfilingHandler iMethodProfilingHandler) {
        sMethodProfilingHandler = iMethodProfilingHandler;
    }

    static IMethodProfilingHandler getMethodProfilingHandler() {
        return sMethodProfilingHandler;
    }

    ClientData(int n) {
        this.mPid = n;
        this.mDebuggerInterest = DebuggerStatus.DEFAULT;
        this.mThreadMap = new TreeMap();
    }

    public boolean isDdmAware() {
        return this.mIsDdmAware;
    }

    void isDdmAware(boolean bl) {
        this.mIsDdmAware = bl;
    }

    public int getPid() {
        return this.mPid;
    }

    public String getVmIdentifier() {
        return this.mVmIdentifier;
    }

    void setVmIdentifier(String string) {
        this.mVmIdentifier = string;
    }

    public String getClientDescription() {
        return this.mClientDescription;
    }

    void setClientDescription(String string) {
        if (this.mClientDescription == null && string.length() > 0 && !PRE_INITIALIZED.equals(string)) {
            this.mClientDescription = string;
        }
    }

    public DebuggerStatus getDebuggerConnectionStatus() {
        return this.mDebuggerInterest;
    }

    void setDebuggerConnectionStatus(DebuggerStatus debuggerStatus) {
        this.mDebuggerInterest = debuggerStatus;
    }

    synchronized void setHeapInfo(int n, long l, long l2, long l3, long l4) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put(HEAP_MAX_SIZE_BYTES, l);
        hashMap.put(HEAP_SIZE_BYTES, l2);
        hashMap.put(HEAP_BYTES_ALLOCATED, l3);
        hashMap.put(HEAP_OBJECTS_ALLOCATED, l4);
        this.mHeapInfoMap.put(n, hashMap);
    }

    public HeapData getVmHeapData() {
        return this.mHeapData;
    }

    HeapData getNativeHeapData() {
        return this.mNativeHeapData;
    }

    public synchronized Iterator<Integer> getVmHeapIds() {
        return this.mHeapInfoMap.keySet().iterator();
    }

    public synchronized Map<String, Long> getVmHeapInfo(int n) {
        return this.mHeapInfoMap.get(n);
    }

    synchronized void addThread(int n, String string) {
        ThreadInfo threadInfo = new ThreadInfo(n, string);
        this.mThreadMap.put(n, threadInfo);
    }

    synchronized void removeThread(int n) {
        this.mThreadMap.remove(n);
    }

    public synchronized ThreadInfo[] getThreads() {
        Collection<ThreadInfo> collection = this.mThreadMap.values();
        return collection.toArray(new ThreadInfo[collection.size()]);
    }

    synchronized ThreadInfo getThread(int n) {
        return this.mThreadMap.get(n);
    }

    synchronized void clearThreads() {
        this.mThreadMap.clear();
    }

    public synchronized List<NativeAllocationInfo> getNativeAllocationList() {
        return Collections.unmodifiableList(this.mNativeAllocationList);
    }

    synchronized void addNativeAllocation(NativeAllocationInfo nativeAllocationInfo) {
        this.mNativeAllocationList.add(nativeAllocationInfo);
    }

    synchronized void clearNativeAllocationInfo() {
        this.mNativeAllocationList.clear();
    }

    public synchronized int getTotalNativeMemory() {
        return this.mNativeTotalMemory;
    }

    synchronized void setTotalNativeMemory(int n) {
        this.mNativeTotalMemory = n;
    }

    synchronized void addNativeLibraryMapInfo(long l, long l2, String string) {
        this.mNativeLibMapInfo.add(new NativeLibraryMapInfo(l, l2, string));
    }

    public synchronized List<NativeLibraryMapInfo> getMappedNativeLibraries() {
        return Collections.unmodifiableList(this.mNativeLibMapInfo);
    }

    synchronized void setAllocationStatus(AllocationTrackingStatus allocationTrackingStatus) {
        this.mAllocationStatus = allocationTrackingStatus;
    }

    public synchronized AllocationTrackingStatus getAllocationStatus() {
        return this.mAllocationStatus;
    }

    synchronized void setAllocations(AllocationInfo[] allocationInfoArray) {
        this.mAllocations = allocationInfoArray;
    }

    public synchronized AllocationInfo[] getAllocations() {
        return this.mAllocations;
    }

    void addFeature(String string) {
        this.mFeatures.add(string);
    }

    public boolean hasFeature(String string) {
        return this.mFeatures.contains(string);
    }

    void setPendingHprofDump(String string) {
        this.mPendingHprofDump = string;
    }

    String getPendingHprofDump() {
        return this.mPendingHprofDump;
    }

    public boolean hasPendingHprofDump() {
        return this.mPendingHprofDump != null;
    }

    synchronized void setMethodProfilingStatus(MethodProfilingStatus methodProfilingStatus) {
        this.mProfilingStatus = methodProfilingStatus;
    }

    public synchronized MethodProfilingStatus getMethodProfilingStatus() {
        return this.mProfilingStatus;
    }

    void setPendingMethodProfiling(String string) {
        this.mPendingMethodProfiling = string;
    }

    String getPendingMethodProfiling() {
        return this.mPendingMethodProfiling;
    }

    public static interface IMethodProfilingHandler {
        public void onSuccess(String var1, Client var2);

        public void onSuccess(byte[] var1, Client var2);

        public void onStartFailure(Client var1, String var2);

        public void onEndFailure(Client var1, String var2);
    }

    public static interface IHprofDumpHandler {
        public void onSuccess(String var1, Client var2);

        public void onSuccess(byte[] var1, Client var2);

        public void onEndFailure(Client var1, String var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HeapData {
        private TreeSet<HeapSegment> mHeapSegments = new TreeSet();
        private boolean mHeapDataComplete = false;
        private byte[] mProcessedHeapData;
        private Map<Integer, ArrayList<HeapSegment.HeapSegmentElement>> mProcessedHeapMap;

        public synchronized void clearHeapData() {
            this.mHeapSegments = new TreeSet();
            this.mHeapDataComplete = false;
        }

        synchronized void addHeapData(ByteBuffer byteBuffer) {
            HeapSegment heapSegment;
            if (this.mHeapDataComplete) {
                this.clearHeapData();
            }
            try {
                heapSegment = new HeapSegment(byteBuffer);
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                System.err.println("Discarding short HPSG data (length " + byteBuffer.limit() + ")");
                return;
            }
            this.mHeapSegments.add(heapSegment);
        }

        synchronized void sealHeapData() {
            this.mHeapDataComplete = true;
        }

        public boolean isHeapDataComplete() {
            return this.mHeapDataComplete;
        }

        public Collection<HeapSegment> getHeapSegments() {
            if (this.isHeapDataComplete()) {
                return this.mHeapSegments;
            }
            return null;
        }

        public void setProcessedHeapData(byte[] byArray) {
            this.mProcessedHeapData = byArray;
        }

        public byte[] getProcessedHeapData() {
            return this.mProcessedHeapData;
        }

        public void setProcessedHeapMap(Map<Integer, ArrayList<HeapSegment.HeapSegmentElement>> map) {
            this.mProcessedHeapMap = map;
        }

        public Map<Integer, ArrayList<HeapSegment.HeapSegmentElement>> getProcessedHeapMap() {
            return this.mProcessedHeapMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MethodProfilingStatus {
        UNKNOWN,
        OFF,
        ON;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AllocationTrackingStatus {
        UNKNOWN,
        OFF,
        ON;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DebuggerStatus {
        DEFAULT,
        WAITING,
        ATTACHED,
        ERROR;

    }
}

