/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.log;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.log.EventContainer;
import com.android.ddmlib.log.EventValueDescription;
import com.android.ddmlib.log.GcEventContainer;
import com.android.ddmlib.log.InvalidValueTypeException;
import com.android.ddmlib.log.LogReceiver;
import com.android.ddmlib.utils.ArrayHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EventLogParser {
    private static final String EVENT_TAG_MAP_FILE = "/system/etc/event-log-tags";
    private static final int EVENT_TYPE_INT = 0;
    private static final int EVENT_TYPE_LONG = 1;
    private static final int EVENT_TYPE_STRING = 2;
    private static final int EVENT_TYPE_LIST = 3;
    private static final Pattern PATTERN_SIMPLE_TAG = Pattern.compile("^(\\d+)\\s+([A-Za-z0-9_]+)\\s*$");
    private static final Pattern PATTERN_TAG_WITH_DESC = Pattern.compile("^(\\d+)\\s+([A-Za-z0-9_]+)\\s*(.*)\\s*$");
    private static final Pattern PATTERN_DESCRIPTION = Pattern.compile("\\(([A-Za-z0-9_\\s]+)\\|(\\d+)(\\|\\d+){0,1}\\)");
    private static final Pattern TEXT_LOG_LINE = Pattern.compile("(\\d\\d)-(\\d\\d)\\s(\\d\\d):(\\d\\d):(\\d\\d).(\\d{3})\\s+I/([a-zA-Z0-9_]+)\\s*\\(\\s*(\\d+)\\):\\s+(.*)");
    private final TreeMap<Integer, String> mTagMap = new TreeMap();
    private final TreeMap<Integer, EventValueDescription[]> mValueDescriptionMap = new TreeMap();

    public boolean init(IDevice iDevice) {
        try {
            iDevice.executeShellCommand("cat /system/etc/event-log-tags", new MultiLineReceiver(){

                public void processNewLines(String[] stringArray) {
                    for (String string : stringArray) {
                        EventLogParser.this.processTagLine(string);
                    }
                }

                public boolean isCancelled() {
                    return false;
                }
            });
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean init(String[] stringArray) {
        for (String string : stringArray) {
            this.processTagLine(string);
        }
        return true;
    }

    public boolean init(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = null;
            do {
                if ((string2 = bufferedReader.readLine()) == null) continue;
                this.processTagLine(string2);
            } while (string2 != null);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private void processTagLine(String string) {
        if (string.length() > 0 && string.charAt(0) != '#') {
            Matcher matcher = PATTERN_TAG_WITH_DESC.matcher(string);
            if (matcher.matches()) {
                try {
                    int n = Integer.parseInt(matcher.group(1));
                    String string2 = matcher.group(2);
                    if (string2 != null && this.mTagMap.get(n) == null) {
                        this.mTagMap.put(n, string2);
                    }
                    if (n == 20001) {
                        this.mValueDescriptionMap.put(n, GcEventContainer.getValueDescriptions());
                    } else {
                        EventValueDescription[] eventValueDescriptionArray;
                        String string3 = matcher.group(3);
                        if (string3 != null && string3.length() > 0 && (eventValueDescriptionArray = this.processDescription(string3)) != null) {
                            this.mValueDescriptionMap.put(n, eventValueDescriptionArray);
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                matcher = PATTERN_SIMPLE_TAG.matcher(string);
                if (matcher.matches()) {
                    int n = Integer.parseInt(matcher.group(1));
                    String string4 = matcher.group(2);
                    if (string4 != null && this.mTagMap.get(n) == null) {
                        this.mTagMap.put(n, string4);
                    }
                }
            }
        }
    }

    private EventValueDescription[] processDescription(String string) {
        String[] stringArray = string.split("\\s*,\\s*");
        ArrayList<EventValueDescription> arrayList = new ArrayList<EventValueDescription>();
        for (String string2 : stringArray) {
            Matcher matcher = PATTERN_DESCRIPTION.matcher(string2);
            if (matcher.matches()) {
                try {
                    String string3 = matcher.group(1);
                    String string4 = matcher.group(2);
                    int n = Integer.parseInt(string4);
                    EventContainer.EventValueType eventValueType = EventContainer.EventValueType.getEventValueType(n);
                    if (eventValueType == null) {
                        // empty if block
                    }
                    if ((string4 = matcher.group(3)) != null && string4.length() > 0) {
                        string4 = string4.substring(1);
                        n = Integer.parseInt(string4);
                        EventValueDescription.ValueType valueType = EventValueDescription.ValueType.getValueType(n);
                        arrayList.add(new EventValueDescription(string3, eventValueType, valueType));
                        continue;
                    }
                    arrayList.add(new EventValueDescription(string3, eventValueType));
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (InvalidValueTypeException invalidValueTypeException) {}
                continue;
            }
            Log.e("EventLogParser", String.format("Can't parse %1$s", string));
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new EventValueDescription[arrayList.size()]);
    }

    public EventContainer parse(LogReceiver.LogEntry logEntry) {
        ArrayList<Object> arrayList;
        if (logEntry.len < 4) {
            return null;
        }
        int n = 0;
        int n2 = ArrayHelper.swap32bitFromArray(logEntry.data, n);
        n += 4;
        String string = this.mTagMap.get(n2);
        if (string == null) {
            Log.e("EventLogParser", String.format("unknown tag number: %1$d", n2));
        }
        if (EventLogParser.parseBinaryEvent(logEntry.data, n, arrayList = new ArrayList<Object>()) == -1) {
            return null;
        }
        Object object = arrayList.size() == 1 ? arrayList.get(0) : arrayList.toArray();
        EventContainer eventContainer = null;
        eventContainer = n2 == 20001 ? new GcEventContainer(logEntry, n2, object) : new EventContainer(logEntry, n2, object);
        return eventContainer;
    }

    public EventContainer parse(String string) {
        if (string.length() == 0) {
            return null;
        }
        Matcher matcher = TEXT_LOG_LINE.matcher(string);
        if (matcher.matches()) {
            try {
                int n = Integer.parseInt(matcher.group(1));
                int n2 = Integer.parseInt(matcher.group(2));
                int n3 = Integer.parseInt(matcher.group(3));
                int n4 = Integer.parseInt(matcher.group(4));
                int n5 = Integer.parseInt(matcher.group(5));
                int n6 = Integer.parseInt(matcher.group(6));
                Calendar calendar = Calendar.getInstance();
                calendar.set(calendar.get(1), n - 1, n2, n3, n4, n5);
                int n7 = (int)Math.floor(calendar.getTimeInMillis() / 1000L);
                int n8 = n6 * 1000000;
                String string2 = matcher.group(7);
                int n9 = -1;
                Set<Map.Entry<Integer, String>> set = this.mTagMap.entrySet();
                for (Map.Entry<Integer, String> object2 : set) {
                    if (!string2.equals(object2.getValue())) continue;
                    n9 = object2.getKey();
                    break;
                }
                if (n9 == -1) {
                    return null;
                }
                int n10 = Integer.parseInt(matcher.group(8));
                Object object = this.parseTextData(matcher.group(9), n9);
                if (object == null) {
                    return null;
                }
                EventContainer eventContainer = null;
                eventContainer = n9 == 20001 ? new GcEventContainer(n9, n10, -1, n7, n8, object) : new EventContainer(n9, n10, -1, n7, n8, object);
                return eventContainer;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    public Map<Integer, String> getTagMap() {
        return this.mTagMap;
    }

    public Map<Integer, EventValueDescription[]> getEventInfoMap() {
        return this.mValueDescriptionMap;
    }

    private static int parseBinaryEvent(byte[] byArray, int n, ArrayList<Object> arrayList) {
        if (byArray.length - n < 1) {
            return -1;
        }
        int n2 = n;
        byte by = byArray[n2++];
        switch (by) {
            case 0: {
                if (byArray.length - n2 < 4) {
                    return -1;
                }
                int n3 = ArrayHelper.swap32bitFromArray(byArray, n2);
                n2 += 4;
                arrayList.add(new Integer(n3));
                break;
            }
            case 1: {
                if (byArray.length - n2 < 8) {
                    return -1;
                }
                long l = ArrayHelper.swap64bitFromArray(byArray, n2);
                n2 += 8;
                arrayList.add(new Long(l));
                break;
            }
            case 2: {
                int n4;
                if (byArray.length - n2 < 4) {
                    return -1;
                }
                if (byArray.length - (n2 += 4) < (n4 = ArrayHelper.swap32bitFromArray(byArray, n2))) {
                    return -1;
                }
                try {
                    String string = new String(byArray, n2, n4, "UTF-8");
                    arrayList.add(string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                n2 += n4;
                break;
            }
            case 3: {
                if (byArray.length - n2 < 1) {
                    return -1;
                }
                int n5 = byArray[n2++];
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                for (int i = 0; i < n5; ++i) {
                    int n6 = EventLogParser.parseBinaryEvent(byArray, n2, arrayList2);
                    if (n6 == -1) {
                        return n6;
                    }
                    n2 += n6;
                }
                arrayList.add(arrayList2.toArray());
                break;
            }
            default: {
                Log.e("EventLogParser", String.format("Unknown binary event type %1$d", by));
                return -1;
            }
        }
        return n2 - n;
    }

    private Object parseTextData(String string, int n) {
        EventValueDescription[] eventValueDescriptionArray = this.mValueDescriptionMap.get(n);
        if (eventValueDescriptionArray == null) {
            return null;
        }
        if (eventValueDescriptionArray.length == 1) {
            return this.getObjectFromString(string, eventValueDescriptionArray[0].getEventValueType());
        }
        if (string.startsWith("[") && string.endsWith("]")) {
            string = string.substring(1, string.length() - 1);
            String[] stringArray = string.split(",");
            if (n == 20001) {
                Object[] objectArray = new Object[]{this.getObjectFromString(stringArray[0], EventContainer.EventValueType.LONG), this.getObjectFromString(stringArray[1], EventContainer.EventValueType.LONG)};
                return objectArray;
            }
            if (stringArray.length != eventValueDescriptionArray.length) {
                return null;
            }
            Object[] objectArray = new Object[stringArray.length];
            for (int i = 0; i < eventValueDescriptionArray.length; ++i) {
                Object object = this.getObjectFromString(stringArray[i], eventValueDescriptionArray[i].getEventValueType());
                if (object == null) {
                    return null;
                }
                objectArray[i] = object;
            }
            return objectArray;
        }
        return null;
    }

    private Object getObjectFromString(String string, EventContainer.EventValueType eventValueType) {
        try {
            switch (eventValueType) {
                case INT: {
                    return Integer.valueOf(string);
                }
                case LONG: {
                    return Long.valueOf(string);
                }
                case STRING: {
                    return string;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTags(String string) throws IOException {
        File file = new File(string);
        file.createNewFile();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            for (Integer n : this.mTagMap.keySet()) {
                Object object;
                String string2 = this.mTagMap.get(n);
                EventValueDescription[] eventValueDescriptionArray = this.mValueDescriptionMap.get(n);
                String string3 = null;
                if (eventValueDescriptionArray != null) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append(String.format("%1$d %2$s", n, string2));
                    boolean bl = true;
                    for (EventValueDescription eventValueDescription : eventValueDescriptionArray) {
                        if (bl) {
                            ((StringBuilder)object).append(" (");
                            bl = false;
                        } else {
                            ((StringBuilder)object).append(",(");
                        }
                        ((StringBuilder)object).append(eventValueDescription.getName());
                        ((StringBuilder)object).append("|");
                        ((StringBuilder)object).append(eventValueDescription.getEventValueType().getValue());
                        ((StringBuilder)object).append("|");
                        ((StringBuilder)object).append(eventValueDescription.getValueType().getValue());
                        ((StringBuilder)object).append("|)");
                    }
                    ((StringBuilder)object).append("\n");
                    string3 = ((StringBuilder)object).toString();
                } else {
                    string3 = String.format("%1$d %2$s\n", n, string2);
                }
                object = string3.getBytes();
                fileOutputStream.write((byte[])object);
            }
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }
}

