/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.testrunner;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.InstrumentationResultParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteAndroidTestRunner
implements IRemoteAndroidTestRunner {
    private final String mPackageName;
    private final String mRunnerName;
    private IDevice mRemoteDevice;
    private int mMaxTimeToOutputResponse = 0;
    private String mRunName = null;
    private Map<String, String> mArgMap;
    private InstrumentationResultParser mParser;
    private static final String LOG_TAG = "RemoteAndroidTest";
    private static final String DEFAULT_RUNNER_NAME = "android.test.InstrumentationTestRunner";
    private static final char CLASS_SEPARATOR = ',';
    private static final char METHOD_SEPARATOR = '#';
    private static final char RUNNER_SEPARATOR = '/';
    private static final String CLASS_ARG_NAME = "class";
    private static final String LOG_ARG_NAME = "log";
    private static final String DEBUG_ARG_NAME = "debug";
    private static final String COVERAGE_ARG_NAME = "coverage";
    private static final String PACKAGE_ARG_NAME = "package";
    private static final String SIZE_ARG_NAME = "size";

    public RemoteAndroidTestRunner(String string, String string2, IDevice iDevice) {
        this.mPackageName = string;
        this.mRunnerName = string2;
        this.mRemoteDevice = iDevice;
        this.mArgMap = new Hashtable<String, String>();
    }

    public RemoteAndroidTestRunner(String string, IDevice iDevice) {
        this(string, null, iDevice);
    }

    @Override
    public String getPackageName() {
        return this.mPackageName;
    }

    @Override
    public String getRunnerName() {
        if (this.mRunnerName == null) {
            return DEFAULT_RUNNER_NAME;
        }
        return this.mRunnerName;
    }

    private String getRunnerPath() {
        return this.getPackageName() + '/' + this.getRunnerName();
    }

    @Override
    public void setClassName(String string) {
        this.addInstrumentationArg(CLASS_ARG_NAME, string);
    }

    @Override
    public void setClassNames(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(stringArray[i]);
        }
        this.setClassName(stringBuilder.toString());
    }

    @Override
    public void setMethodName(String string, String string2) {
        this.setClassName(string + '#' + string2);
    }

    @Override
    public void setTestPackageName(String string) {
        this.addInstrumentationArg(PACKAGE_ARG_NAME, string);
    }

    @Override
    public void addInstrumentationArg(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("name or value arguments cannot be null");
        }
        this.mArgMap.put(string, string2);
    }

    @Override
    public void removeInstrumentationArg(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        this.mArgMap.remove(string);
    }

    @Override
    public void addBooleanArg(String string, boolean bl) {
        this.addInstrumentationArg(string, Boolean.toString(bl));
    }

    @Override
    public void setLogOnly(boolean bl) {
        this.addBooleanArg(LOG_ARG_NAME, bl);
    }

    @Override
    public void setDebug(boolean bl) {
        this.addBooleanArg(DEBUG_ARG_NAME, bl);
    }

    @Override
    public void setCoverage(boolean bl) {
        this.addBooleanArg(COVERAGE_ARG_NAME, bl);
    }

    @Override
    public void setTestSize(IRemoteAndroidTestRunner.TestSize testSize) {
        this.addInstrumentationArg(SIZE_ARG_NAME, testSize.getRunnerValue());
    }

    @Override
    public void setMaxtimeToOutputResponse(int n) {
        this.mMaxTimeToOutputResponse = n;
    }

    @Override
    public void setRunName(String string) {
        this.mRunName = string;
    }

    @Override
    public void run(ITestRunListener ... iTestRunListenerArray) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.run(Arrays.asList(iTestRunListenerArray));
    }

    @Override
    public void run(Collection<ITestRunListener> collection) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        String string = String.format("am instrument -w -r %1$s %2$s", this.getArgsCommand(), this.getRunnerPath());
        Log.i(LOG_TAG, String.format("Running %1$s on %2$s", string, this.mRemoteDevice.getSerialNumber()));
        String string2 = this.mRunName == null ? this.mPackageName : this.mRunName;
        this.mParser = new InstrumentationResultParser(string2, collection);
        try {
            this.mRemoteDevice.executeShellCommand(string, this.mParser, this.mMaxTimeToOutputResponse);
        }
        catch (IOException iOException) {
            Log.w(LOG_TAG, String.format("IOException %1$s when running tests %2$s on %3$s", iOException.toString(), this.getPackageName(), this.mRemoteDevice.getSerialNumber()));
            this.mParser.handleTestRunFailed(iOException.toString());
            throw iOException;
        }
        catch (ShellCommandUnresponsiveException shellCommandUnresponsiveException) {
            Log.w(LOG_TAG, String.format("ShellCommandUnresponsiveException %1$s when running tests %2$s on %3$s", shellCommandUnresponsiveException.toString(), this.getPackageName(), this.mRemoteDevice.getSerialNumber()));
            this.mParser.handleTestRunFailed(String.format("Failed to receive adb shell test output within %1$d ms. Test may have timed out, or adb connection to device became unresponsive", this.mMaxTimeToOutputResponse));
            throw shellCommandUnresponsiveException;
        }
        catch (TimeoutException timeoutException) {
            Log.w(LOG_TAG, String.format("TimeoutException when running tests %1$s on %2$s", this.getPackageName(), this.mRemoteDevice.getSerialNumber()));
            this.mParser.handleTestRunFailed(timeoutException.toString());
            throw timeoutException;
        }
        catch (AdbCommandRejectedException adbCommandRejectedException) {
            Log.w(LOG_TAG, String.format("AdbCommandRejectedException %1$s when running tests %2$s on %3$s", adbCommandRejectedException.toString(), this.getPackageName(), this.mRemoteDevice.getSerialNumber()));
            this.mParser.handleTestRunFailed(adbCommandRejectedException.toString());
            throw adbCommandRejectedException;
        }
    }

    @Override
    public void cancel() {
        if (this.mParser != null) {
            this.mParser.cancel();
        }
    }

    private String getArgsCommand() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.mArgMap.entrySet()) {
            String string = String.format(" -e %1$s %2$s", entry.getKey(), entry.getValue());
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

