/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CaseFormat {
    LOWER_HYPHEN(Pattern.compile("[-]"), "-"),
    LOWER_UNDERSCORE(Pattern.compile("[_]"), "_"),
    LOWER_CAMEL(Pattern.compile("[A-Z]"), ""),
    UPPER_CAMEL(Pattern.compile("[A-Z]"), ""),
    UPPER_UNDERSCORE(Pattern.compile("[_]"), "_");

    private final Pattern wordBoundary;
    private final String wordSeparator;

    private CaseFormat(Pattern pattern, String string2) {
        this.wordBoundary = pattern;
        this.wordSeparator = string2;
    }

    public String to(CaseFormat caseFormat, String string) {
        if (caseFormat == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        if (caseFormat == this) {
            return string;
        }
        switch (this) {
            case LOWER_HYPHEN: {
                switch (caseFormat) {
                    case LOWER_UNDERSCORE: {
                        return string.replace("-", "_");
                    }
                    case UPPER_UNDERSCORE: {
                        return string.replace("-", "_").toUpperCase(Locale.US);
                    }
                }
                break;
            }
            case LOWER_UNDERSCORE: {
                switch (caseFormat) {
                    case LOWER_HYPHEN: {
                        return string.replace("_", "-");
                    }
                    case UPPER_UNDERSCORE: {
                        return string.toUpperCase(Locale.US);
                    }
                }
                break;
            }
            case UPPER_UNDERSCORE: {
                switch (caseFormat) {
                    case LOWER_HYPHEN: {
                        return string.replace("_", "-").toLowerCase(Locale.US);
                    }
                    case LOWER_UNDERSCORE: {
                        return string.toLowerCase(Locale.US);
                    }
                }
            }
        }
        StringBuilder stringBuilder = null;
        int n = 0;
        Matcher matcher = this.wordBoundary.matcher(string);
        while (matcher.find()) {
            int n2 = matcher.start();
            if (n == 0) {
                stringBuilder = new StringBuilder(string.length() + 4 * this.wordSeparator.length());
                stringBuilder.append(caseFormat.normalizeFirstWord(string.substring(n, n2)));
            } else {
                stringBuilder.append(caseFormat.normalizeWord(string.substring(n, n2)));
            }
            stringBuilder.append(caseFormat.wordSeparator);
            n = n2 + this.wordSeparator.length();
        }
        if (n == 0) {
            return caseFormat.normalizeFirstWord(string);
        }
        stringBuilder.append(caseFormat.normalizeWord(string.substring(n)));
        return stringBuilder.toString();
    }

    private String normalizeFirstWord(String string) {
        switch (this) {
            case LOWER_CAMEL: {
                return string.toLowerCase(Locale.US);
            }
        }
        return this.normalizeWord(string);
    }

    private String normalizeWord(String string) {
        switch (this) {
            case LOWER_HYPHEN: {
                return string.toLowerCase(Locale.US);
            }
            case LOWER_UNDERSCORE: {
                return string.toLowerCase(Locale.US);
            }
            case LOWER_CAMEL: {
                return CaseFormat.toTitleCase(string);
            }
            case UPPER_CAMEL: {
                return CaseFormat.toTitleCase(string);
            }
            case UPPER_UNDERSCORE: {
                return string.toUpperCase(Locale.US);
            }
        }
        throw new RuntimeException("unknown case: " + (Object)((Object)this));
    }

    private static String toTitleCase(String string) {
        return string.length() < 2 ? string.toUpperCase(Locale.US) : Character.toTitleCase(string.charAt(0)) + string.substring(1).toLowerCase(Locale.US);
    }
}

