/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

@GwtCompatible
public final class Objects {
    private Objects() {
    }

    public static boolean equal(@Nullable Object object, @Nullable Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public static int hashCode(Object ... objectArray) {
        return Arrays.hashCode(objectArray);
    }

    public static ToStringHelper toStringHelper(Object object) {
        return new ToStringHelper(object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToStringHelper {
        private final List<String> fieldString = new ArrayList<String>();
        private final Object instance;
        private static final Joiner JOINER = Joiner.on(", ");

        private ToStringHelper(Object object) {
            this.instance = Preconditions.checkNotNull(object);
        }

        public ToStringHelper add(String string, @Nullable Object object) {
            return this.addValue(Preconditions.checkNotNull(string) + "=" + object);
        }

        public ToStringHelper addValue(@Nullable Object object) {
            this.fieldString.add(String.valueOf(object));
            return this;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(100).append(ToStringHelper.simpleName(this.instance.getClass())).append('{');
            return JOINER.appendTo(stringBuilder, (Iterable<?>)this.fieldString).append('}').toString();
        }

        @VisibleForTesting
        static String simpleName(Class<?> clazz) {
            String string = clazz.getName();
            int n = string.lastIndexOf(36);
            if (n == -1) {
                n = string.lastIndexOf(46);
            }
            return string.substring(n + 1);
        }
    }
}

