/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
abstract class AbstractMapBasedMultiset<E>
extends AbstractMultiset<E>
implements Serializable {
    private transient Map<E, AtomicInteger> backingMap;
    private transient long size;
    private transient EntrySet entrySet;
    private static final long serialVersionUID = -2250766705698539974L;

    protected AbstractMapBasedMultiset(Map<E, AtomicInteger> map) {
        this.backingMap = Preconditions.checkNotNull(map);
        this.size = super.size();
    }

    Map<E, AtomicInteger> backingMap() {
        return this.backingMap;
    }

    void setBackingMap(Map<E, AtomicInteger> map) {
        this.backingMap = map;
    }

    @Override
    public Set<Multiset.Entry<E>> entrySet() {
        EntrySet entrySet = this.entrySet;
        if (entrySet == null) {
            this.entrySet = entrySet = new EntrySet();
        }
        return entrySet;
    }

    @Override
    public int size() {
        return (int)Math.min(this.size, Integer.MAX_VALUE);
    }

    @Override
    public Iterator<E> iterator() {
        return new MapBasedMultisetIterator();
    }

    @Override
    public int count(@Nullable Object object) {
        AtomicInteger atomicInteger = this.backingMap.get(object);
        return atomicInteger == null ? 0 : atomicInteger.get();
    }

    @Override
    public int add(@Nullable E e, int n) {
        int n2;
        if (n == 0) {
            return this.count(e);
        }
        Preconditions.checkArgument(n > 0, "occurrences cannot be negative: %s", n);
        AtomicInteger atomicInteger = this.backingMap.get(e);
        if (atomicInteger == null) {
            n2 = 0;
            this.backingMap.put(e, new AtomicInteger(n));
        } else {
            n2 = atomicInteger.get();
            long l = (long)n2 + (long)n;
            Preconditions.checkArgument(l <= Integer.MAX_VALUE, "too many occurrences: %s", l);
            atomicInteger.getAndAdd(n);
        }
        this.size += (long)n;
        return n2;
    }

    @Override
    public int remove(@Nullable Object object, int n) {
        int n2;
        if (n == 0) {
            return this.count(object);
        }
        Preconditions.checkArgument(n > 0, "occurrences cannot be negative: %s", n);
        AtomicInteger atomicInteger = this.backingMap.get(object);
        if (atomicInteger == null) {
            return 0;
        }
        int n3 = atomicInteger.get();
        if (n3 > n) {
            n2 = n;
        } else {
            n2 = n3;
            this.backingMap.remove(object);
        }
        atomicInteger.addAndGet(-n2);
        this.size -= (long)n2;
        return n3;
    }

    @Override
    public int setCount(E e, int n) {
        int n2;
        Multisets.checkNonnegative(n, "count");
        if (n == 0) {
            AtomicInteger atomicInteger = this.backingMap.remove(e);
            n2 = AbstractMapBasedMultiset.getAndSet(atomicInteger, n);
        } else {
            AtomicInteger atomicInteger = this.backingMap.get(e);
            n2 = AbstractMapBasedMultiset.getAndSet(atomicInteger, n);
            if (atomicInteger == null) {
                this.backingMap.put(e, new AtomicInteger(n));
            }
        }
        this.size += (long)(n - n2);
        return n2;
    }

    private static int getAndSet(AtomicInteger atomicInteger, int n) {
        if (atomicInteger == null) {
            return 0;
        }
        return atomicInteger.getAndSet(n);
    }

    private int removeAllOccurrences(@Nullable Object object, Map<E, AtomicInteger> map) {
        AtomicInteger atomicInteger = map.remove(object);
        if (atomicInteger == null) {
            return 0;
        }
        int n = atomicInteger.getAndSet(0);
        this.size -= (long)n;
        return n;
    }

    @Override
    Set<E> createElementSet() {
        return new MapBasedElementSet(this.backingMap);
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("Stream data required");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MapBasedElementSet
    extends ForwardingSet<E> {
        private final Map<E, AtomicInteger> map;
        private final Set<E> delegate;

        MapBasedElementSet(Map<E, AtomicInteger> map) {
            this.map = map;
            this.delegate = map.keySet();
        }

        @Override
        protected Set<E> delegate() {
            return this.delegate;
        }

        @Override
        public Iterator<E> iterator() {
            final Iterator iterator = this.map.entrySet().iterator();
            return new Iterator<E>(){
                Map.Entry<E, AtomicInteger> toRemove;

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public E next() {
                    this.toRemove = (Map.Entry)iterator.next();
                    return this.toRemove.getKey();
                }

                @Override
                public void remove() {
                    Preconditions.checkState(this.toRemove != null, "no calls to next() since the last call to remove()");
                    AbstractMapBasedMultiset.this.size -= this.toRemove.getValue().getAndSet(0);
                    iterator.remove();
                    this.toRemove = null;
                }
            };
        }

        @Override
        public boolean remove(Object object) {
            return AbstractMapBasedMultiset.this.removeAllOccurrences(object, this.map) != 0;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return Iterators.removeAll(this.iterator(), collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return Iterators.retainAll(this.iterator(), collection);
        }

        @Override
        public void clear() {
            if (this.map == AbstractMapBasedMultiset.this.backingMap) {
                AbstractMapBasedMultiset.this.clear();
            } else {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    iterator.remove();
                }
            }
        }

        public Map<E, AtomicInteger> getMap() {
            return this.map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapBasedMultisetIterator
    implements Iterator<E> {
        final Iterator<Map.Entry<E, AtomicInteger>> entryIterator;
        Map.Entry<E, AtomicInteger> currentEntry;
        int occurrencesLeft;
        boolean canRemove;

        MapBasedMultisetIterator() {
            this.entryIterator = AbstractMapBasedMultiset.this.backingMap.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.occurrencesLeft > 0 || this.entryIterator.hasNext();
        }

        @Override
        public E next() {
            if (this.occurrencesLeft == 0) {
                this.currentEntry = this.entryIterator.next();
                this.occurrencesLeft = this.currentEntry.getValue().get();
            }
            --this.occurrencesLeft;
            this.canRemove = true;
            return this.currentEntry.getKey();
        }

        @Override
        public void remove() {
            Preconditions.checkState(this.canRemove, "no calls to next() since the last call to remove()");
            int n = this.currentEntry.getValue().get();
            if (n <= 0) {
                throw new ConcurrentModificationException();
            }
            if (this.currentEntry.getValue().addAndGet(-1) == 0) {
                this.entryIterator.remove();
            }
            AbstractMapBasedMultiset.this.size--;
            this.canRemove = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Multiset.Entry<E>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Multiset.Entry<E>> iterator() {
            final Iterator iterator = AbstractMapBasedMultiset.this.backingMap.entrySet().iterator();
            return new Iterator<Multiset.Entry<E>>(){
                Map.Entry<E, AtomicInteger> toRemove;

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Multiset.Entry<E> next() {
                    Map.Entry entry;
                    this.toRemove = entry = (Map.Entry)iterator.next();
                    return new Multisets.AbstractEntry<E>(){

                        @Override
                        public E getElement() {
                            return entry.getKey();
                        }

                        @Override
                        public int getCount() {
                            AtomicInteger atomicInteger;
                            int n = ((AtomicInteger)entry.getValue()).get();
                            if (n == 0 && (atomicInteger = (AtomicInteger)AbstractMapBasedMultiset.this.backingMap.get(this.getElement())) != null) {
                                n = atomicInteger.get();
                            }
                            return n;
                        }
                    };
                }

                @Override
                public void remove() {
                    Preconditions.checkState(this.toRemove != null, "no calls to next() since the last call to remove()");
                    AbstractMapBasedMultiset.this.size -= this.toRemove.getValue().getAndSet(0);
                    iterator.remove();
                    this.toRemove = null;
                }
            };
        }

        @Override
        public int size() {
            return AbstractMapBasedMultiset.this.backingMap.size();
        }

        @Override
        public void clear() {
            for (AtomicInteger atomicInteger : AbstractMapBasedMultiset.this.backingMap.values()) {
                atomicInteger.set(0);
            }
            AbstractMapBasedMultiset.this.backingMap.clear();
            AbstractMapBasedMultiset.this.size = 0L;
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Multiset.Entry) {
                Multiset.Entry entry = (Multiset.Entry)object;
                int n = AbstractMapBasedMultiset.this.count(entry.getElement());
                return n == entry.getCount() && n > 0;
            }
            return false;
        }

        @Override
        public boolean remove(Object object) {
            if (this.contains(object)) {
                Multiset.Entry entry = (Multiset.Entry)object;
                AtomicInteger atomicInteger = (AtomicInteger)AbstractMapBasedMultiset.this.backingMap.remove(entry.getElement());
                int n = atomicInteger.getAndSet(0);
                AbstractMapBasedMultiset.this.size -= n;
                return true;
            }
            return false;
        }
    }
}

