/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
abstract class AbstractMultiset<E>
extends AbstractCollection<E>
implements Multiset<E> {
    private transient Set<E> elementSet;

    AbstractMultiset() {
    }

    @Override
    public abstract Set<Multiset.Entry<E>> entrySet();

    @Override
    public int size() {
        long l = 0L;
        for (Multiset.Entry<E> entry : this.entrySet()) {
            l += (long)entry.getCount();
        }
        return (int)Math.min(l, Integer.MAX_VALUE);
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.elementSet().contains(object);
    }

    @Override
    public Iterator<E> iterator() {
        return new MultisetIterator();
    }

    @Override
    public int count(Object object) {
        for (Multiset.Entry<E> entry : this.entrySet()) {
            if (!Objects.equal(entry.getElement(), object)) continue;
            return entry.getCount();
        }
        return 0;
    }

    @Override
    public boolean add(@Nullable E e) {
        this.add(e, 1);
        return true;
    }

    @Override
    public int add(E e, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        return this.remove(object, 1) > 0;
    }

    @Override
    public int remove(Object object, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int setCount(E e, int n) {
        return Multisets.setCountImpl(this, e, n);
    }

    @Override
    public boolean setCount(E e, int n, int n2) {
        return Multisets.setCountImpl(this, e, n, n2);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.elementSet().containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        if (collection instanceof Multiset) {
            Multiset multiset = (Multiset)collection;
            for (Multiset.Entry entry : multiset.entrySet()) {
                this.add(entry.getElement(), entry.getCount());
            }
        } else {
            super.addAll(collection);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        Collection<?> collection2 = collection instanceof Multiset ? ((Multiset)collection).elementSet() : collection;
        return this.elementSet().removeAll(collection2);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        Preconditions.checkNotNull(collection);
        Iterator<Multiset.Entry<E>> iterator = this.entrySet().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Multiset.Entry<E> entry = iterator.next();
            if (collection.contains(entry.getElement())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public void clear() {
        this.entrySet().clear();
    }

    @Override
    public Set<E> elementSet() {
        Set<E> set = this.elementSet;
        if (set == null) {
            this.elementSet = set = this.createElementSet();
        }
        return set;
    }

    Set<E> createElementSet() {
        return new ElementSet();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Multiset) {
            Multiset multiset = (Multiset)object;
            if (this.size() != multiset.size()) {
                return false;
            }
            for (Multiset.Entry entry : multiset.entrySet()) {
                if (this.count(entry.getElement()) == entry.getCount()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.entrySet()).hashCode();
    }

    @Override
    public String toString() {
        return this.entrySet().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ElementSet
    extends AbstractSet<E> {
        private ElementSet() {
        }

        @Override
        public Iterator<E> iterator() {
            final Iterator iterator = AbstractMultiset.this.entrySet().iterator();
            return new Iterator<E>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public E next() {
                    return ((Multiset.Entry)iterator.next()).getElement();
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractMultiset.this.entrySet().size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultisetIterator
    implements Iterator<E> {
        private final Iterator<Multiset.Entry<E>> entryIterator;
        private Multiset.Entry<E> currentEntry;
        private int laterCount;
        private int totalCount;
        private boolean canRemove;

        MultisetIterator() {
            this.entryIterator = AbstractMultiset.this.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.laterCount > 0 || this.entryIterator.hasNext();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.laterCount == 0) {
                this.currentEntry = this.entryIterator.next();
                this.totalCount = this.laterCount = this.currentEntry.getCount();
            }
            --this.laterCount;
            this.canRemove = true;
            return this.currentEntry.getElement();
        }

        @Override
        public void remove() {
            Preconditions.checkState(this.canRemove, "no calls to next() since the last call to remove()");
            if (this.totalCount == 1) {
                this.entryIterator.remove();
            } else {
                AbstractMultiset.this.remove(this.currentEntry.getElement());
            }
            --this.totalCount;
            this.canRemove = false;
        }
    }
}

