/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Serialization;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConcurrentHashMultiset<E>
extends AbstractMultiset<E>
implements Serializable {
    private final transient ConcurrentMap<E, Integer> countMap;
    private transient EntrySet entrySet;
    private static final long serialVersionUID = 0L;

    public static <E> ConcurrentHashMultiset<E> create() {
        return new ConcurrentHashMultiset(new ConcurrentHashMap());
    }

    public static <E> ConcurrentHashMultiset<E> create(Iterable<? extends E> iterable) {
        ConcurrentHashMultiset<E> concurrentHashMultiset = ConcurrentHashMultiset.create();
        Iterables.addAll(concurrentHashMultiset, iterable);
        return concurrentHashMultiset;
    }

    @VisibleForTesting
    ConcurrentHashMultiset(ConcurrentMap<E, Integer> concurrentMap) {
        Preconditions.checkArgument(concurrentMap.isEmpty());
        this.countMap = concurrentMap;
    }

    @Override
    public int count(@Nullable Object object) {
        try {
            return ConcurrentHashMultiset.unbox((Integer)this.countMap.get(object));
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
        catch (ClassCastException classCastException) {
            return 0;
        }
    }

    @Override
    public int size() {
        long l = 0L;
        for (Integer n : this.countMap.values()) {
            l += (long)n.intValue();
        }
        return (int)Math.min(l, Integer.MAX_VALUE);
    }

    @Override
    public Object[] toArray() {
        return this.snapshot().toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.snapshot().toArray(TArray);
    }

    private List<E> snapshot() {
        ArrayList<E> arrayList = Lists.newArrayListWithExpectedSize(this.size());
        for (Multiset.Entry<E> entry : this.entrySet()) {
            E e = entry.getElement();
            for (int i = entry.getCount(); i > 0; --i) {
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    @Override
    public int add(E e, int n) {
        int n2;
        if (n == 0) {
            return this.count(e);
        }
        Preconditions.checkArgument(n > 0, "Invalid occurrences: %s", n);
        while (true) {
            if ((n2 = this.count(e)) == 0) {
                if (this.countMap.putIfAbsent(e, n) != null) continue;
                return 0;
            }
            Preconditions.checkArgument(n <= Integer.MAX_VALUE - n2, "Overflow adding %s occurrences to a count of %s", n, n2);
            int n3 = n2 + n;
            if (this.countMap.replace(e, n2, n3)) break;
        }
        return n2;
    }

    @Override
    public int remove(@Nullable Object object, int n) {
        Object object2;
        int n2;
        if (n == 0) {
            return this.count(object);
        }
        Preconditions.checkArgument(n > 0, "Invalid occurrences: %s", n);
        do {
            if ((n2 = this.count(object)) != 0) continue;
            return 0;
        } while (!(n >= n2 ? this.countMap.remove(object, n2) : this.countMap.replace(object2 = object, n2, n2 - n)));
        return n2;
    }

    private int removeAllOccurrences(@Nullable Object object) {
        try {
            return ConcurrentHashMultiset.unbox((Integer)this.countMap.remove(object));
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
        catch (ClassCastException classCastException) {
            return 0;
        }
    }

    public boolean removeExactly(@Nullable Object object, int n) {
        Object object2;
        int n2;
        if (n == 0) {
            return true;
        }
        Preconditions.checkArgument(n > 0, "Invalid occurrences: %s", n);
        do {
            if (n <= (n2 = this.count(object))) continue;
            return false;
        } while (!(n == n2 ? this.countMap.remove(object, n) : this.countMap.replace(object2 = object, n2, n2 - n)));
        return true;
    }

    @Override
    public int setCount(E e, int n) {
        Multisets.checkNonnegative(n, "count");
        return n == 0 ? this.removeAllOccurrences(e) : ConcurrentHashMultiset.unbox(this.countMap.put(e, n));
    }

    @Override
    public boolean setCount(E e, int n, int n2) {
        Multisets.checkNonnegative(n, "oldCount");
        Multisets.checkNonnegative(n2, "newCount");
        if (n2 == 0) {
            if (n == 0) {
                return !this.countMap.containsKey(e);
            }
            return this.countMap.remove(e, n);
        }
        if (n == 0) {
            return this.countMap.putIfAbsent(e, n2) == null;
        }
        return this.countMap.replace(e, n, n2);
    }

    @Override
    Set<E> createElementSet() {
        final Set set = this.countMap.keySet();
        return new ForwardingSet<E>(){

            @Override
            protected Set<E> delegate() {
                return set;
            }

            @Override
            public boolean remove(Object object) {
                try {
                    return set.remove(object);
                }
                catch (NullPointerException nullPointerException) {
                    return false;
                }
                catch (ClassCastException classCastException) {
                    return false;
                }
            }
        };
    }

    @Override
    public Set<Multiset.Entry<E>> entrySet() {
        EntrySet entrySet = this.entrySet;
        if (entrySet == null) {
            this.entrySet = entrySet = new EntrySet();
        }
        return entrySet;
    }

    private static int unbox(Integer n) {
        return n == null ? 0 : n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Serialization.writeMultiset(HashMultiset.create(this), objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        FieldSettersHolder.COUNT_MAP_FIELD_SETTER.set(this, new ConcurrentHashMap());
        Serialization.populateMultiset(this, objectInputStream);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Multiset.Entry<E>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return ConcurrentHashMultiset.this.countMap.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentHashMultiset.this.countMap.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Multiset.Entry) {
                Multiset.Entry entry = (Multiset.Entry)object;
                Object e = entry.getElement();
                int n = entry.getCount();
                return n > 0 && ConcurrentHashMultiset.this.count(e) == n;
            }
            return false;
        }

        @Override
        public Iterator<Multiset.Entry<E>> iterator() {
            final Iterator iterator = ConcurrentHashMultiset.this.countMap.entrySet().iterator();
            return new Iterator<Multiset.Entry<E>>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Multiset.Entry<E> next() {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    return Multisets.immutableEntry(entry.getKey(), (Integer)entry.getValue());
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return this.snapshot().toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.snapshot().toArray(TArray);
        }

        private List<Multiset.Entry<E>> snapshot() {
            ArrayList arrayList = Lists.newArrayListWithExpectedSize(this.size());
            for (Multiset.Entry entry : this) {
                arrayList.add(entry);
            }
            return arrayList;
        }

        @Override
        public boolean remove(Object object) {
            if (object instanceof Multiset.Entry) {
                Multiset.Entry entry = (Multiset.Entry)object;
                Object e = entry.getElement();
                int n = entry.getCount();
                return ConcurrentHashMultiset.this.countMap.remove(e, n);
            }
            return false;
        }

        @Override
        public void clear() {
            ConcurrentHashMultiset.this.countMap.clear();
        }

        @Override
        public int hashCode() {
            return ConcurrentHashMultiset.this.countMap.hashCode();
        }
    }

    private static class FieldSettersHolder {
        static final Serialization.FieldSetter<ConcurrentHashMultiset> COUNT_MAP_FIELD_SETTER = Serialization.getFieldSetter(ConcurrentHashMultiset.class, "countMap");

        private FieldSettersHolder() {
        }
    }
}

