/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.collect.AbstractMapEntry;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;

final class CustomConcurrentHashMap {
    private CustomConcurrentHashMap() {
    }

    private static int rehash(int n) {
        n += n << 15 ^ 0xFFFFCD7D;
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += (n << 2) + (n << 14);
        return n ^ n >>> 16;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SimpleInternalEntry<K, V> {
        final K key;
        final int hash;
        final SimpleInternalEntry<K, V> next;
        volatile V value;

        SimpleInternalEntry(K k, int n, @Nullable V v, SimpleInternalEntry<K, V> simpleInternalEntry) {
            this.key = k;
            this.hash = n;
            this.value = v;
            this.next = simpleInternalEntry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SimpleStrategy<K, V>
    implements Strategy<K, V, SimpleInternalEntry<K, V>> {
        SimpleStrategy() {
        }

        @Override
        public SimpleInternalEntry<K, V> newEntry(K k, int n, SimpleInternalEntry<K, V> simpleInternalEntry) {
            return new SimpleInternalEntry<K, Object>(k, n, null, simpleInternalEntry);
        }

        @Override
        public SimpleInternalEntry<K, V> copyEntry(K k, SimpleInternalEntry<K, V> simpleInternalEntry, SimpleInternalEntry<K, V> simpleInternalEntry2) {
            return new SimpleInternalEntry(k, simpleInternalEntry.hash, simpleInternalEntry.value, simpleInternalEntry2);
        }

        @Override
        public void setValue(SimpleInternalEntry<K, V> simpleInternalEntry, V v) {
            simpleInternalEntry.value = v;
        }

        @Override
        public V getValue(SimpleInternalEntry<K, V> simpleInternalEntry) {
            return simpleInternalEntry.value;
        }

        @Override
        public boolean equalKeys(K k, Object object) {
            return k.equals(object);
        }

        @Override
        public boolean equalValues(V v, Object object) {
            return v.equals(object);
        }

        @Override
        public int hashKey(Object object) {
            return object.hashCode();
        }

        @Override
        public K getKey(SimpleInternalEntry<K, V> simpleInternalEntry) {
            return simpleInternalEntry.key;
        }

        @Override
        public SimpleInternalEntry<K, V> getNext(SimpleInternalEntry<K, V> simpleInternalEntry) {
            return simpleInternalEntry.next;
        }

        @Override
        public int getHash(SimpleInternalEntry<K, V> simpleInternalEntry) {
            return simpleInternalEntry.hash;
        }

        @Override
        public void setInternals(Internals<K, V, SimpleInternalEntry<K, V>> internals) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ComputingImpl<K, V, E>
    extends Impl<K, V, E> {
        static final long serialVersionUID = 0L;
        final ComputingStrategy<K, V, E> computingStrategy;
        final Function<? super K, ? extends V> computer;

        ComputingImpl(ComputingStrategy<K, V, E> computingStrategy, Builder builder, Function<? super K, ? extends V> function) {
            super(computingStrategy, builder);
            this.computingStrategy = computingStrategy;
            this.computer = function;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object object) {
            Object object2 = object;
            if (object2 == null) {
                throw new NullPointerException("key");
            }
            int n = this.hash(object2);
            Impl.Segment segment = this.segmentFor(n);
            block12: while (true) {
                Object object3;
                boolean bl;
                Object e;
                if ((e = segment.getEntry(object2, n)) == null) {
                    int n2;
                    bl = false;
                    segment.lock();
                    try {
                        e = segment.getEntry(object2, n);
                        if (e == null) {
                            bl = true;
                            n2 = segment.count;
                            if (n2++ > segment.threshold) {
                                segment.expand();
                            }
                            object3 = segment.table;
                            int n3 = n & ((AtomicReferenceArray)object3).length() - 1;
                            Object e2 = ((AtomicReferenceArray)object3).get(n3);
                            ++segment.modCount;
                            e = this.computingStrategy.newEntry(object2, n, e2);
                            ((AtomicReferenceArray)object3).set(n3, e);
                            segment.count = n2;
                        }
                    }
                    finally {
                        segment.unlock();
                    }
                    if (bl) {
                        n2 = 0;
                        try {
                            object3 = this.computingStrategy.compute((K)object2, e, this.computer);
                            if (object3 == null) {
                                throw new NullPointerException("compute() returned null unexpectedly");
                            }
                            n2 = 1;
                            Object object4 = object3;
                            return (V)object4;
                        }
                        finally {
                            if (n2 == 0) {
                                segment.removeEntry(e, n);
                            }
                        }
                    }
                }
                bl = false;
                while (true) {
                    try {
                        V v = this.computingStrategy.waitForValue(e);
                        if (v == null) {
                            segment.removeEntry(e, n);
                            continue block12;
                        }
                        object3 = v;
                        return (V)object3;
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                        continue;
                    }
                    break;
                }
                finally {
                    if (!bl) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Impl<K, V, E>
    extends AbstractMap<K, V>
    implements ConcurrentMap<K, V>,
    Serializable {
        static final int MAXIMUM_CAPACITY = 0x40000000;
        static final int MAX_SEGMENTS = 65536;
        static final int RETRIES_BEFORE_LOCK = 2;
        final Strategy<K, V, E> strategy;
        final int segmentMask;
        final int segmentShift;
        final Segment[] segments;
        Set<K> keySet;
        Collection<V> values;
        Set<Map.Entry<K, V>> entrySet;
        private static final long serialVersionUID = 1L;

        Impl(Strategy<K, V, E> strategy, Builder builder) {
            int n;
            int n2;
            int n3;
            int n4 = builder.getConcurrencyLevel();
            int n5 = builder.getInitialCapacity();
            if (n4 > 65536) {
                n4 = 65536;
            }
            int n6 = 0;
            for (n3 = 1; n3 < n4; n3 <<= 1) {
                ++n6;
            }
            this.segmentShift = 32 - n6;
            this.segmentMask = n3 - 1;
            this.segments = this.newSegmentArray(n3);
            if (n5 > 0x40000000) {
                n5 = 0x40000000;
            }
            if ((n2 = n5 / n3) * n3 < n5) {
                ++n2;
            }
            for (n = 1; n < n2; n <<= 1) {
            }
            for (int i = 0; i < this.segments.length; ++i) {
                this.segments[i] = new Segment(n);
            }
            this.strategy = strategy;
            strategy.setInternals(new InternalsImpl());
        }

        int hash(Object object) {
            int n = this.strategy.hashKey(object);
            return CustomConcurrentHashMap.rehash(n);
        }

        Segment[] newSegmentArray(int n) {
            return (Segment[])Array.newInstance(Segment.class, n);
        }

        Segment segmentFor(int n) {
            return this.segments[n >>> this.segmentShift & this.segmentMask];
        }

        @Override
        public boolean isEmpty() {
            int n;
            Segment[] segmentArray = this.segments;
            int[] nArray = new int[segmentArray.length];
            int n2 = 0;
            for (n = 0; n < segmentArray.length; ++n) {
                if (segmentArray[n].count != 0) {
                    return false;
                }
                nArray[n] = segmentArray[n].modCount;
                n2 += nArray[n];
            }
            if (n2 != 0) {
                for (n = 0; n < segmentArray.length; ++n) {
                    if (segmentArray[n].count == 0 && nArray[n] == segmentArray[n].modCount) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public int size() {
            Segment[] segmentArray = this.segments;
            long l = 0L;
            long l2 = 0L;
            int[] nArray = new int[segmentArray.length];
            for (int i = 0; i < 2; ++i) {
                int n;
                l2 = 0L;
                l = 0L;
                int n2 = 0;
                for (n = 0; n < segmentArray.length; ++n) {
                    l += (long)segmentArray[n].count;
                    nArray[n] = segmentArray[n].modCount;
                    n2 += nArray[n];
                }
                if (n2 != 0) {
                    for (n = 0; n < segmentArray.length; ++n) {
                        l2 += (long)segmentArray[n].count;
                        if (nArray[n] == segmentArray[n].modCount) continue;
                        l2 = -1L;
                        break;
                    }
                }
                if (l2 == l) break;
            }
            if (l2 != l) {
                l = 0L;
                for (Segment segment : segmentArray) {
                    segment.lock();
                }
                for (Segment segment : segmentArray) {
                    l += (long)segment.count;
                }
                for (Segment segment : segmentArray) {
                    segment.unlock();
                }
            }
            if (l > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)l;
        }

        @Override
        public V get(Object object) {
            if (object == null) {
                throw new NullPointerException("key");
            }
            int n = this.hash(object);
            return this.segmentFor(n).get(object, n);
        }

        @Override
        public boolean containsKey(Object object) {
            if (object == null) {
                throw new NullPointerException("key");
            }
            int n = this.hash(object);
            return this.segmentFor(n).containsKey(object, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object object) {
            if (object == null) {
                throw new NullPointerException("value");
            }
            Segment[] segmentArray = this.segments;
            int[] nArray = new int[segmentArray.length];
            for (int i = 0; i < 2; ++i) {
                int n;
                int n2;
                int n3 = 0;
                for (n2 = 0; n2 < segmentArray.length; ++n2) {
                    n = segmentArray[n2].count;
                    nArray[n2] = segmentArray[n2].modCount;
                    n3 += nArray[n2];
                    if (!segmentArray[n2].containsValue(object)) continue;
                    return true;
                }
                n2 = 1;
                if (n3 != 0) {
                    for (n = 0; n < segmentArray.length; ++n) {
                        int n4 = segmentArray[n].count;
                        if (nArray[n] == segmentArray[n].modCount) continue;
                        n2 = 0;
                        break;
                    }
                }
                if (n2 == 0) continue;
                return false;
            }
            for (Segment segment : segmentArray) {
                segment.lock();
            }
            boolean bl = false;
            try {
                for (Segment segment : segmentArray) {
                    if (!segment.containsValue(object)) continue;
                    bl = true;
                    break;
                }
            }
            finally {
                for (Segment segment : segmentArray) {
                    segment.unlock();
                }
            }
            return bl;
        }

        @Override
        public V put(K k, V v) {
            if (k == null) {
                throw new NullPointerException("key");
            }
            if (v == null) {
                throw new NullPointerException("value");
            }
            int n = this.hash(k);
            return this.segmentFor(n).put(k, n, v, false);
        }

        @Override
        public V putIfAbsent(K k, V v) {
            if (k == null) {
                throw new NullPointerException("key");
            }
            if (v == null) {
                throw new NullPointerException("value");
            }
            int n = this.hash(k);
            return this.segmentFor(n).put(k, n, v, true);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public V remove(Object object) {
            if (object == null) {
                throw new NullPointerException("key");
            }
            int n = this.hash(object);
            return this.segmentFor(n).remove(object, n);
        }

        @Override
        public boolean remove(Object object, Object object2) {
            if (object == null) {
                throw new NullPointerException("key");
            }
            int n = this.hash(object);
            return this.segmentFor(n).remove(object, n, object2);
        }

        @Override
        public boolean replace(K k, V v, V v2) {
            if (k == null) {
                throw new NullPointerException("key");
            }
            if (v == null) {
                throw new NullPointerException("oldValue");
            }
            if (v2 == null) {
                throw new NullPointerException("newValue");
            }
            int n = this.hash(k);
            return this.segmentFor(n).replace(k, n, v, v2);
        }

        @Override
        public V replace(K k, V v) {
            if (k == null) {
                throw new NullPointerException("key");
            }
            if (v == null) {
                throw new NullPointerException("value");
            }
            int n = this.hash(k);
            return this.segmentFor(n).replace(k, n, v);
        }

        @Override
        public void clear() {
            for (Segment segment : this.segments) {
                segment.clear();
            }
        }

        @Override
        public Set<K> keySet() {
            KeySet keySet = this.keySet;
            return keySet != null ? keySet : (this.keySet = new KeySet());
        }

        @Override
        public Collection<V> values() {
            Values values = this.values;
            return values != null ? values : (this.values = new Values());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            EntrySet entrySet = this.entrySet;
            return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeInt(this.size());
            objectOutputStream.writeInt(this.segments.length);
            objectOutputStream.writeObject(this.strategy);
            for (Map.Entry<K, V> entry : this.entrySet()) {
                objectOutputStream.writeObject(entry.getKey());
                objectOutputStream.writeObject(entry.getValue());
            }
            objectOutputStream.writeObject(null);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            try {
                Object object;
                int n;
                int n2;
                int n3;
                int n4 = objectInputStream.readInt();
                int n5 = objectInputStream.readInt();
                Strategy strategy = (Strategy)objectInputStream.readObject();
                if (n5 > 65536) {
                    n5 = 65536;
                }
                int n6 = 0;
                for (n3 = 1; n3 < n5; n3 <<= 1) {
                    ++n6;
                }
                Fields.segmentShift.set(this, 32 - n6);
                Fields.segmentMask.set(this, n3 - 1);
                Fields.segments.set(this, this.newSegmentArray(n3));
                if (n4 > 0x40000000) {
                    n4 = 0x40000000;
                }
                if ((n2 = n4 / n3) * n3 < n4) {
                    ++n2;
                }
                for (n = 1; n < n2; n <<= 1) {
                }
                for (int i = 0; i < this.segments.length; ++i) {
                    this.segments[i] = new Segment(n);
                }
                Fields.strategy.set(this, strategy);
                while ((object = objectInputStream.readObject()) != null) {
                    Object object2 = objectInputStream.readObject();
                    this.put(object, object2);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
        }

        static class Fields {
            static final Field segmentShift = Fields.findField("segmentShift");
            static final Field segmentMask = Fields.findField("segmentMask");
            static final Field segments = Fields.findField("segments");
            static final Field strategy = Fields.findField("strategy");

            Fields() {
            }

            static Field findField(String string) {
                try {
                    Field field = Impl.class.getDeclaredField(string);
                    field.setAccessible(true);
                    return field;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new AssertionError((Object)noSuchFieldException);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class EntrySet
        extends AbstractSet<Map.Entry<K, V>> {
            EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIterator();
            }

            @Override
            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                if (k == null) {
                    return false;
                }
                Object v = Impl.this.get(k);
                return v != null && Impl.this.strategy.equalValues(v, entry.getValue());
            }

            @Override
            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                return k != null && Impl.this.remove(k, entry.getValue());
            }

            @Override
            public int size() {
                return Impl.this.size();
            }

            @Override
            public boolean isEmpty() {
                return Impl.this.isEmpty();
            }

            @Override
            public void clear() {
                Impl.this.clear();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class Values
        extends AbstractCollection<V> {
            Values() {
            }

            @Override
            public Iterator<V> iterator() {
                return new ValueIterator();
            }

            @Override
            public int size() {
                return Impl.this.size();
            }

            @Override
            public boolean isEmpty() {
                return Impl.this.isEmpty();
            }

            @Override
            public boolean contains(Object object) {
                return Impl.this.containsValue(object);
            }

            @Override
            public void clear() {
                Impl.this.clear();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class KeySet
        extends AbstractSet<K> {
            KeySet() {
            }

            @Override
            public Iterator<K> iterator() {
                return new KeyIterator();
            }

            @Override
            public int size() {
                return Impl.this.size();
            }

            @Override
            public boolean isEmpty() {
                return Impl.this.isEmpty();
            }

            @Override
            public boolean contains(Object object) {
                return Impl.this.containsKey(object);
            }

            @Override
            public boolean remove(Object object) {
                return Impl.this.remove(object) != null;
            }

            @Override
            public void clear() {
                Impl.this.clear();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class EntryIterator
        extends HashIterator
        implements Iterator<Map.Entry<K, V>> {
            EntryIterator() {
            }

            @Override
            public Map.Entry<K, V> next() {
                return this.nextEntry();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class WriteThroughEntry
        extends AbstractMapEntry<K, V> {
            final K key;
            V value;

            WriteThroughEntry(K k, V v) {
                this.key = k;
                this.value = v;
            }

            @Override
            public K getKey() {
                return this.key;
            }

            @Override
            public V getValue() {
                return this.value;
            }

            @Override
            public V setValue(V v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                Object v2 = Impl.this.put(this.getKey(), v);
                this.value = v;
                return v2;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class ValueIterator
        extends HashIterator
        implements Iterator<V> {
            ValueIterator() {
            }

            @Override
            public V next() {
                return super.nextEntry().getValue();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class KeyIterator
        extends HashIterator
        implements Iterator<K> {
            KeyIterator() {
            }

            @Override
            public K next() {
                return super.nextEntry().getKey();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        abstract class HashIterator {
            int nextSegmentIndex;
            int nextTableIndex;
            AtomicReferenceArray<E> currentTable;
            E nextEntry;
            WriteThroughEntry nextExternal;
            WriteThroughEntry lastReturned;

            HashIterator() {
                this.nextSegmentIndex = Impl.this.segments.length - 1;
                this.nextTableIndex = -1;
                this.advance();
            }

            public boolean hasMoreElements() {
                return this.hasNext();
            }

            final void advance() {
                this.nextExternal = null;
                if (this.nextInChain()) {
                    return;
                }
                if (this.nextInTable()) {
                    return;
                }
                while (this.nextSegmentIndex >= 0) {
                    Segment segment = Impl.this.segments[this.nextSegmentIndex--];
                    if (segment.count == 0) continue;
                    this.currentTable = segment.table;
                    this.nextTableIndex = this.currentTable.length() - 1;
                    if (!this.nextInTable()) continue;
                    return;
                }
            }

            boolean nextInChain() {
                Strategy strategy = Impl.this.strategy;
                if (this.nextEntry != null) {
                    this.nextEntry = strategy.getNext(this.nextEntry);
                    while (this.nextEntry != null) {
                        if (this.advanceTo(this.nextEntry)) {
                            return true;
                        }
                        this.nextEntry = strategy.getNext(this.nextEntry);
                    }
                }
                return false;
            }

            boolean nextInTable() {
                while (this.nextTableIndex >= 0) {
                    if ((this.nextEntry = this.currentTable.get(this.nextTableIndex--)) == null || !this.advanceTo(this.nextEntry) && !this.nextInChain()) continue;
                    return true;
                }
                return false;
            }

            boolean advanceTo(E e) {
                Strategy strategy = Impl.this.strategy;
                Object k = strategy.getKey(e);
                Object v = strategy.getValue(e);
                if (k != null && v != null) {
                    this.nextExternal = new WriteThroughEntry(k, v);
                    return true;
                }
                return false;
            }

            public boolean hasNext() {
                return this.nextExternal != null;
            }

            WriteThroughEntry nextEntry() {
                if (this.nextExternal == null) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.nextExternal;
                this.advance();
                return this.lastReturned;
            }

            public void remove() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                Impl.this.remove(this.lastReturned.getKey());
                this.lastReturned = null;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class Segment
        extends ReentrantLock {
            volatile int count;
            int modCount;
            int threshold;
            volatile AtomicReferenceArray<E> table;

            Segment(int n) {
                this.setTable(this.newEntryArray(n));
            }

            AtomicReferenceArray<E> newEntryArray(int n) {
                return new AtomicReferenceArray(n);
            }

            void setTable(AtomicReferenceArray<E> atomicReferenceArray) {
                this.threshold = atomicReferenceArray.length() * 3 / 4;
                this.table = atomicReferenceArray;
            }

            E getFirst(int n) {
                AtomicReferenceArray atomicReferenceArray = this.table;
                return atomicReferenceArray.get(n & atomicReferenceArray.length() - 1);
            }

            public E getEntry(Object object, int n) {
                Strategy strategy = Impl.this.strategy;
                if (this.count != 0) {
                    Object e = this.getFirst(n);
                    while (e != null) {
                        Object k;
                        if (strategy.getHash(e) == n && (k = strategy.getKey(e)) != null && strategy.equalKeys(k, object)) {
                            return e;
                        }
                        e = strategy.getNext(e);
                    }
                }
                return null;
            }

            V get(Object object, int n) {
                Object e = this.getEntry(object, n);
                if (e == null) {
                    return null;
                }
                return Impl.this.strategy.getValue(e);
            }

            boolean containsKey(Object object, int n) {
                Strategy strategy = Impl.this.strategy;
                if (this.count != 0) {
                    Object e = this.getFirst(n);
                    while (e != null) {
                        Object k;
                        if (strategy.getHash(e) == n && (k = strategy.getKey(e)) != null && strategy.equalKeys(k, object)) {
                            return strategy.getValue(e) != null;
                        }
                        e = strategy.getNext(e);
                    }
                }
                return false;
            }

            boolean containsValue(Object object) {
                Strategy strategy = Impl.this.strategy;
                if (this.count != 0) {
                    AtomicReferenceArray atomicReferenceArray = this.table;
                    int n = atomicReferenceArray.length();
                    for (int i = 0; i < n; ++i) {
                        Object e = atomicReferenceArray.get(i);
                        while (e != null) {
                            Object v = strategy.getValue(e);
                            if (v != null && strategy.equalValues(v, object)) {
                                return true;
                            }
                            e = strategy.getNext(e);
                        }
                    }
                }
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            boolean replace(K k, int n, V v, V v2) {
                Strategy strategy = Impl.this.strategy;
                this.lock();
                try {
                    Object e = this.getFirst(n);
                    while (e != null) {
                        Object k2 = strategy.getKey(e);
                        if (strategy.getHash(e) == n && k2 != null && strategy.equalKeys(k, k2)) {
                            Object v3 = strategy.getValue(e);
                            if (v3 == null) {
                                boolean bl = false;
                                return bl;
                            }
                            if (strategy.equalValues(v3, v)) {
                                strategy.setValue(e, v2);
                                boolean bl = true;
                                return bl;
                            }
                        }
                        e = strategy.getNext(e);
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            V replace(K k, int n, V v) {
                Strategy strategy = Impl.this.strategy;
                this.lock();
                try {
                    Object e = this.getFirst(n);
                    while (e != null) {
                        Object k2 = strategy.getKey(e);
                        if (strategy.getHash(e) == n && k2 != null && strategy.equalKeys(k, k2)) {
                            Object v2 = strategy.getValue(e);
                            if (v2 == null) {
                                Object v3 = null;
                                return v3;
                            }
                            strategy.setValue(e, v);
                            Object v4 = v2;
                            return v4;
                        }
                        e = strategy.getNext(e);
                    }
                    e = null;
                    return e;
                }
                finally {
                    this.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            V put(K k, int n, V v, boolean bl) {
                Strategy strategy = Impl.this.strategy;
                this.lock();
                try {
                    Object k2;
                    Object e;
                    int n2 = this.count;
                    if (n2++ > this.threshold) {
                        this.expand();
                    }
                    AtomicReferenceArray atomicReferenceArray = this.table;
                    int n3 = n & atomicReferenceArray.length() - 1;
                    Object e2 = e = atomicReferenceArray.get(n3);
                    while (e2 != null) {
                        k2 = strategy.getKey(e2);
                        if (strategy.getHash(e2) == n && k2 != null && strategy.equalKeys(k, k2)) {
                            Object v2 = strategy.getValue(e2);
                            if (bl && v2 != null) {
                                Object v3 = v2;
                                return v3;
                            }
                            strategy.setValue(e2, v);
                            Object v4 = v2;
                            return v4;
                        }
                        e2 = strategy.getNext(e2);
                    }
                    ++this.modCount;
                    e2 = strategy.newEntry(k, n, e);
                    strategy.setValue(e2, v);
                    atomicReferenceArray.set(n3, e2);
                    this.count = n2;
                    k2 = null;
                    return k2;
                }
                finally {
                    this.unlock();
                }
            }

            void expand() {
                AtomicReferenceArray atomicReferenceArray = this.table;
                int n = atomicReferenceArray.length();
                if (n >= 0x40000000) {
                    return;
                }
                Strategy strategy = Impl.this.strategy;
                AtomicReferenceArray atomicReferenceArray2 = this.newEntryArray(n << 1);
                this.threshold = atomicReferenceArray2.length() * 3 / 4;
                int n2 = atomicReferenceArray2.length() - 1;
                for (int i = 0; i < n; ++i) {
                    Object e = atomicReferenceArray.get(i);
                    if (e == null) continue;
                    Object e2 = strategy.getNext(e);
                    int n3 = strategy.getHash(e) & n2;
                    if (e2 == null) {
                        atomicReferenceArray2.set(n3, e);
                        continue;
                    }
                    Object e3 = e;
                    int n4 = n3;
                    Object e4 = e2;
                    while (e4 != null) {
                        int n5 = strategy.getHash(e4) & n2;
                        if (n5 != n4) {
                            n4 = n5;
                            e3 = e4;
                        }
                        e4 = strategy.getNext(e4);
                    }
                    atomicReferenceArray2.set(n4, e3);
                    e4 = e;
                    while (e4 != e3) {
                        Object k = strategy.getKey(e4);
                        if (k != null) {
                            int n6 = strategy.getHash(e4) & n2;
                            Object e5 = atomicReferenceArray2.get(n6);
                            atomicReferenceArray2.set(n6, strategy.copyEntry(k, e4, e5));
                        }
                        e4 = strategy.getNext(e4);
                    }
                }
                this.table = atomicReferenceArray2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            V remove(Object object, int n) {
                Strategy strategy = Impl.this.strategy;
                this.lock();
                try {
                    Object e;
                    int n2 = this.count - 1;
                    AtomicReferenceArray atomicReferenceArray = this.table;
                    int n3 = n & atomicReferenceArray.length() - 1;
                    Object e2 = e = atomicReferenceArray.get(n3);
                    while (e2 != null) {
                        Object k = strategy.getKey(e2);
                        if (strategy.getHash(e2) == n && k != null && strategy.equalKeys(k, object)) {
                            Object v = Impl.this.strategy.getValue(e2);
                            ++this.modCount;
                            Object e3 = strategy.getNext(e2);
                            Object object2 = e;
                            while (object2 != e2) {
                                Object k2 = strategy.getKey(object2);
                                if (k2 != null) {
                                    e3 = strategy.copyEntry(k2, object2, e3);
                                }
                                object2 = strategy.getNext(object2);
                            }
                            atomicReferenceArray.set(n3, e3);
                            this.count = n2;
                            object2 = v;
                            return object2;
                        }
                        e2 = strategy.getNext(e2);
                    }
                    e2 = null;
                    return e2;
                }
                finally {
                    this.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            boolean remove(Object object, int n, Object object2) {
                Strategy strategy = Impl.this.strategy;
                this.lock();
                try {
                    Object e;
                    int n2 = this.count - 1;
                    AtomicReferenceArray atomicReferenceArray = this.table;
                    int n3 = n & atomicReferenceArray.length() - 1;
                    Object e2 = e = atomicReferenceArray.get(n3);
                    while (e2 != null) {
                        Object k = strategy.getKey(e2);
                        if (strategy.getHash(e2) == n && k != null && strategy.equalKeys(k, object)) {
                            Object v = Impl.this.strategy.getValue(e2);
                            if (object2 == v || object2 != null && v != null && strategy.equalValues(v, object2)) {
                                ++this.modCount;
                                Object e3 = strategy.getNext(e2);
                                Object e4 = e;
                                while (e4 != e2) {
                                    Object k2 = strategy.getKey(e4);
                                    if (k2 != null) {
                                        e3 = strategy.copyEntry(k2, e4, e3);
                                    }
                                    e4 = strategy.getNext(e4);
                                }
                                atomicReferenceArray.set(n3, e3);
                                this.count = n2;
                                boolean bl = true;
                                return bl;
                            }
                            boolean bl = false;
                            return bl;
                        }
                        e2 = strategy.getNext(e2);
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean removeEntry(E e, int n, V v) {
                Strategy strategy = Impl.this.strategy;
                this.lock();
                try {
                    Object e2;
                    int n2 = this.count - 1;
                    AtomicReferenceArray atomicReferenceArray = this.table;
                    int n3 = n & atomicReferenceArray.length() - 1;
                    Object e3 = e2 = atomicReferenceArray.get(n3);
                    while (e3 != null) {
                        if (strategy.getHash(e3) == n && e.equals(e3)) {
                            Object v2 = strategy.getValue(e3);
                            if (v2 == v || v != null && strategy.equalValues(v2, v)) {
                                ++this.modCount;
                                Object e4 = strategy.getNext(e3);
                                Object e5 = e2;
                                while (e5 != e3) {
                                    Object k = strategy.getKey(e5);
                                    if (k != null) {
                                        e4 = strategy.copyEntry(k, e5, e4);
                                    }
                                    e5 = strategy.getNext(e5);
                                }
                                atomicReferenceArray.set(n3, e4);
                                this.count = n2;
                                boolean bl = true;
                                return bl;
                            }
                            boolean bl = false;
                            return bl;
                        }
                        e3 = strategy.getNext(e3);
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean removeEntry(E e, int n) {
                Strategy strategy = Impl.this.strategy;
                this.lock();
                try {
                    Object e2;
                    int n2 = this.count - 1;
                    AtomicReferenceArray atomicReferenceArray = this.table;
                    int n3 = n & atomicReferenceArray.length() - 1;
                    Object e3 = e2 = atomicReferenceArray.get(n3);
                    while (e3 != null) {
                        if (strategy.getHash(e3) == n && e.equals(e3)) {
                            ++this.modCount;
                            Object e4 = strategy.getNext(e3);
                            Object e5 = e2;
                            while (e5 != e3) {
                                Object k = strategy.getKey(e5);
                                if (k != null) {
                                    e4 = strategy.copyEntry(k, e5, e4);
                                }
                                e5 = strategy.getNext(e5);
                            }
                            atomicReferenceArray.set(n3, e4);
                            this.count = n2;
                            boolean bl = true;
                            return bl;
                        }
                        e3 = strategy.getNext(e3);
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void clear() {
                if (this.count != 0) {
                    this.lock();
                    try {
                        AtomicReferenceArray atomicReferenceArray = this.table;
                        for (int i = 0; i < atomicReferenceArray.length(); ++i) {
                            atomicReferenceArray.set(i, null);
                        }
                        ++this.modCount;
                        this.count = 0;
                    }
                    finally {
                        this.unlock();
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class InternalsImpl
        implements Internals<K, V, E>,
        Serializable {
            static final long serialVersionUID = 0L;

            InternalsImpl() {
            }

            @Override
            public E getEntry(K k) {
                if (k == null) {
                    throw new NullPointerException("key");
                }
                int n = Impl.this.hash(k);
                return Impl.this.segmentFor(n).getEntry(k, n);
            }

            @Override
            public boolean removeEntry(E e, V v) {
                if (e == null) {
                    throw new NullPointerException("entry");
                }
                int n = Impl.this.strategy.getHash(e);
                return Impl.this.segmentFor(n).removeEntry(e, n, v);
            }

            @Override
            public boolean removeEntry(E e) {
                if (e == null) {
                    throw new NullPointerException("entry");
                }
                int n = Impl.this.strategy.getHash(e);
                return Impl.this.segmentFor(n).removeEntry(e, n);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ComputingStrategy<K, V, E>
    extends Strategy<K, V, E> {
        public V compute(K var1, E var2, Function<? super K, ? extends V> var3);

        public V waitForValue(E var1) throws InterruptedException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Internals<K, V, E> {
        public E getEntry(K var1);

        public boolean removeEntry(E var1, @Nullable V var2);

        public boolean removeEntry(E var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Strategy<K, V, E> {
        public E newEntry(K var1, int var2, E var3);

        public E copyEntry(K var1, E var2, E var3);

        public void setValue(E var1, V var2);

        public V getValue(E var1);

        public boolean equalKeys(K var1, Object var2);

        public boolean equalValues(V var1, Object var2);

        public int hashKey(Object var1);

        public K getKey(E var1);

        public E getNext(E var1);

        public int getHash(E var1);

        public void setInternals(Internals<K, V, E> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Builder {
        private static final int DEFAULT_INITIAL_CAPACITY = 16;
        private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
        private static final int UNSET_INITIAL_CAPACITY = -1;
        private static final int UNSET_CONCURRENCY_LEVEL = -1;
        int initialCapacity = -1;
        int concurrencyLevel = -1;

        Builder() {
        }

        public Builder initialCapacity(int n) {
            if (this.initialCapacity != -1) {
                throw new IllegalStateException("initial capacity was already set to " + this.initialCapacity);
            }
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            this.initialCapacity = n;
            return this;
        }

        public Builder concurrencyLevel(int n) {
            if (this.concurrencyLevel != -1) {
                throw new IllegalStateException("concurrency level was already set to " + this.concurrencyLevel);
            }
            if (n <= 0) {
                throw new IllegalArgumentException();
            }
            this.concurrencyLevel = n;
            return this;
        }

        public <K, V, E> ConcurrentMap<K, V> buildMap(Strategy<K, V, E> strategy) {
            if (strategy == null) {
                throw new NullPointerException("strategy");
            }
            return new Impl<K, V, E>(strategy, this);
        }

        public <K, V, E> ConcurrentMap<K, V> buildComputingMap(ComputingStrategy<K, V, E> computingStrategy, Function<? super K, ? extends V> function) {
            if (computingStrategy == null) {
                throw new NullPointerException("strategy");
            }
            if (function == null) {
                throw new NullPointerException("computer");
            }
            return new ComputingImpl<K, V, E>(computingStrategy, this, function);
        }

        int getInitialCapacity() {
            return this.initialCapacity == -1 ? 16 : this.initialCapacity;
        }

        int getConcurrencyLevel() {
            return this.concurrencyLevel == -1 ? 16 : this.concurrencyLevel;
        }
    }
}

