/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.EmptyImmutableList;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Lists;
import com.google.common.collect.RegularImmutableList;
import com.google.common.collect.SingletonImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true)
public abstract class ImmutableList<E>
extends ImmutableCollection<E>
implements List<E>,
RandomAccess {
    public static <E> ImmutableList<E> of() {
        return EmptyImmutableList.INSTANCE;
    }

    public static <E> ImmutableList<E> of(E e) {
        return new SingletonImmutableList<E>(e);
    }

    public static <E> ImmutableList<E> of(E e, E e2) {
        return new RegularImmutableList(ImmutableList.copyIntoArray(e, e2));
    }

    public static <E> ImmutableList<E> of(E e, E e2, E e3) {
        return new RegularImmutableList(ImmutableList.copyIntoArray(e, e2, e3));
    }

    public static <E> ImmutableList<E> of(E e, E e2, E e3, E e4) {
        return new RegularImmutableList(ImmutableList.copyIntoArray(e, e2, e3, e4));
    }

    public static <E> ImmutableList<E> of(E e, E e2, E e3, E e4, E e5) {
        return new RegularImmutableList(ImmutableList.copyIntoArray(e, e2, e3, e4, e5));
    }

    public static <E> ImmutableList<E> of(E e, E e2, E e3, E e4, E e5, E e6) {
        return new RegularImmutableList(ImmutableList.copyIntoArray(e, e2, e3, e4, e5, e6));
    }

    public static <E> ImmutableList<E> of(E e, E e2, E e3, E e4, E e5, E e6, E e7) {
        return new RegularImmutableList(ImmutableList.copyIntoArray(e, e2, e3, e4, e5, e6, e7));
    }

    public static <E> ImmutableList<E> of(E e, E e2, E e3, E e4, E e5, E e6, E e7, E e8) {
        return new RegularImmutableList(ImmutableList.copyIntoArray(e, e2, e3, e4, e5, e6, e7, e8));
    }

    public static <E> ImmutableList<E> of(E e, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9) {
        return new RegularImmutableList(ImmutableList.copyIntoArray(e, e2, e3, e4, e5, e6, e7, e8, e9));
    }

    public static <E> ImmutableList<E> of(E e, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9, E e10) {
        return new RegularImmutableList(ImmutableList.copyIntoArray(e, e2, e3, e4, e5, e6, e7, e8, e9, e10));
    }

    public static <E> ImmutableList<E> of(E e, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9, E e10, E e11) {
        return new RegularImmutableList(ImmutableList.copyIntoArray(e, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11));
    }

    public static <E> ImmutableList<E> of(E ... EArray) {
        Preconditions.checkNotNull(EArray);
        switch (EArray.length) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return new SingletonImmutableList<E>(EArray[0]);
            }
        }
        return new RegularImmutableList(ImmutableList.copyIntoArray(EArray));
    }

    public static <E> ImmutableList<E> copyOf(Iterable<? extends E> iterable) {
        Preconditions.checkNotNull(iterable);
        return iterable instanceof Collection ? ImmutableList.copyOf((Collection)iterable) : ImmutableList.copyOf(iterable.iterator());
    }

    public static <E> ImmutableList<E> copyOf(Collection<? extends E> collection) {
        Preconditions.checkNotNull(collection);
        if (collection instanceof ImmutableList) {
            ImmutableList immutableList = (ImmutableList)collection;
            return immutableList;
        }
        return ImmutableList.copyFromCollection(collection);
    }

    public static <E> ImmutableList<E> copyOf(Iterator<? extends E> iterator) {
        return ImmutableList.copyFromCollection(Lists.newArrayList(iterator));
    }

    private static <E> ImmutableList<E> copyFromCollection(Collection<? extends E> collection) {
        Object[] objectArray = collection.toArray();
        switch (objectArray.length) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                SingletonImmutableList<Object> singletonImmutableList = new SingletonImmutableList<Object>(objectArray[0]);
                return singletonImmutableList;
            }
        }
        return new RegularImmutableList(ImmutableList.copyIntoArray(objectArray));
    }

    ImmutableList() {
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    public abstract int indexOf(@Nullable Object var1);

    @Override
    public abstract int lastIndexOf(@Nullable Object var1);

    @Override
    public abstract ImmutableList<E> subList(int var1, int var2);

    @Override
    public final boolean addAll(int n, Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final E set(int n, E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void add(int n, E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final E remove(int n) {
        throw new UnsupportedOperationException();
    }

    private static Object[] copyIntoArray(Object ... objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        int n = 0;
        for (Object object : objectArray) {
            if (object == null) {
                throw new NullPointerException("at index " + n);
            }
            objectArray2[n++] = object;
        }
        return objectArray2;
    }

    @Override
    public ImmutableList<E> asList() {
        return this;
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this.toArray());
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder<E>
    extends ImmutableCollection.Builder<E> {
        private final ArrayList<E> contents = Lists.newArrayList();

        @Override
        public Builder<E> add(E e) {
            this.contents.add(Preconditions.checkNotNull(e));
            return this;
        }

        @Override
        public Builder<E> addAll(Iterable<? extends E> iterable) {
            if (iterable instanceof Collection) {
                Collection collection = (Collection)iterable;
                this.contents.ensureCapacity(this.contents.size() + collection.size());
            }
            super.addAll(iterable);
            return this;
        }

        @Override
        public Builder<E> add(E ... EArray) {
            Preconditions.checkNotNull(EArray);
            this.contents.ensureCapacity(this.contents.size() + EArray.length);
            super.add(EArray);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterator<? extends E> iterator) {
            super.addAll(iterator);
            return this;
        }

        @Override
        public ImmutableList<E> build() {
            return ImmutableList.copyOf(this.contents);
        }
    }

    private static class SerializedForm
    implements Serializable {
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        SerializedForm(Object[] objectArray) {
            this.elements = objectArray;
        }

        Object readResolve() {
            return ImmutableList.of(this.elements);
        }
    }
}

