/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.EmptyImmutableMultiset;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Serialization;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true)
public class ImmutableMultiset<E>
extends ImmutableCollection<E>
implements Multiset<E> {
    private final transient ImmutableMap<E, Integer> map;
    private final transient int size;
    private transient ImmutableSet<Multiset.Entry<E>> entrySet;
    private static final long serialVersionUID = 0L;

    public static <E> ImmutableMultiset<E> of() {
        return EmptyImmutableMultiset.INSTANCE;
    }

    public static <E> ImmutableMultiset<E> of(E ... EArray) {
        return ImmutableMultiset.copyOf(Arrays.asList(EArray));
    }

    public static <E> ImmutableMultiset<E> copyOf(Iterable<? extends E> iterable) {
        if (iterable instanceof ImmutableMultiset) {
            ImmutableMultiset immutableMultiset = (ImmutableMultiset)iterable;
            return immutableMultiset;
        }
        LinkedHashMultiset<? extends E> linkedHashMultiset = iterable instanceof Multiset ? (LinkedHashMultiset<? extends E>)iterable : LinkedHashMultiset.create(iterable);
        return ImmutableMultiset.copyOfInternal(linkedHashMultiset);
    }

    private static <E> ImmutableMultiset<E> copyOfInternal(Multiset<? extends E> multiset) {
        long l = 0L;
        ImmutableMap.Builder<E, Integer> builder = ImmutableMap.builder();
        for (Multiset.Entry<E> entry : multiset.entrySet()) {
            int n = entry.getCount();
            if (n <= 0) continue;
            builder.put(entry.getElement(), n);
            l += (long)n;
        }
        if (l == 0L) {
            return ImmutableMultiset.of();
        }
        return new ImmutableMultiset(builder.build(), (int)Math.min(l, Integer.MAX_VALUE));
    }

    public static <E> ImmutableMultiset<E> copyOf(Iterator<? extends E> iterator) {
        LinkedHashMultiset linkedHashMultiset = LinkedHashMultiset.create();
        Iterators.addAll(linkedHashMultiset, iterator);
        return ImmutableMultiset.copyOfInternal(linkedHashMultiset);
    }

    ImmutableMultiset(ImmutableMap<E, Integer> immutableMap, int n) {
        this.map = immutableMap;
        this.size = n;
    }

    @Override
    public int count(@Nullable Object object) {
        Integer n = this.map.get(object);
        return n == null ? 0 : n;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        final Iterator iterator = ((ImmutableSet)this.map.entrySet()).iterator();
        return new UnmodifiableIterator<E>(){
            int remaining;
            E element;

            @Override
            public boolean hasNext() {
                return this.remaining > 0 || iterator.hasNext();
            }

            @Override
            public E next() {
                if (this.remaining <= 0) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    this.element = entry.getKey();
                    this.remaining = (Integer)entry.getValue();
                }
                --this.remaining;
                return this.element;
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public int add(E e, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int remove(Object object, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int setCount(E e, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setCount(E e, int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Multiset) {
            Multiset multiset = (Multiset)object;
            if (this.size() != multiset.size()) {
                return false;
            }
            for (Multiset.Entry entry : multiset.entrySet()) {
                if (this.count(entry.getElement()) == entry.getCount()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public String toString() {
        return this.entrySet().toString();
    }

    @Override
    public Set<E> elementSet() {
        return this.map.keySet();
    }

    @Override
    public Set<Multiset.Entry<E>> entrySet() {
        ImmutableSet<Multiset.Entry<Multiset.Entry<E>>> immutableSet = this.entrySet;
        return immutableSet == null ? (this.entrySet = new EntrySet(this)) : immutableSet;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Serialization.writeMultiset(this, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        ImmutableMap.Builder<Object, Integer> builder = ImmutableMap.builder();
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            int n2 = objectInputStream.readInt();
            if (n2 <= 0) {
                throw new InvalidObjectException("Invalid count " + n2);
            }
            builder.put(object, n2);
            l += (long)n2;
        }
        FieldSettersHolder.MAP_FIELD_SETTER.set(this, builder.build());
        FieldSettersHolder.SIZE_FIELD_SETTER.set(this, (int)Math.min(l, Integer.MAX_VALUE));
    }

    @Override
    Object writeReplace() {
        return this;
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder<E>
    extends ImmutableCollection.Builder<E> {
        private final Multiset<E> contents = LinkedHashMultiset.create();

        @Override
        public Builder<E> add(E e) {
            this.contents.add(Preconditions.checkNotNull(e));
            return this;
        }

        public Builder<E> addCopies(E e, int n) {
            this.contents.add(Preconditions.checkNotNull(e), n);
            return this;
        }

        public Builder<E> setCount(E e, int n) {
            this.contents.setCount(Preconditions.checkNotNull(e), n);
            return this;
        }

        @Override
        public Builder<E> add(E ... EArray) {
            super.add(EArray);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterable<? extends E> iterable) {
            if (iterable instanceof Multiset) {
                Multiset multiset = (Multiset)iterable;
                for (Multiset.Entry entry : multiset.entrySet()) {
                    this.addCopies(entry.getElement(), entry.getCount());
                }
            } else {
                super.addAll(iterable);
            }
            return this;
        }

        @Override
        public Builder<E> addAll(Iterator<? extends E> iterator) {
            super.addAll(iterator);
            return this;
        }

        @Override
        public ImmutableMultiset<E> build() {
            return ImmutableMultiset.copyOf(this.contents);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntrySet<E>
    extends ImmutableSet<Multiset.Entry<E>> {
        final ImmutableMultiset<E> multiset;
        private static final long serialVersionUID = 0L;

        public EntrySet(ImmutableMultiset<E> immutableMultiset) {
            this.multiset = immutableMultiset;
        }

        @Override
        public UnmodifiableIterator<Multiset.Entry<E>> iterator() {
            final Iterator iterator = ((ImmutableSet)((ImmutableMultiset)this.multiset).map.entrySet()).iterator();
            return new UnmodifiableIterator<Multiset.Entry<E>>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Multiset.Entry<E> next() {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    return Multisets.immutableEntry(entry.getKey(), (Integer)entry.getValue());
                }
            };
        }

        @Override
        public int size() {
            return ((ImmutableMultiset)this.multiset).map.size();
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Multiset.Entry) {
                Multiset.Entry entry = (Multiset.Entry)object;
                if (entry.getCount() <= 0) {
                    return false;
                }
                int n = this.multiset.count(entry.getElement());
                return n == entry.getCount();
            }
            return false;
        }

        @Override
        public int hashCode() {
            return ((ImmutableMultiset)this.multiset).map.hashCode();
        }

        @Override
        Object writeReplace() {
            return this;
        }
    }

    private static class FieldSettersHolder {
        static final Serialization.FieldSetter<ImmutableMultiset> MAP_FIELD_SETTER = Serialization.getFieldSetter(ImmutableMultiset.class, "map");
        static final Serialization.FieldSetter<ImmutableMultiset> SIZE_FIELD_SETTER = Serialization.getFieldSetter(ImmutableMultiset.class, "size");

        private FieldSettersHolder() {
        }
    }
}

