/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Collections2;
import com.google.common.collect.EmptyImmutableSet;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableAsList;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Platform;
import com.google.common.collect.RegularImmutableSet;
import com.google.common.collect.SingletonImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true)
public abstract class ImmutableSet<E>
extends ImmutableCollection<E>
implements Set<E> {
    public static <E> ImmutableSet<E> of() {
        return EmptyImmutableSet.INSTANCE;
    }

    public static <E> ImmutableSet<E> of(E e) {
        return new SingletonImmutableSet<E>(e);
    }

    public static <E> ImmutableSet<E> of(E e, E e2) {
        return ImmutableSet.create(e, e2);
    }

    public static <E> ImmutableSet<E> of(E e, E e2, E e3) {
        return ImmutableSet.create(e, e2, e3);
    }

    public static <E> ImmutableSet<E> of(E e, E e2, E e3, E e4) {
        return ImmutableSet.create(e, e2, e3, e4);
    }

    public static <E> ImmutableSet<E> of(E e, E e2, E e3, E e4, E e5) {
        return ImmutableSet.create(e, e2, e3, e4, e5);
    }

    public static <E> ImmutableSet<E> of(E ... EArray) {
        Preconditions.checkNotNull(EArray);
        switch (EArray.length) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                return ImmutableSet.of(EArray[0]);
            }
        }
        return ImmutableSet.create(EArray);
    }

    public static <E> ImmutableSet<E> copyOf(Iterable<? extends E> iterable) {
        if (iterable instanceof ImmutableSet && !(iterable instanceof ImmutableSortedSet)) {
            ImmutableSet immutableSet = (ImmutableSet)iterable;
            return immutableSet;
        }
        return ImmutableSet.copyOfInternal(Collections2.toCollection(iterable));
    }

    public static <E> ImmutableSet<E> copyOf(Iterator<? extends E> iterator) {
        ArrayList<? extends E> arrayList = Lists.newArrayList(iterator);
        return ImmutableSet.copyOfInternal(arrayList);
    }

    private static <E> ImmutableSet<E> copyOfInternal(Collection<? extends E> collection) {
        switch (collection.size()) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                return ImmutableSet.of(collection.iterator().next());
            }
        }
        return ImmutableSet.create(collection, collection.size());
    }

    ImmutableSet() {
    }

    boolean isHashCodeFast() {
        return false;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableSet && this.isHashCodeFast() && ((ImmutableSet)object).isHashCodeFast() && this.hashCode() != object.hashCode()) {
            return false;
        }
        return Collections2.setEquals(this, object);
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (Object e : this) {
            n += e.hashCode();
        }
        return n;
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    private static <E> ImmutableSet<E> create(E ... EArray) {
        return ImmutableSet.create(Arrays.asList(EArray), EArray.length);
    }

    private static <E> ImmutableSet<E> create(Iterable<? extends E> iterable, int n) {
        int n2 = Hashing.chooseTableSize(n);
        Object[] objectArray = new Object[n2];
        int n3 = n2 - 1;
        ArrayList<E> arrayList = new ArrayList<E>(n);
        int n4 = 0;
        block0: for (E e : iterable) {
            Preconditions.checkNotNull(e);
            int n5 = e.hashCode();
            int n6 = Hashing.smear(n5);
            while (true) {
                int n7;
                Object object;
                if ((object = objectArray[n7 = n6 & n3]) == null) {
                    objectArray[n7] = e;
                    arrayList.add(e);
                    n4 += n5;
                    continue block0;
                }
                if (object.equals(e)) continue block0;
                ++n6;
            }
        }
        if (arrayList.size() == 1) {
            return new SingletonImmutableSet(arrayList.get(0), n4);
        }
        if (n2 > Hashing.chooseTableSize(arrayList.size())) {
            return ImmutableSet.create(arrayList, arrayList.size());
        }
        return new RegularImmutableSet(arrayList.toArray(), n4, objectArray, n3);
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this.toArray());
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<E>
    extends ImmutableCollection.Builder<E> {
        final ArrayList<E> contents = Lists.newArrayList();

        @Override
        public Builder<E> add(E e) {
            this.contents.add(Preconditions.checkNotNull(e));
            return this;
        }

        @Override
        public Builder<E> add(E ... EArray) {
            Preconditions.checkNotNull(EArray);
            this.contents.ensureCapacity(this.contents.size() + EArray.length);
            super.add(EArray);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterable<? extends E> iterable) {
            if (iterable instanceof Collection) {
                Collection collection = (Collection)iterable;
                this.contents.ensureCapacity(this.contents.size() + collection.size());
            }
            super.addAll(iterable);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterator<? extends E> iterator) {
            super.addAll(iterator);
            return this;
        }

        @Override
        public ImmutableSet<E> build() {
            return ImmutableSet.copyOf(this.contents);
        }
    }

    private static class SerializedForm
    implements Serializable {
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        SerializedForm(Object[] objectArray) {
            this.elements = objectArray;
        }

        Object readResolve() {
            return ImmutableSet.of(this.elements);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class TransformedImmutableSet<D, E>
    extends ImmutableSet<E> {
        final D[] source;
        final int hashCode;

        TransformedImmutableSet(D[] DArray, int n) {
            this.source = DArray;
            this.hashCode = n;
        }

        abstract E transform(D var1);

        @Override
        public int size() {
            return this.source.length;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public UnmodifiableIterator<E> iterator() {
            return new AbstractIterator<E>(){
                int index = 0;

                @Override
                protected E computeNext() {
                    return this.index < TransformedImmutableSet.this.source.length ? TransformedImmutableSet.this.transform(TransformedImmutableSet.this.source[this.index++]) : this.endOfData();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.size()]);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            int n = this.size();
            if (TArray.length < n) {
                TArray = ObjectArrays.newArray(TArray, n);
            } else if (TArray.length > n) {
                TArray[n] = null;
            }
            T[] TArray2 = TArray;
            for (int i = 0; i < this.source.length; ++i) {
                TArray2[i] = this.transform(this.source[i]);
            }
            return TArray;
        }

        @Override
        public final int hashCode() {
            return this.hashCode;
        }

        @Override
        boolean isHashCodeFast() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ArrayImmutableSet<E>
    extends ImmutableSet<E> {
        final transient Object[] elements;

        ArrayImmutableSet(Object[] objectArray) {
            this.elements = objectArray;
        }

        @Override
        public int size() {
            return this.elements.length;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public UnmodifiableIterator<E> iterator() {
            return Iterators.forArray(this.elements);
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            Platform.unsafeArrayCopy(this.elements, 0, objectArray, 0, this.size());
            return objectArray;
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            int n = this.size();
            if (TArray.length < n) {
                TArray = ObjectArrays.newArray(TArray, n);
            } else if (TArray.length > n) {
                TArray[n] = null;
            }
            Platform.unsafeArrayCopy(this.elements, 0, TArray, 0, n);
            return TArray;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            if (collection == this) {
                return true;
            }
            if (!(collection instanceof ArrayImmutableSet)) {
                return super.containsAll(collection);
            }
            if (collection.size() > this.size()) {
                return false;
            }
            for (Object object : ((ArrayImmutableSet)collection).elements) {
                if (this.contains(object)) continue;
                return false;
            }
            return true;
        }

        @Override
        ImmutableList<E> createAsList() {
            return new ImmutableAsList(this.elements, this);
        }
    }
}

