/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableAsList;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.RegularImmutableList;
import com.google.common.collect.RegularImmutableSortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableSortedAsList<E>
extends RegularImmutableList<E> {
    private final transient ImmutableSortedSet<E> set;

    ImmutableSortedAsList(Object[] objectArray, int n, int n2, ImmutableSortedSet<E> immutableSortedSet) {
        super(objectArray, n, n2);
        this.set = immutableSortedSet;
    }

    @Override
    public boolean contains(Object object) {
        return this.set.indexOf(object) >= 0;
    }

    @Override
    public int indexOf(Object object) {
        return this.set.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.set.indexOf(object);
    }

    @Override
    public ImmutableList<E> subList(int n, int n2) {
        Preconditions.checkPositionIndexes(n, n2, this.size());
        return n == n2 ? ImmutableList.of() : new RegularImmutableSortedSet<E>(this.array(), this.set.comparator(), this.offset() + n, this.offset() + n2).asList();
    }

    @Override
    Object writeReplace() {
        return new ImmutableAsList.SerializedForm(this.set);
    }
}

