/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMapFauxverideShim;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.RegularImmutableSortedSet;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true)
public class ImmutableSortedMap<K, V>
extends ImmutableSortedMapFauxverideShim<K, V>
implements SortedMap<K, V> {
    private static final Comparator NATURAL_ORDER = Ordering.natural();
    private static final Map.Entry<?, ?>[] EMPTY_ARRAY = new Map.Entry[0];
    private static final ImmutableMap<Object, Object> NATURAL_EMPTY_MAP = new ImmutableSortedMap<Object, Object>(EMPTY_ARRAY, NATURAL_ORDER);
    private final transient Map.Entry<K, V>[] entries;
    private final transient Comparator<? super K> comparator;
    private final transient int fromIndex;
    private final transient int toIndex;
    private transient ImmutableSet<Map.Entry<K, V>> entrySet;
    private transient ImmutableSortedSet<K> keySet;
    private transient ImmutableCollection<V> values;
    private static final long serialVersionUID = 0L;

    public static <K, V> ImmutableSortedMap<K, V> of() {
        return (ImmutableSortedMap)NATURAL_EMPTY_MAP;
    }

    private static <K, V> ImmutableSortedMap<K, V> emptyMap(Comparator<? super K> comparator) {
        if (((Object)NATURAL_ORDER).equals(comparator)) {
            return ImmutableSortedMap.of();
        }
        return new ImmutableSortedMap<K, V>(EMPTY_ARRAY, comparator);
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k, V v) {
        Map.Entry[] entryArray = new Map.Entry[]{ImmutableSortedMap.entryOf(k, v)};
        return new ImmutableSortedMap(entryArray, Ordering.natural());
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2) {
        return ((Builder)((Builder)new Builder(Ordering.natural()).put((Object)k, (Object)v)).put((Object)k2, (Object)v2)).build();
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3) {
        return ((Builder)((Builder)((Builder)new Builder(Ordering.natural()).put((Object)k, (Object)v)).put((Object)k2, (Object)v2)).put((Object)k3, (Object)v3)).build();
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4) {
        return ((Builder)((Builder)((Builder)((Builder)new Builder(Ordering.natural()).put((Object)k, (Object)v)).put((Object)k2, (Object)v2)).put((Object)k3, (Object)v3)).put((Object)k4, (Object)v4)).build();
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return ((Builder)((Builder)((Builder)((Builder)((Builder)new Builder(Ordering.natural()).put((Object)k, (Object)v)).put((Object)k2, (Object)v2)).put((Object)k3, (Object)v3)).put((Object)k4, (Object)v4)).put((Object)k5, (Object)v5)).build();
    }

    public static <K, V> ImmutableSortedMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        Ordering ordering = Ordering.natural();
        return ImmutableSortedMap.copyOfInternal(map, ordering);
    }

    public static <K, V> ImmutableSortedMap<K, V> copyOf(Map<? extends K, ? extends V> map, Comparator<? super K> comparator) {
        return ImmutableSortedMap.copyOfInternal(map, Preconditions.checkNotNull(comparator));
    }

    public static <K, V> ImmutableSortedMap<K, V> copyOfSorted(SortedMap<K, ? extends V> sortedMap) {
        Comparator<K> comparator = sortedMap.comparator() == null ? NATURAL_ORDER : sortedMap.comparator();
        return ImmutableSortedMap.copyOfInternal(sortedMap, comparator);
    }

    private static <K, V> ImmutableSortedMap<K, V> copyOfInternal(Map<? extends K, ? extends V> map, Comparator<? super K> comparator) {
        Object object;
        Object object2;
        boolean bl = false;
        if (map instanceof SortedMap) {
            object2 = (SortedMap)map;
            object = object2.comparator();
            boolean bl2 = object == null ? comparator == NATURAL_ORDER : (bl = ((Object)comparator).equals(object));
        }
        if (bl && map instanceof ImmutableSortedMap) {
            object2 = (ImmutableSortedMap)map;
            return object2;
        }
        object2 = Lists.newArrayListWithCapacity(map.size());
        for (Map.Entry entry : map.entrySet()) {
            object2.add(ImmutableSortedMap.entryOf(entry.getKey(), entry.getValue()));
        }
        object = object2.toArray(new Map.Entry[object2.size()]);
        if (!bl) {
            ImmutableSortedMap.sortEntries(object, comparator);
            ImmutableSortedMap.validateEntries(object, comparator);
        }
        return new ImmutableSortedMap<K, V>((Map.Entry<?, ?>[])object, comparator);
    }

    private static void sortEntries(Map.Entry<?, ?>[] entryArray, final Comparator<?> comparator) {
        Comparator comparator2 = new Comparator<Map.Entry<?, ?>>(){

            @Override
            public int compare(Map.Entry<?, ?> entry, Map.Entry<?, ?> entry2) {
                return ImmutableSortedSet.unsafeCompare(comparator, entry.getKey(), entry2.getKey());
            }
        };
        Arrays.sort(entryArray, comparator2);
    }

    private static void validateEntries(Map.Entry<?, ?>[] entryArray, Comparator<?> comparator) {
        for (int i = 1; i < entryArray.length; ++i) {
            if (ImmutableSortedSet.unsafeCompare(comparator, entryArray[i - 1].getKey(), entryArray[i].getKey()) != 0) continue;
            throw new IllegalArgumentException("Duplicate keys in mappings " + entryArray[i - 1] + " and " + entryArray[i]);
        }
    }

    public static <K extends Comparable<K>, V> Builder<K, V> naturalOrder() {
        return new Builder(Ordering.natural());
    }

    public static <K, V> Builder<K, V> orderedBy(Comparator<K> comparator) {
        return new Builder(comparator);
    }

    public static <K extends Comparable<K>, V> Builder<K, V> reverseOrder() {
        return new Builder(Ordering.natural().reverse());
    }

    private ImmutableSortedMap(Map.Entry<?, ?>[] entryArray, Comparator<? super K> comparator, int n, int n2) {
        Map.Entry<?, ?>[] entryArray2 = entryArray;
        this.entries = entryArray2;
        this.comparator = comparator;
        this.fromIndex = n;
        this.toIndex = n2;
    }

    ImmutableSortedMap(Map.Entry<?, ?>[] entryArray, Comparator<? super K> comparator) {
        this(entryArray, comparator, 0, entryArray.length);
    }

    @Override
    public int size() {
        return this.toIndex - this.fromIndex;
    }

    @Override
    public V get(@Nullable Object object) {
        int n;
        if (object == null) {
            return null;
        }
        try {
            n = this.binarySearch(object);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        return n >= 0 ? (V)this.entries[n].getValue() : null;
    }

    private int binarySearch(Object object) {
        int n = this.fromIndex;
        int n2 = this.toIndex - 1;
        while (n <= n2) {
            int n3 = n + (n2 - n) / 2;
            int n4 = ImmutableSortedSet.unsafeCompare(this.comparator, object, this.entries[n3].getKey());
            if (n4 < 0) {
                n2 = n3 - 1;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            return n3;
        }
        return -n - 1;
    }

    @Override
    public boolean containsValue(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        for (int i = this.fromIndex; i < this.toIndex; ++i) {
            if (!this.entries[i].getValue().equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        ImmutableSet<Map.Entry<K, V>> immutableSet = this.entrySet;
        return immutableSet == null ? (this.entrySet = this.createEntrySet()) : immutableSet;
    }

    private ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return this.isEmpty() ? ImmutableSet.of() : new EntrySet(this);
    }

    @Override
    public ImmutableSortedSet<K> keySet() {
        ImmutableSortedSet<K> immutableSortedSet = this.keySet;
        return immutableSortedSet == null ? (this.keySet = this.createKeySet()) : immutableSortedSet;
    }

    private ImmutableSortedSet<K> createKeySet() {
        if (this.isEmpty()) {
            return ImmutableSortedSet.emptySet(this.comparator);
        }
        Object[] objectArray = new Object[this.size()];
        for (int i = this.fromIndex; i < this.toIndex; ++i) {
            objectArray[i - this.fromIndex] = this.entries[i].getKey();
        }
        return new RegularImmutableSortedSet<K>(objectArray, this.comparator);
    }

    @Override
    public ImmutableCollection<V> values() {
        ImmutableCollection<V> immutableCollection = this.values;
        return immutableCollection == null ? (this.values = new Values(this)) : immutableCollection;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public K firstKey() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.entries[this.fromIndex].getKey();
    }

    @Override
    public K lastKey() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.entries[this.toIndex - 1].getKey();
    }

    @Override
    public ImmutableSortedMap<K, V> headMap(K k) {
        int n = this.findSubmapIndex(Preconditions.checkNotNull(k));
        return this.createSubmap(this.fromIndex, n);
    }

    @Override
    public ImmutableSortedMap<K, V> subMap(K k, K k2) {
        Preconditions.checkNotNull(k);
        Preconditions.checkNotNull(k2);
        Preconditions.checkArgument(this.comparator.compare(k, k2) <= 0);
        int n = this.findSubmapIndex(k);
        int n2 = this.findSubmapIndex(k2);
        return this.createSubmap(n, n2);
    }

    @Override
    public ImmutableSortedMap<K, V> tailMap(K k) {
        int n = this.findSubmapIndex(Preconditions.checkNotNull(k));
        return this.createSubmap(n, this.toIndex);
    }

    private int findSubmapIndex(K k) {
        int n = this.binarySearch(k);
        return n >= 0 ? n : -n - 1;
    }

    private ImmutableSortedMap<K, V> createSubmap(int n, int n2) {
        if (n < n2) {
            return new ImmutableSortedMap<K, V>(this.entries, this.comparator, n, n2);
        }
        return ImmutableSortedMap.emptyMap(this.comparator);
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializedForm
    extends ImmutableMap.SerializedForm {
        private final Comparator<Object> comparator;
        private static final long serialVersionUID = 0L;

        SerializedForm(ImmutableSortedMap<?, ?> immutableSortedMap) {
            super(immutableSortedMap);
            this.comparator = immutableSortedMap.comparator();
        }

        @Override
        Object readResolve() {
            Builder<Object, Object> builder = new Builder<Object, Object>(this.comparator);
            return this.createMap(builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValuesSerializedForm<V>
    implements Serializable {
        final ImmutableSortedMap<?, V> map;
        private static final long serialVersionUID = 0L;

        ValuesSerializedForm(ImmutableSortedMap<?, V> immutableSortedMap) {
            this.map = immutableSortedMap;
        }

        Object readResolve() {
            return this.map.values();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Values<V>
    extends ImmutableCollection<V> {
        private final ImmutableSortedMap<?, V> map;

        Values(ImmutableSortedMap<?, V> immutableSortedMap) {
            this.map = immutableSortedMap;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public UnmodifiableIterator<V> iterator() {
            return new AbstractIterator<V>(){
                int index;
                {
                    this.index = Values.this.map.fromIndex;
                }

                @Override
                protected V computeNext() {
                    return this.index < Values.this.map.toIndex ? Values.this.map.entries[this.index++].getValue() : this.endOfData();
                }
            };
        }

        @Override
        public boolean contains(Object object) {
            return this.map.containsValue(object);
        }

        @Override
        Object writeReplace() {
            return new ValuesSerializedForm<V>(this.map);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntrySetSerializedForm<K, V>
    implements Serializable {
        final ImmutableSortedMap<K, V> map;
        private static final long serialVersionUID = 0L;

        EntrySetSerializedForm(ImmutableSortedMap<K, V> immutableSortedMap) {
            this.map = immutableSortedMap;
        }

        Object readResolve() {
            return this.map.entrySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntrySet<K, V>
    extends ImmutableSet<Map.Entry<K, V>> {
        final transient ImmutableSortedMap<K, V> map;

        EntrySet(ImmutableSortedMap<K, V> immutableSortedMap) {
            this.map = immutableSortedMap;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return Iterators.forArray(((ImmutableSortedMap)this.map).entries, ((ImmutableSortedMap)this.map).fromIndex, this.size());
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                V v = this.map.get(entry.getKey());
                return v != null && v.equals(entry.getValue());
            }
            return false;
        }

        @Override
        Object writeReplace() {
            return new EntrySetSerializedForm<K, V>(this.map);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder<K, V>
    extends ImmutableMap.Builder<K, V> {
        private final Comparator<? super K> comparator;

        public Builder(Comparator<? super K> comparator) {
            this.comparator = Preconditions.checkNotNull(comparator);
        }

        @Override
        public Builder<K, V> put(K k, V v) {
            this.entries.add(ImmutableMap.entryOf(k, v));
            return this;
        }

        @Override
        public Builder<K, V> putAll(Map<? extends K, ? extends V> map) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            return this;
        }

        @Override
        public ImmutableSortedMap<K, V> build() {
            Map.Entry[] entryArray = this.entries.toArray(new Map.Entry[this.entries.size()]);
            ImmutableSortedMap.sortEntries(entryArray, this.comparator);
            ImmutableSortedMap.validateEntries(entryArray, this.comparator);
            return new ImmutableSortedMap(entryArray, this.comparator);
        }
    }
}

