/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.EmptyImmutableSortedSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSetFauxverideShim;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Platform;
import com.google.common.collect.RegularImmutableSortedSet;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true)
public abstract class ImmutableSortedSet<E>
extends ImmutableSortedSetFauxverideShim<E>
implements SortedSet<E> {
    private static final Comparator NATURAL_ORDER = Ordering.natural();
    private static final ImmutableSortedSet<Object> NATURAL_EMPTY_SET = new EmptyImmutableSortedSet<Object>(NATURAL_ORDER);
    final transient Comparator<? super E> comparator;

    private static <E> ImmutableSortedSet<E> emptySet() {
        return NATURAL_EMPTY_SET;
    }

    static <E> ImmutableSortedSet<E> emptySet(Comparator<? super E> comparator) {
        if (((Object)NATURAL_ORDER).equals(comparator)) {
            return ImmutableSortedSet.emptySet();
        }
        return new EmptyImmutableSortedSet<E>(comparator);
    }

    public static <E> ImmutableSortedSet<E> of() {
        return ImmutableSortedSet.emptySet();
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e) {
        Object[] objectArray = new Object[]{Preconditions.checkNotNull(e)};
        return new RegularImmutableSortedSet(objectArray, Ordering.natural());
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e, E e2) {
        return ImmutableSortedSet.ofInternal(Ordering.natural(), e, e2);
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e, E e2, E e3) {
        return ImmutableSortedSet.ofInternal(Ordering.natural(), e, e2, e3);
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e, E e2, E e3, E e4) {
        return ImmutableSortedSet.ofInternal(Ordering.natural(), e, e2, e3, e4);
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e, E e2, E e3, E e4, E e5) {
        return ImmutableSortedSet.ofInternal(Ordering.natural(), e, e2, e3, e4, e5);
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E ... EArray) {
        return ImmutableSortedSet.ofInternal(Ordering.natural(), EArray);
    }

    private static <E> ImmutableSortedSet<E> ofInternal(Comparator<? super E> comparator, E ... EArray) {
        Preconditions.checkNotNull(EArray);
        switch (EArray.length) {
            case 0: {
                return ImmutableSortedSet.emptySet(comparator);
            }
        }
        Object[] objectArray = new Object[EArray.length];
        for (int i = 0; i < EArray.length; ++i) {
            objectArray[i] = Preconditions.checkNotNull(EArray[i]);
        }
        ImmutableSortedSet.sort(objectArray, comparator);
        objectArray = ImmutableSortedSet.removeDupes(objectArray, comparator);
        return new RegularImmutableSortedSet<E>(objectArray, comparator);
    }

    private static <E> void sort(Object[] objectArray, Comparator<? super E> comparator) {
        Arrays.sort(objectArray, comparator);
    }

    private static <E> Object[] removeDupes(Object[] objectArray, Comparator<? super E> comparator) {
        int n = 1;
        for (int i = 1; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (ImmutableSortedSet.unsafeCompare(comparator, objectArray[n - 1], object) == 0) continue;
            objectArray[n] = object;
            ++n;
        }
        if (n == objectArray.length) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[n];
        Platform.unsafeArrayCopy(objectArray, 0, objectArray2, 0, n);
        return objectArray2;
    }

    public static <E> ImmutableSortedSet<E> copyOf(Iterable<? extends E> iterable) {
        Ordering ordering = Ordering.natural();
        return ImmutableSortedSet.copyOfInternal(ordering, iterable, false);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Iterator<? extends E> iterator) {
        Ordering ordering = Ordering.natural();
        return ImmutableSortedSet.copyOfInternal(ordering, iterator);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Iterable<? extends E> iterable) {
        Preconditions.checkNotNull(comparator);
        return ImmutableSortedSet.copyOfInternal(comparator, iterable, false);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Iterator<? extends E> iterator) {
        Preconditions.checkNotNull(comparator);
        return ImmutableSortedSet.copyOfInternal(comparator, iterator);
    }

    public static <E> ImmutableSortedSet<E> copyOfSorted(SortedSet<E> sortedSet) {
        Comparator comparator = sortedSet.comparator();
        if (comparator == null) {
            comparator = NATURAL_ORDER;
        }
        return ImmutableSortedSet.copyOfInternal(comparator, sortedSet, true);
    }

    private static <E> ImmutableSortedSet<E> copyOfInternal(Comparator<? super E> comparator, Iterable<? extends E> iterable, boolean bl) {
        Object object;
        boolean bl2;
        boolean bl3 = bl2 = bl || ImmutableSortedSet.hasSameComparator(iterable, comparator);
        if (bl2 && iterable instanceof ImmutableSortedSet && !((ImmutableSortedSet)(object = (ImmutableSortedSet)iterable)).hasPartialArray()) {
            return object;
        }
        object = ImmutableSortedSet.newObjectArray(iterable);
        if (((Object[])object).length == 0) {
            return ImmutableSortedSet.emptySet(comparator);
        }
        for (Object object2 : object) {
            Preconditions.checkNotNull(object2);
        }
        if (!bl2) {
            ImmutableSortedSet.sort((Object[])object, comparator);
            object = ImmutableSortedSet.removeDupes((Object[])object, comparator);
        }
        return new RegularImmutableSortedSet<E>((Object[])object, comparator);
    }

    private static <T> Object[] newObjectArray(Iterable<T> iterable) {
        ArrayList<Object> arrayList = iterable instanceof Collection ? (ArrayList<Object>)iterable : Lists.newArrayList(iterable);
        Object[] objectArray = new Object[arrayList.size()];
        return arrayList.toArray(objectArray);
    }

    private static <E> ImmutableSortedSet<E> copyOfInternal(Comparator<? super E> comparator, Iterator<? extends E> iterator) {
        if (!iterator.hasNext()) {
            return ImmutableSortedSet.emptySet(comparator);
        }
        ArrayList<E> arrayList = Lists.newArrayList();
        while (iterator.hasNext()) {
            arrayList.add(Preconditions.checkNotNull(iterator.next()));
        }
        Object[] objectArray = arrayList.toArray();
        ImmutableSortedSet.sort(objectArray, comparator);
        objectArray = ImmutableSortedSet.removeDupes(objectArray, comparator);
        return new RegularImmutableSortedSet<E>(objectArray, comparator);
    }

    static boolean hasSameComparator(Iterable<?> iterable, Comparator<?> comparator) {
        if (iterable instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)iterable;
            Comparator comparator2 = sortedSet.comparator();
            return comparator2 == null ? comparator == Ordering.natural() : ((Object)comparator).equals(comparator2);
        }
        return false;
    }

    public static <E> Builder<E> orderedBy(Comparator<E> comparator) {
        return new Builder<E>(comparator);
    }

    public static <E extends Comparable<E>> Builder<E> reverseOrder() {
        return new Builder(Ordering.natural().reverse());
    }

    public static <E extends Comparable<E>> Builder<E> naturalOrder() {
        return new Builder(Ordering.natural());
    }

    int unsafeCompare(Object object, Object object2) {
        return ImmutableSortedSet.unsafeCompare(this.comparator, object, object2);
    }

    static int unsafeCompare(Comparator<?> comparator, Object object, Object object2) {
        Comparator<?> comparator2 = comparator;
        return comparator2.compare(object, object2);
    }

    ImmutableSortedSet(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public ImmutableSortedSet<E> headSet(E e) {
        return this.headSetImpl(Preconditions.checkNotNull(e));
    }

    @Override
    public ImmutableSortedSet<E> subSet(E e, E e2) {
        Preconditions.checkNotNull(e);
        Preconditions.checkNotNull(e2);
        Preconditions.checkArgument(this.comparator.compare(e, e2) <= 0);
        return this.subSetImpl(e, e2);
    }

    @Override
    public ImmutableSortedSet<E> tailSet(E e) {
        return this.tailSetImpl(Preconditions.checkNotNull(e));
    }

    abstract ImmutableSortedSet<E> headSetImpl(E var1);

    abstract ImmutableSortedSet<E> subSetImpl(E var1, E var2);

    abstract ImmutableSortedSet<E> tailSetImpl(E var1);

    abstract boolean hasPartialArray();

    abstract int indexOf(Object var1);

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    @Override
    Object writeReplace() {
        return new SerializedForm<E>(this.comparator, this.toArray());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializedForm<E>
    implements Serializable {
        final Comparator<? super E> comparator;
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        public SerializedForm(Comparator<? super E> comparator, Object[] objectArray) {
            this.comparator = comparator;
            this.elements = objectArray;
        }

        Object readResolve() {
            return ((Builder)new Builder<E>(this.comparator).add(this.elements)).build();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder<E>
    extends ImmutableSet.Builder<E> {
        private final Comparator<? super E> comparator;

        public Builder(Comparator<? super E> comparator) {
            this.comparator = Preconditions.checkNotNull(comparator);
        }

        @Override
        public Builder<E> add(E e) {
            super.add((Object)e);
            return this;
        }

        @Override
        public Builder<E> add(E ... EArray) {
            super.add((Object[])EArray);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterable<? extends E> iterable) {
            super.addAll((Iterable)iterable);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterator<? extends E> iterator) {
            super.addAll((Iterator)iterator);
            return this;
        }

        @Override
        public ImmutableSortedSet<E> build() {
            return ImmutableSortedSet.copyOfInternal(this.comparator, this.contents.iterator());
        }
    }
}

