/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractSetMultimap;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Serialization;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true)
public final class LinkedHashMultimap<K, V>
extends AbstractSetMultimap<K, V> {
    private static final int DEFAULT_VALUES_PER_KEY = 8;
    @VisibleForTesting
    transient int expectedValuesPerKey = 8;
    transient Collection<Map.Entry<K, V>> linkedEntries;
    private static final long serialVersionUID = 0L;

    public static <K, V> LinkedHashMultimap<K, V> create() {
        return new LinkedHashMultimap<K, V>();
    }

    public static <K, V> LinkedHashMultimap<K, V> create(int n, int n2) {
        return new LinkedHashMultimap<K, V>(n, n2);
    }

    public static <K, V> LinkedHashMultimap<K, V> create(Multimap<? extends K, ? extends V> multimap) {
        return new LinkedHashMultimap<K, V>(multimap);
    }

    private LinkedHashMultimap() {
        super(new LinkedHashMap());
        this.linkedEntries = Sets.newLinkedHashSet();
    }

    private LinkedHashMultimap(int n, int n2) {
        super(new LinkedHashMap(n));
        Preconditions.checkArgument(n2 >= 0);
        this.expectedValuesPerKey = n2;
        this.linkedEntries = new LinkedHashSet<Map.Entry<K, V>>(n * n2);
    }

    private LinkedHashMultimap(Multimap<? extends K, ? extends V> multimap) {
        super(new LinkedHashMap(Maps.capacity(multimap.keySet().size())));
        this.linkedEntries = new LinkedHashSet<Map.Entry<K, V>>(Maps.capacity(multimap.size()));
        this.putAll(multimap);
    }

    @Override
    Set<V> createCollection() {
        return new LinkedHashSet(Maps.capacity(this.expectedValuesPerKey));
    }

    @Override
    Collection<V> createCollection(@Nullable K k) {
        return new SetDecorator(k, this.createCollection());
    }

    @Override
    Iterator<Map.Entry<K, V>> createEntryIterator() {
        final Iterator<Map.Entry<K, V>> iterator = this.linkedEntries.iterator();
        return new Iterator<Map.Entry<K, V>>(){
            Map.Entry<K, V> entry;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                this.entry = (Map.Entry)iterator.next();
                return this.entry;
            }

            @Override
            public void remove() {
                iterator.remove();
                LinkedHashMultimap.this.remove(this.entry.getKey(), this.entry.getValue());
            }
        };
    }

    @Override
    public Set<V> replaceValues(@Nullable K k, Iterable<? extends V> iterable) {
        return super.replaceValues((Object)k, (Iterable)iterable);
    }

    @Override
    public Set<Map.Entry<K, V>> entries() {
        return super.entries();
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.expectedValuesPerKey);
        Serialization.writeMultimap(this, objectOutputStream);
        for (Map.Entry<K, V> entry : this.linkedEntries) {
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.expectedValuesPerKey = objectInputStream.readInt();
        int n = Serialization.readCount(objectInputStream);
        this.setMap(new LinkedHashMap(Maps.capacity(n)));
        this.linkedEntries = new LinkedHashSet<Map.Entry<K, V>>(n * this.expectedValuesPerKey);
        Serialization.populateMultimap(this, objectInputStream, n);
        this.linkedEntries.clear();
        for (int i = 0; i < this.size(); ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.linkedEntries.add(Maps.immutableEntry(object, object2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetDecorator
    extends ForwardingSet<V> {
        final Set<V> delegate;
        final K key;

        SetDecorator(K k, Set<V> set) {
            this.delegate = set;
            this.key = k;
        }

        @Override
        protected Set<V> delegate() {
            return this.delegate;
        }

        <E> Map.Entry<K, E> createEntry(@Nullable E e) {
            return Maps.immutableEntry(this.key, e);
        }

        <E> Collection<Map.Entry<K, E>> createEntries(Collection<E> collection) {
            ArrayList arrayList = Lists.newArrayListWithExpectedSize(collection.size());
            for (E e : collection) {
                arrayList.add(this.createEntry(e));
            }
            return arrayList;
        }

        @Override
        public boolean add(@Nullable V v) {
            boolean bl = this.delegate.add(v);
            if (bl) {
                LinkedHashMultimap.this.linkedEntries.add(this.createEntry(v));
            }
            return bl;
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            boolean bl = this.delegate.addAll(collection);
            if (bl) {
                LinkedHashMultimap.this.linkedEntries.addAll(this.createEntries(this.delegate()));
            }
            return bl;
        }

        @Override
        public void clear() {
            LinkedHashMultimap.this.linkedEntries.removeAll(this.createEntries(this.delegate()));
            this.delegate.clear();
        }

        @Override
        public Iterator<V> iterator() {
            final Iterator iterator = this.delegate.iterator();
            return new Iterator<V>(){
                V value;

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public V next() {
                    this.value = iterator.next();
                    return this.value;
                }

                @Override
                public void remove() {
                    iterator.remove();
                    LinkedHashMultimap.this.linkedEntries.remove(SetDecorator.this.createEntry(this.value));
                }
            };
        }

        @Override
        public boolean remove(@Nullable Object object) {
            boolean bl = this.delegate.remove(object);
            if (bl) {
                LinkedHashMultimap.this.linkedEntries.remove(this.createEntry(object));
            }
            return bl;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean bl = this.delegate.removeAll(collection);
            if (bl) {
                LinkedHashMultimap.this.linkedEntries.removeAll(this.createEntries(collection));
            }
            return bl;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean bl = false;
            Iterator iterator = this.delegate.iterator();
            while (iterator.hasNext()) {
                Object v = iterator.next();
                if (collection.contains(v)) continue;
                iterator.remove();
                LinkedHashMultimap.this.linkedEntries.remove(Maps.immutableEntry(this.key, v));
                bl = true;
            }
            return bl;
        }
    }
}

