/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.base.FinalizableSoftReference;
import com.google.common.base.FinalizableWeakReference;
import com.google.common.base.Function;
import com.google.common.collect.AsynchronousComputationException;
import com.google.common.collect.ComputationException;
import com.google.common.collect.CustomConcurrentHashMap;
import com.google.common.collect.ExpirationTimer;
import com.google.common.collect.NullOutputException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public final class MapMaker {
    private Strength keyStrength = Strength.STRONG;
    private Strength valueStrength = Strength.STRONG;
    private long expirationNanos = 0L;
    private boolean useCustomMap;
    private final CustomConcurrentHashMap.Builder builder = new CustomConcurrentHashMap.Builder();
    private static final ValueReference<Object, Object> COMPUTING = new ValueReference<Object, Object>(){

        @Override
        public Object get() {
            return null;
        }

        @Override
        public ValueReference<Object, Object> copyFor(ReferenceEntry<Object, Object> referenceEntry) {
            throw new AssertionError();
        }

        @Override
        public Object waitForValue() {
            throw new AssertionError();
        }
    };

    public MapMaker initialCapacity(int n) {
        this.builder.initialCapacity(n);
        return this;
    }

    @GwtIncompatible(value="java.util.concurrent.ConcurrentHashMap concurrencyLevel")
    public MapMaker concurrencyLevel(int n) {
        this.builder.concurrencyLevel(n);
        return this;
    }

    @GwtIncompatible(value="java.lang.ref.WeakReference")
    public MapMaker weakKeys() {
        return this.setKeyStrength(Strength.WEAK);
    }

    @GwtIncompatible(value="java.lang.ref.SoftReference")
    public MapMaker softKeys() {
        return this.setKeyStrength(Strength.SOFT);
    }

    private MapMaker setKeyStrength(Strength strength) {
        if (this.keyStrength != Strength.STRONG) {
            throw new IllegalStateException("Key strength was already set to " + (Object)((Object)this.keyStrength) + ".");
        }
        this.keyStrength = strength;
        this.useCustomMap = true;
        return this;
    }

    @GwtIncompatible(value="java.lang.ref.WeakReference")
    public MapMaker weakValues() {
        return this.setValueStrength(Strength.WEAK);
    }

    @GwtIncompatible(value="java.lang.ref.SoftReference")
    public MapMaker softValues() {
        return this.setValueStrength(Strength.SOFT);
    }

    private MapMaker setValueStrength(Strength strength) {
        if (this.valueStrength != Strength.STRONG) {
            throw new IllegalStateException("Value strength was already set to " + (Object)((Object)this.valueStrength) + ".");
        }
        this.valueStrength = strength;
        this.useCustomMap = true;
        return this;
    }

    public MapMaker expiration(long l, TimeUnit timeUnit) {
        if (this.expirationNanos != 0L) {
            throw new IllegalStateException("expiration time of " + this.expirationNanos + " ns was already set");
        }
        if (l <= 0L) {
            throw new IllegalArgumentException("invalid duration: " + l);
        }
        this.expirationNanos = timeUnit.toNanos(l);
        this.useCustomMap = true;
        return this;
    }

    public <K, V> ConcurrentMap<K, V> makeMap() {
        return this.useCustomMap ? new StrategyImpl<K, V>((MapMaker)this).map : new ConcurrentHashMap(this.builder.getInitialCapacity(), 0.75f, this.builder.getConcurrencyLevel());
    }

    public <K, V> ConcurrentMap<K, V> makeComputingMap(Function<? super K, ? extends V> function) {
        return new StrategyImpl<K, V>((MapMaker)this, function).map;
    }

    private static <K, V> ValueReference<K, V> computing() {
        return COMPUTING;
    }

    static /* synthetic */ ValueReference access$600() {
        return MapMaker.computing();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrongValueReference<K, V>
    implements ValueReference<K, V> {
        final V referent;

        StrongValueReference(V v) {
            this.referent = v;
        }

        @Override
        public V get() {
            return this.referent;
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceEntry<K, V> referenceEntry) {
            return this;
        }

        @Override
        public V waitForValue() {
            return this.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftValueReference<K, V>
    extends FinalizableSoftReference<V>
    implements ValueReference<K, V> {
        final ReferenceEntry<K, V> entry;

        SoftValueReference(V v, ReferenceEntry<K, V> referenceEntry) {
            super(v, QueueHolder.queue);
            this.entry = referenceEntry;
        }

        @Override
        public void finalizeReferent() {
            this.entry.valueReclaimed();
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceEntry<K, V> referenceEntry) {
            return new SoftValueReference(this.get(), referenceEntry);
        }

        @Override
        public V waitForValue() {
            return (V)this.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakValueReference<K, V>
    extends FinalizableWeakReference<V>
    implements ValueReference<K, V> {
        final ReferenceEntry<K, V> entry;

        WeakValueReference(V v, ReferenceEntry<K, V> referenceEntry) {
            super(v, QueueHolder.queue);
            this.entry = referenceEntry;
        }

        @Override
        public void finalizeReferent() {
            this.entry.valueReclaimed();
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceEntry<K, V> referenceEntry) {
            return new WeakValueReference(this.get(), referenceEntry);
        }

        @Override
        public V waitForValue() {
            return (V)this.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LinkedWeakEntry<K, V>
    extends WeakEntry<K, V> {
        final ReferenceEntry<K, V> next;

        LinkedWeakEntry(CustomConcurrentHashMap.Internals<K, V, ReferenceEntry<K, V>> internals, K k, int n, ReferenceEntry<K, V> referenceEntry) {
            super(internals, k, n);
            this.next = referenceEntry;
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakEntry<K, V>
    extends FinalizableWeakReference<K>
    implements ReferenceEntry<K, V> {
        final CustomConcurrentHashMap.Internals<K, V, ReferenceEntry<K, V>> internals;
        final int hash;
        volatile ValueReference<K, V> valueReference = MapMaker.access$600();

        WeakEntry(CustomConcurrentHashMap.Internals<K, V, ReferenceEntry<K, V>> internals, K k, int n) {
            super(k, QueueHolder.queue);
            this.internals = internals;
            this.hash = n;
        }

        @Override
        public K getKey() {
            return (K)this.get();
        }

        @Override
        public void finalizeReferent() {
            this.internals.removeEntry(this);
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            this.valueReference = valueReference;
        }

        @Override
        public void valueReclaimed() {
            this.internals.removeEntry(this, null);
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return null;
        }

        @Override
        public int getHash() {
            return this.hash;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LinkedSoftEntry<K, V>
    extends SoftEntry<K, V> {
        final ReferenceEntry<K, V> next;

        LinkedSoftEntry(CustomConcurrentHashMap.Internals<K, V, ReferenceEntry<K, V>> internals, K k, int n, ReferenceEntry<K, V> referenceEntry) {
            super(internals, k, n);
            this.next = referenceEntry;
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftEntry<K, V>
    extends FinalizableSoftReference<K>
    implements ReferenceEntry<K, V> {
        final CustomConcurrentHashMap.Internals<K, V, ReferenceEntry<K, V>> internals;
        final int hash;
        volatile ValueReference<K, V> valueReference = MapMaker.access$600();

        SoftEntry(CustomConcurrentHashMap.Internals<K, V, ReferenceEntry<K, V>> internals, K k, int n) {
            super(k, QueueHolder.queue);
            this.internals = internals;
            this.hash = n;
        }

        @Override
        public K getKey() {
            return (K)this.get();
        }

        @Override
        public void finalizeReferent() {
            this.internals.removeEntry(this);
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            this.valueReference = valueReference;
        }

        @Override
        public void valueReclaimed() {
            this.internals.removeEntry(this, null);
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return null;
        }

        @Override
        public int getHash() {
            return this.hash;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LinkedStrongEntry<K, V>
    extends StrongEntry<K, V> {
        final ReferenceEntry<K, V> next;

        LinkedStrongEntry(CustomConcurrentHashMap.Internals<K, V, ReferenceEntry<K, V>> internals, K k, int n, ReferenceEntry<K, V> referenceEntry) {
            super(internals, k, n);
            this.next = referenceEntry;
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrongEntry<K, V>
    implements ReferenceEntry<K, V> {
        final K key;
        final CustomConcurrentHashMap.Internals<K, V, ReferenceEntry<K, V>> internals;
        final int hash;
        volatile ValueReference<K, V> valueReference = MapMaker.access$600();

        StrongEntry(CustomConcurrentHashMap.Internals<K, V, ReferenceEntry<K, V>> internals, K k, int n) {
            this.internals = internals;
            this.key = k;
            this.hash = n;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            this.valueReference = valueReference;
        }

        @Override
        public void valueReclaimed() {
            this.internals.removeEntry(this, null);
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return null;
        }

        @Override
        public int getHash() {
            return this.hash;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ReferenceEntry<K, V> {
        public ValueReference<K, V> getValueReference();

        public void setValueReference(ValueReference<K, V> var1);

        public void valueReclaimed();

        public ReferenceEntry<K, V> getNext();

        public int getHash();

        public K getKey();
    }

    private static class QueueHolder {
        static final FinalizableReferenceQueue queue = new FinalizableReferenceQueue();

        private QueueHolder() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComputationExceptionReference<K, V>
    implements ValueReference<K, V> {
        final Throwable t;

        ComputationExceptionReference(Throwable throwable) {
            this.t = throwable;
        }

        @Override
        public V get() {
            return null;
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceEntry<K, V> referenceEntry) {
            return this;
        }

        @Override
        public V waitForValue() {
            throw new AsynchronousComputationException(this.t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullOutputExceptionReference<K, V>
    implements ValueReference<K, V> {
        final String message;

        NullOutputExceptionReference(String string) {
            this.message = string;
        }

        @Override
        public V get() {
            return null;
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceEntry<K, V> referenceEntry) {
            return this;
        }

        @Override
        public V waitForValue() {
            throw new NullOutputException(this.message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ValueReference<K, V> {
        public V get();

        public ValueReference<K, V> copyFor(ReferenceEntry<K, V> var1);

        public V waitForValue() throws InterruptedException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrategyImpl<K, V>
    implements Serializable,
    CustomConcurrentHashMap.ComputingStrategy<K, V, ReferenceEntry<K, V>> {
        final Strength keyStrength;
        final Strength valueStrength;
        final ConcurrentMap<K, V> map;
        final long expirationNanos;
        CustomConcurrentHashMap.Internals<K, V, ReferenceEntry<K, V>> internals;
        private static final long serialVersionUID = 0L;

        StrategyImpl(MapMaker mapMaker) {
            this.keyStrength = mapMaker.keyStrength;
            this.valueStrength = mapMaker.valueStrength;
            this.expirationNanos = mapMaker.expirationNanos;
            this.map = mapMaker.builder.buildMap(this);
        }

        StrategyImpl(MapMaker mapMaker, Function<? super K, ? extends V> function) {
            this.keyStrength = mapMaker.keyStrength;
            this.valueStrength = mapMaker.valueStrength;
            this.expirationNanos = mapMaker.expirationNanos;
            this.map = mapMaker.builder.buildComputingMap(this, function);
        }

        @Override
        public void setValue(ReferenceEntry<K, V> referenceEntry, V v) {
            this.setValueReference(referenceEntry, this.valueStrength.referenceValue(referenceEntry, v));
            if (this.expirationNanos > 0L) {
                this.scheduleRemoval(referenceEntry.getKey(), v);
            }
        }

        void scheduleRemoval(K k, V v) {
            final WeakReference<K> weakReference = new WeakReference<K>(k);
            final WeakReference<V> weakReference2 = new WeakReference<V>(v);
            ExpirationTimer.instance.schedule(new TimerTask(){

                public void run() {
                    Object t = weakReference.get();
                    if (t != null) {
                        StrategyImpl.this.map.remove(t, weakReference2.get());
                    }
                }
            }, TimeUnit.NANOSECONDS.toMillis(this.expirationNanos));
        }

        @Override
        public boolean equalKeys(K k, Object object) {
            return this.keyStrength.equal(k, object);
        }

        @Override
        public boolean equalValues(V v, Object object) {
            return this.valueStrength.equal(v, object);
        }

        @Override
        public int hashKey(Object object) {
            return this.keyStrength.hash(object);
        }

        @Override
        public K getKey(ReferenceEntry<K, V> referenceEntry) {
            return referenceEntry.getKey();
        }

        @Override
        public int getHash(ReferenceEntry<K, V> referenceEntry) {
            return referenceEntry.getHash();
        }

        @Override
        public ReferenceEntry<K, V> newEntry(K k, int n, ReferenceEntry<K, V> referenceEntry) {
            return this.keyStrength.newEntry(this.internals, k, n, referenceEntry);
        }

        @Override
        public ReferenceEntry<K, V> copyEntry(K k, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
            ValueReference<K, V> valueReference = referenceEntry.getValueReference();
            if (valueReference == COMPUTING) {
                ReferenceEntry<K, V> referenceEntry3 = this.newEntry(k, referenceEntry.getHash(), referenceEntry2);
                referenceEntry3.setValueReference(new FutureValueReference(referenceEntry, referenceEntry3));
                return referenceEntry3;
            }
            ReferenceEntry<K, V> referenceEntry4 = this.newEntry(k, referenceEntry.getHash(), referenceEntry2);
            referenceEntry4.setValueReference(valueReference.copyFor(referenceEntry4));
            return referenceEntry4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V waitForValue(ReferenceEntry<K, V> referenceEntry) throws InterruptedException {
            ValueReference<K, V> valueReference = referenceEntry.getValueReference();
            if (valueReference == COMPUTING) {
                ReferenceEntry<K, V> referenceEntry2 = referenceEntry;
                synchronized (referenceEntry2) {
                    while ((valueReference = referenceEntry.getValueReference()) == COMPUTING) {
                        referenceEntry.wait();
                    }
                }
            }
            return valueReference.waitForValue();
        }

        @Override
        public V getValue(ReferenceEntry<K, V> referenceEntry) {
            ValueReference<K, V> valueReference = referenceEntry.getValueReference();
            return valueReference.get();
        }

        @Override
        public V compute(K k, ReferenceEntry<K, V> referenceEntry, Function<? super K, ? extends V> function) {
            V v;
            try {
                v = function.apply(k);
            }
            catch (ComputationException computationException) {
                this.setValueReference(referenceEntry, new ComputationExceptionReference(computationException.getCause()));
                throw computationException;
            }
            catch (Throwable throwable) {
                this.setValueReference(referenceEntry, new ComputationExceptionReference(throwable));
                throw new ComputationException(throwable);
            }
            if (v == null) {
                String string = function + " returned null for key " + k + ".";
                this.setValueReference(referenceEntry, new NullOutputExceptionReference(string));
                throw new NullOutputException(string);
            }
            this.setValue(referenceEntry, v);
            return v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setValueReference(ReferenceEntry<K, V> referenceEntry, ValueReference<K, V> valueReference) {
            boolean bl = referenceEntry.getValueReference() == COMPUTING;
            referenceEntry.setValueReference(valueReference);
            if (bl) {
                ReferenceEntry<K, V> referenceEntry2 = referenceEntry;
                synchronized (referenceEntry2) {
                    referenceEntry.notifyAll();
                }
            }
        }

        @Override
        public ReferenceEntry<K, V> getNext(ReferenceEntry<K, V> referenceEntry) {
            return referenceEntry.getNext();
        }

        @Override
        public void setInternals(CustomConcurrentHashMap.Internals<K, V, ReferenceEntry<K, V>> internals) {
            this.internals = internals;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject((Object)this.keyStrength);
            objectOutputStream.writeObject((Object)this.valueStrength);
            objectOutputStream.writeLong(this.expirationNanos);
            objectOutputStream.writeObject(this.internals);
            objectOutputStream.writeObject(this.map);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            try {
                Fields.keyStrength.set(this, objectInputStream.readObject());
                Fields.valueStrength.set(this, objectInputStream.readObject());
                Fields.expirationNanos.set(this, objectInputStream.readLong());
                Fields.internals.set(this, objectInputStream.readObject());
                Fields.map.set(this, objectInputStream.readObject());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
        }

        private static class Fields {
            static final Field keyStrength = Fields.findField("keyStrength");
            static final Field valueStrength = Fields.findField("valueStrength");
            static final Field expirationNanos = Fields.findField("expirationNanos");
            static final Field internals = Fields.findField("internals");
            static final Field map = Fields.findField("map");

            private Fields() {
            }

            static Field findField(String string) {
                try {
                    Field field = StrategyImpl.class.getDeclaredField(string);
                    field.setAccessible(true);
                    return field;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new AssertionError((Object)noSuchFieldException);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class FutureValueReference
        implements ValueReference<K, V> {
            final ReferenceEntry<K, V> original;
            final ReferenceEntry<K, V> newEntry;

            FutureValueReference(ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                this.original = referenceEntry;
                this.newEntry = referenceEntry2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public V get() {
                boolean bl = false;
                try {
                    Object v = this.original.getValueReference().get();
                    bl = true;
                    Object v2 = v;
                    return v2;
                }
                finally {
                    if (!bl) {
                        this.removeEntry();
                    }
                }
            }

            @Override
            public ValueReference<K, V> copyFor(ReferenceEntry<K, V> referenceEntry) {
                return new FutureValueReference(this.original, referenceEntry);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public V waitForValue() throws InterruptedException {
                boolean bl = false;
                try {
                    Object v = StrategyImpl.this.waitForValue(this.original);
                    bl = true;
                    Object v2 = v;
                    return v2;
                }
                finally {
                    if (!bl) {
                        this.removeEntry();
                    }
                }
            }

            void removeEntry() {
                StrategyImpl.this.internals.removeEntry(this.newEntry);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Strength {
        WEAK{

            @Override
            boolean equal(Object object, Object object2) {
                return object == object2;
            }

            @Override
            int hash(Object object) {
                return System.identityHashCode(object);
            }

            @Override
            <K, V> ValueReference<K, V> referenceValue(ReferenceEntry<K, V> referenceEntry, V v) {
                return new WeakValueReference<K, V>(v, referenceEntry);
            }

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap.Internals<K, V, ReferenceEntry<K, V>> internals, K k, int n, ReferenceEntry<K, V> referenceEntry) {
                return referenceEntry == null ? new WeakEntry<K, V>(internals, k, n) : new LinkedWeakEntry<K, V>(internals, k, n, referenceEntry);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(K k, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                WeakEntry weakEntry = (WeakEntry)referenceEntry;
                return referenceEntry2 == null ? new WeakEntry(weakEntry.internals, k, weakEntry.hash) : new LinkedWeakEntry(weakEntry.internals, k, weakEntry.hash, referenceEntry2);
            }
        }
        ,
        SOFT{

            @Override
            boolean equal(Object object, Object object2) {
                return object == object2;
            }

            @Override
            int hash(Object object) {
                return System.identityHashCode(object);
            }

            @Override
            <K, V> ValueReference<K, V> referenceValue(ReferenceEntry<K, V> referenceEntry, V v) {
                return new SoftValueReference<K, V>(v, referenceEntry);
            }

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap.Internals<K, V, ReferenceEntry<K, V>> internals, K k, int n, ReferenceEntry<K, V> referenceEntry) {
                return referenceEntry == null ? new SoftEntry<K, V>(internals, k, n) : new LinkedSoftEntry<K, V>(internals, k, n, referenceEntry);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(K k, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                SoftEntry softEntry = (SoftEntry)referenceEntry;
                return referenceEntry2 == null ? new SoftEntry(softEntry.internals, k, softEntry.hash) : new LinkedSoftEntry(softEntry.internals, k, softEntry.hash, referenceEntry2);
            }
        }
        ,
        STRONG{

            @Override
            boolean equal(Object object, Object object2) {
                return object.equals(object2);
            }

            @Override
            int hash(Object object) {
                return object.hashCode();
            }

            @Override
            <K, V> ValueReference<K, V> referenceValue(ReferenceEntry<K, V> referenceEntry, V v) {
                return new StrongValueReference(v);
            }

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap.Internals<K, V, ReferenceEntry<K, V>> internals, K k, int n, ReferenceEntry<K, V> referenceEntry) {
                return referenceEntry == null ? new StrongEntry<K, V>(internals, k, n) : new LinkedStrongEntry<K, V>(internals, k, n, referenceEntry);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(K k, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                StrongEntry strongEntry = (StrongEntry)referenceEntry;
                return referenceEntry2 == null ? new StrongEntry(strongEntry.internals, k, strongEntry.hash) : new LinkedStrongEntry(strongEntry.internals, k, strongEntry.hash, referenceEntry2);
            }
        };


        abstract boolean equal(Object var1, Object var2);

        abstract int hash(Object var1);

        abstract <K, V> ValueReference<K, V> referenceValue(ReferenceEntry<K, V> var1, V var2);

        abstract <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap.Internals<K, V, ReferenceEntry<K, V>> var1, K var2, int var3, ReferenceEntry<K, V> var4);

        abstract <K, V> ReferenceEntry<K, V> copyEntry(K var1, ReferenceEntry<K, V> var2, ReferenceEntry<K, V> var3);
    }
}

