/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ConstrainedMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapConstraint;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MutableClassToInstanceMap<B>
extends ConstrainedMap<Class<? extends B>, B>
implements ClassToInstanceMap<B> {
    private static final MapConstraint<Class<?>, Object> VALUE_CAN_BE_CAST_TO_KEY = new MapConstraint<Class<?>, Object>(){

        @Override
        public void checkKeyValue(Class<?> clazz, Object object) {
            MutableClassToInstanceMap.cast(clazz, object);
        }
    };
    private static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS = new ImmutableMap.Builder<Class<Boolean>, Class<Boolean>>().put(Boolean.TYPE, Boolean.class).put(Byte.TYPE, Byte.class).put(Character.TYPE, Character.class).put(Double.TYPE, Double.class).put(Float.TYPE, Float.class).put(Integer.TYPE, Integer.class).put(Long.TYPE, Long.class).put(Short.TYPE, Short.class).put(Void.TYPE, Void.class).build();
    private static final long serialVersionUID = 0L;

    public static <B> MutableClassToInstanceMap<B> create() {
        return new MutableClassToInstanceMap(new HashMap());
    }

    public static <B> MutableClassToInstanceMap<B> create(Map<Class<? extends B>, B> map) {
        return new MutableClassToInstanceMap<B>(map);
    }

    private MutableClassToInstanceMap(Map<Class<? extends B>, B> map) {
        super(map, VALUE_CAN_BE_CAST_TO_KEY);
    }

    @Override
    public <T extends B> T putInstance(Class<T> clazz, T t) {
        return MutableClassToInstanceMap.cast(clazz, this.put(clazz, t));
    }

    @Override
    public <T extends B> T getInstance(Class<T> clazz) {
        return MutableClassToInstanceMap.cast(clazz, this.get(clazz));
    }

    static <B, T extends B> T cast(Class<T> clazz, B b) {
        return MutableClassToInstanceMap.wrap(clazz).cast(b);
    }

    private static <T> Class<T> wrap(Class<T> clazz) {
        return clazz.isPrimitive() ? PRIMITIVES_TO_WRAPPERS.get(clazz) : clazz;
    }
}

