/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.Platform;
import java.util.Collection;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public final class ObjectArrays {
    private ObjectArrays() {
    }

    @GwtIncompatible(value="Array.newInstance(Class, int)")
    public static <T> T[] newArray(Class<T> clazz, int n) {
        return Platform.newArray(clazz, n);
    }

    public static <T> T[] newArray(T[] TArray, int n) {
        return Platform.newArray(TArray, n);
    }

    @GwtIncompatible(value="Array.newInstance(Class, int)")
    public static <T> T[] concat(T[] TArray, T[] TArray2, Class<T> clazz) {
        Object[] objectArray = ObjectArrays.newArray(clazz, TArray.length + TArray2.length);
        Platform.unsafeArrayCopy(TArray, 0, objectArray, 0, TArray.length);
        Platform.unsafeArrayCopy(TArray2, 0, objectArray, TArray.length, TArray2.length);
        return objectArray;
    }

    public static <T> T[] concat(@Nullable T t, T[] TArray) {
        Object[] objectArray = ObjectArrays.newArray(TArray, TArray.length + 1);
        objectArray[0] = t;
        Platform.unsafeArrayCopy(TArray, 0, objectArray, 1, TArray.length);
        return objectArray;
    }

    public static <T> T[] concat(T[] TArray, @Nullable T t) {
        T[] TArray2 = ObjectArrays.arraysCopyOf(TArray, TArray.length + 1);
        TArray2[TArray.length] = t;
        return TArray2;
    }

    private static <T> T[] arraysCopyOf(T[] TArray, int n) {
        Object[] objectArray = ObjectArrays.newArray(TArray, n);
        Platform.unsafeArrayCopy(TArray, 0, objectArray, 0, Math.min(TArray.length, n));
        return objectArray;
    }

    static <T> T[] toArrayImpl(Collection<?> collection, T[] TArray) {
        int n = collection.size();
        if (TArray.length < n) {
            TArray = ObjectArrays.newArray(TArray, n);
        }
        ObjectArrays.fillArray(collection, TArray);
        if (TArray.length > n) {
            TArray[n] = null;
        }
        return TArray;
    }

    static Object[] toArrayImpl(Collection<?> collection) {
        return ObjectArrays.fillArray(collection, new Object[collection.size()]);
    }

    private static Object[] fillArray(Iterable<?> iterable, Object[] objectArray) {
        int n = 0;
        for (Object obj : iterable) {
            objectArray[n++] = obj;
        }
        return objectArray;
    }
}

