/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Platform;
import com.google.common.collect.UnmodifiableIterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true)
class RegularImmutableList<E>
extends ImmutableList<E> {
    private final transient int offset;
    private final transient int size;
    private final transient Object[] array;

    RegularImmutableList(Object[] objectArray, int n, int n2) {
        this.offset = n;
        this.size = n2;
        this.array = objectArray;
    }

    RegularImmutableList(Object[] objectArray) {
        this(objectArray, 0, objectArray.length);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.forArray(this.array, this.offset, this.size);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        Platform.unsafeArrayCopy(this.array, this.offset, objectArray, 0, this.size);
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        if (TArray.length < this.size) {
            TArray = ObjectArrays.newArray(TArray, this.size);
        } else if (TArray.length > this.size) {
            TArray[this.size] = null;
        }
        Platform.unsafeArrayCopy(this.array, this.offset, TArray, 0, this.size);
        return TArray;
    }

    @Override
    public E get(int n) {
        Preconditions.checkElementIndex(n, this.size);
        return (E)this.array[n + this.offset];
    }

    @Override
    public int indexOf(Object object) {
        if (object != null) {
            for (int i = this.offset; i < this.offset + this.size; ++i) {
                if (!this.array[i].equals(object)) continue;
                return i - this.offset;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        if (object != null) {
            for (int i = this.offset + this.size - 1; i >= this.offset; --i) {
                if (!this.array[i].equals(object)) continue;
                return i - this.offset;
            }
        }
        return -1;
    }

    @Override
    public ImmutableList<E> subList(int n, int n2) {
        Preconditions.checkPositionIndexes(n, n2, this.size);
        return n == n2 ? ImmutableList.of() : new RegularImmutableList<E>(this.array, this.offset + n, n2 - n);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(final int n) {
        Preconditions.checkPositionIndex(n, this.size);
        return new ListIterator<E>(){
            int index;
            {
                this.index = n;
            }

            @Override
            public boolean hasNext() {
                return this.index < RegularImmutableList.this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public E next() {
                Object e;
                try {
                    e = RegularImmutableList.this.get(this.index);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new NoSuchElementException();
                }
                ++this.index;
                return e;
            }

            @Override
            public E previous() {
                Object e;
                try {
                    e = RegularImmutableList.this.get(this.index - 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new NoSuchElementException();
                }
                --this.index;
                return e;
            }

            @Override
            public void set(E e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(E e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        int n = this.offset;
        if (object instanceof RegularImmutableList) {
            RegularImmutableList regularImmutableList = (RegularImmutableList)object;
            for (int i = regularImmutableList.offset; i < regularImmutableList.offset + regularImmutableList.size; ++i) {
                if (this.array[n++].equals(regularImmutableList.array[i])) continue;
                return false;
            }
        } else {
            for (Object e : list) {
                if (this.array[n++].equals(e)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (int i = this.offset; i < this.offset + this.size; ++i) {
            n = 31 * n + this.array[i].hashCode();
        }
        return n;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.size() * 16);
        stringBuilder.append('[').append(this.array[this.offset]);
        for (int i = this.offset + 1; i < this.offset + this.size; ++i) {
            stringBuilder.append(", ").append(this.array[i]);
        }
        return stringBuilder.append(']').toString();
    }

    int offset() {
        return this.offset;
    }

    Object[] array() {
        return this.array;
    }
}

