/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Collections2;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true)
final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private final transient Map.Entry<K, V>[] entries;
    private final transient Object[] table;
    private final transient int mask;
    private final transient int keySetHashCode;
    private transient ImmutableSet<Map.Entry<K, V>> entrySet;
    private transient ImmutableSet<K> keySet;
    private transient ImmutableCollection<V> values;
    private static final long serialVersionUID = 0L;

    RegularImmutableMap(Map.Entry<?, ?> ... entryArray) {
        Map.Entry<?, ?>[] entryArray2 = Preconditions.checkNotNull(entryArray);
        this.entries = entryArray2;
        int n = Hashing.chooseTableSize(entryArray.length);
        this.table = new Object[n * 2];
        this.mask = n - 1;
        int n2 = 0;
        block0: for (Map.Entry<K, V> entry : this.entries) {
            Preconditions.checkNotNull(entry);
            K k = Preconditions.checkNotNull(entry.getKey());
            int n3 = k.hashCode();
            int n4 = Hashing.smear(n3);
            while (true) {
                int n5;
                Object object;
                if ((object = this.table[n5 = (n4 & this.mask) * 2]) == null) {
                    V v = Preconditions.checkNotNull(entry.getValue());
                    this.table[n5] = k;
                    this.table[n5 + 1] = v;
                    n2 += n3;
                    continue block0;
                }
                if (object.equals(k)) {
                    throw new IllegalArgumentException("duplicate key: " + k);
                }
                ++n4;
            }
        }
        this.keySetHashCode = n2;
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            return null;
        }
        int n = Hashing.smear(object.hashCode());
        int n2;
        Object object2;
        while ((object2 = this.table[n2 = (n & this.mask) * 2]) != null) {
            if (object2.equals(object)) {
                Object object3 = this.table[n2 + 1];
                return (V)object3;
            }
            ++n;
        }
        return null;
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return false;
        }
        for (Map.Entry<K, V> entry : this.entries) {
            if (!entry.getValue().equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        ImmutableSet<Map.Entry<K, V>> immutableSet = this.entrySet;
        return immutableSet == null ? (this.entrySet = new EntrySet(this)) : immutableSet;
    }

    @Override
    public ImmutableSet<K> keySet() {
        ImmutableSet<K> immutableSet = this.keySet;
        return immutableSet == null ? (this.keySet = new KeySet(this)) : immutableSet;
    }

    @Override
    public ImmutableCollection<V> values() {
        ImmutableCollection<V> immutableCollection = this.values;
        return immutableCollection == null ? (this.values = new Values(this)) : immutableCollection;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.size() * 16).append('{');
        Collections2.standardJoiner.appendTo(stringBuilder, (Object[])this.entries);
        return stringBuilder.append('}').toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Values<V>
    extends ImmutableCollection<V> {
        final RegularImmutableMap<?, V> map;

        Values(RegularImmutableMap<?, V> regularImmutableMap) {
            this.map = regularImmutableMap;
        }

        @Override
        public int size() {
            return ((RegularImmutableMap)this.map).entries.length;
        }

        @Override
        public UnmodifiableIterator<V> iterator() {
            return new AbstractIterator<V>(){
                int index = 0;

                @Override
                protected V computeNext() {
                    return this.index < Values.this.map.entries.length ? Values.this.map.entries[this.index++].getValue() : this.endOfData();
                }
            };
        }

        @Override
        public boolean contains(Object object) {
            return this.map.containsValue(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeySet<K, V>
    extends ImmutableSet.TransformedImmutableSet<Map.Entry<K, V>, K> {
        final RegularImmutableMap<K, V> map;

        KeySet(RegularImmutableMap<K, V> regularImmutableMap) {
            super(((RegularImmutableMap)regularImmutableMap).entries, ((RegularImmutableMap)regularImmutableMap).keySetHashCode);
            this.map = regularImmutableMap;
        }

        @Override
        K transform(Map.Entry<K, V> entry) {
            return entry.getKey();
        }

        @Override
        public boolean contains(Object object) {
            return this.map.containsKey(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntrySet<K, V>
    extends ImmutableSet.ArrayImmutableSet<Map.Entry<K, V>> {
        final transient RegularImmutableMap<K, V> map;

        EntrySet(RegularImmutableMap<K, V> regularImmutableMap) {
            super(((RegularImmutableMap)regularImmutableMap).entries);
            this.map = regularImmutableMap;
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                V v = this.map.get(entry.getKey());
                return v != null && v.equals(entry.getValue());
            }
            return false;
        }
    }
}

