/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedAsList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Platform;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true)
final class RegularImmutableSortedSet<E>
extends ImmutableSortedSet<E> {
    private final Object[] elements;
    private final int fromIndex;
    private final int toIndex;

    RegularImmutableSortedSet(Object[] objectArray, Comparator<? super E> comparator) {
        super(comparator);
        this.elements = objectArray;
        this.fromIndex = 0;
        this.toIndex = objectArray.length;
    }

    RegularImmutableSortedSet(Object[] objectArray, Comparator<? super E> comparator, int n, int n2) {
        super(comparator);
        this.elements = objectArray;
        this.fromIndex = n;
        this.toIndex = n2;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.forArray(this.elements, this.fromIndex, this.size());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return this.toIndex - this.fromIndex;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        try {
            return this.binarySearch(object) >= 0;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (!RegularImmutableSortedSet.hasSameComparator(collection, this.comparator()) || collection.size() <= 1) {
            return super.containsAll(collection);
        }
        int n = this.fromIndex;
        Iterator<?> iterator = collection.iterator();
        Object obj = iterator.next();
        while (true) {
            if (n >= this.toIndex) {
                return false;
            }
            int n2 = this.unsafeCompare(this.elements[n], obj);
            if (n2 < 0) {
                ++n;
                continue;
            }
            if (n2 == 0) {
                if (!iterator.hasNext()) {
                    return true;
                }
                obj = iterator.next();
                ++n;
                continue;
            }
            if (n2 > 0) break;
        }
        return false;
    }

    private int binarySearch(Object object) {
        int n = this.fromIndex;
        int n2 = this.toIndex - 1;
        while (n <= n2) {
            int n3 = n + (n2 - n) / 2;
            int n4 = this.unsafeCompare(object, this.elements[n3]);
            if (n4 < 0) {
                n2 = n3 - 1;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            return n3;
        }
        return -n - 1;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        Platform.unsafeArrayCopy(this.elements, this.fromIndex, objectArray, 0, this.size());
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        int n = this.size();
        if (TArray.length < n) {
            TArray = ObjectArrays.newArray(TArray, n);
        } else if (TArray.length > n) {
            TArray[n] = null;
        }
        Platform.unsafeArrayCopy(this.elements, this.fromIndex, TArray, 0, n);
        return TArray;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set set = (Set)object;
        if (this.size() != set.size()) {
            return false;
        }
        if (RegularImmutableSortedSet.hasSameComparator(set, this.comparator)) {
            Iterator iterator = set.iterator();
            try {
                for (int i = this.fromIndex; i < this.toIndex; ++i) {
                    Object e = iterator.next();
                    if (e != null && this.unsafeCompare(this.elements[i], e) == 0) continue;
                    return false;
                }
                return true;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
        }
        return this.containsAll(set);
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (int i = this.fromIndex; i < this.toIndex; ++i) {
            n += this.elements[i].hashCode();
        }
        return n;
    }

    @Override
    public E first() {
        return (E)this.elements[this.fromIndex];
    }

    @Override
    public E last() {
        return (E)this.elements[this.toIndex - 1];
    }

    @Override
    ImmutableSortedSet<E> headSetImpl(E e) {
        return this.createSubset(this.fromIndex, this.findSubsetIndex(e));
    }

    @Override
    ImmutableSortedSet<E> subSetImpl(E e, E e2) {
        return this.createSubset(this.findSubsetIndex(e), this.findSubsetIndex(e2));
    }

    @Override
    ImmutableSortedSet<E> tailSetImpl(E e) {
        return this.createSubset(this.findSubsetIndex(e), this.toIndex);
    }

    private int findSubsetIndex(E e) {
        int n = this.binarySearch(e);
        return n >= 0 ? n : -n - 1;
    }

    private ImmutableSortedSet<E> createSubset(int n, int n2) {
        if (n < n2) {
            return new RegularImmutableSortedSet<E>(this.elements, this.comparator, n, n2);
        }
        return RegularImmutableSortedSet.emptySet(this.comparator);
    }

    @Override
    boolean hasPartialArray() {
        return this.fromIndex != 0 || this.toIndex != this.elements.length;
    }

    @Override
    int indexOf(Object object) {
        int n;
        if (object == null) {
            return -1;
        }
        try {
            n = this.binarySearch(object);
        }
        catch (ClassCastException classCastException) {
            return -1;
        }
        return n >= 0 && this.elements[n].equals(object) ? n - this.fromIndex : -1;
    }

    @Override
    ImmutableList<E> createAsList() {
        return new ImmutableSortedAsList(this.elements, this.fromIndex, this.size(), this);
    }
}

