/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
final class Serialization {
    private Serialization() {
    }

    @GwtIncompatible(value="java.io.ObjectInputStream")
    public static int readCount(ObjectInputStream objectInputStream) throws IOException {
        return objectInputStream.readInt();
    }

    @GwtIncompatible(value="java.io.ObjectOutputStream")
    public static <K, V> void writeMap(Map<K, V> map, ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
    }

    @GwtIncompatible(value="java.io.ObjectInputStream")
    public static <K, V> void populateMap(Map<K, V> map, ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        Serialization.populateMap(map, objectInputStream, n);
    }

    @GwtIncompatible(value="java.io.ObjectInputStream")
    public static <K, V> void populateMap(Map<K, V> map, ObjectInputStream objectInputStream, int n) throws IOException, ClassNotFoundException {
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            map.put(object, object2);
        }
    }

    @GwtIncompatible(value="java.io.ObjectOutputStream")
    public static <E> void writeMultiset(Multiset<E> multiset, ObjectOutputStream objectOutputStream) throws IOException {
        int n = multiset.entrySet().size();
        objectOutputStream.writeInt(n);
        for (Multiset.Entry<E> entry : multiset.entrySet()) {
            objectOutputStream.writeObject(entry.getElement());
            objectOutputStream.writeInt(entry.getCount());
        }
    }

    @GwtIncompatible(value="java.io.ObjectInputStream")
    public static <E> void populateMultiset(Multiset<E> multiset, ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        Serialization.populateMultiset(multiset, objectInputStream, n);
    }

    @GwtIncompatible(value="java.io.ObjectInputStream")
    public static <E> void populateMultiset(Multiset<E> multiset, ObjectInputStream objectInputStream, int n) throws IOException, ClassNotFoundException {
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            int n2 = objectInputStream.readInt();
            multiset.add(object, n2);
        }
    }

    @GwtIncompatible(value="java.io.ObjectOutputStream")
    public static <K, V> void writeMultimap(Multimap<K, V> multimap, ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(multimap.asMap().size());
        for (Map.Entry<K, Collection<V>> entry : multimap.asMap().entrySet()) {
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeInt(entry.getValue().size());
            for (V v : entry.getValue()) {
                objectOutputStream.writeObject(v);
            }
        }
    }

    @GwtIncompatible(value="java.io.ObjectInputStream")
    public static <K, V> void populateMultimap(Multimap<K, V> multimap, ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        Serialization.populateMultimap(multimap, objectInputStream, n);
    }

    @GwtIncompatible(value="java.io.ObjectInputStream")
    public static <K, V> void populateMultimap(Multimap<K, V> multimap, ObjectInputStream objectInputStream, int n) throws IOException, ClassNotFoundException {
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            Collection<V> collection = multimap.get(object);
            int n2 = objectInputStream.readInt();
            for (int j = 0; j < n2; ++j) {
                Object object2 = objectInputStream.readObject();
                collection.add(object2);
            }
        }
    }

    @GwtIncompatible(value="java.lang.reflect.Field")
    static <T> FieldSetter<T> getFieldSetter(Class<T> clazz, String string) {
        try {
            Field field = clazz.getDeclaredField(string);
            return new FieldSetter(field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new AssertionError((Object)noSuchFieldException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GwtCompatible(emulated=true)
    static final class FieldSetter<T> {
        private final Field field;

        private FieldSetter(Field field) {
            this.field = field;
            field.setAccessible(true);
        }

        @GwtIncompatible(value="java.lang.reflect.Field")
        void set(T t, Object object) {
            try {
                this.field.set(t, object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
        }

        @GwtIncompatible(value="java.lang.reflect.Field")
        void set(T t, int n) {
            try {
                this.field.set(t, n);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
        }
    }
}

