/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableEnumSet;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public final class Sets {
    private Sets() {
    }

    @GwtCompatible(serializable=true)
    public static <E extends Enum<E>> ImmutableSet<E> immutableEnumSet(E e, E ... EArray) {
        return new ImmutableEnumSet<E[]>(EnumSet.of(e, EArray));
    }

    @GwtCompatible(serializable=true)
    public static <E extends Enum<E>> ImmutableSet<E> immutableEnumSet(Iterable<E> iterable) {
        Iterator<E> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return ImmutableSet.of();
        }
        if (iterable instanceof EnumSet) {
            EnumSet enumSet = EnumSet.copyOf((EnumSet)iterable);
            return new ImmutableEnumSet(enumSet);
        }
        Enum enum_ = (Enum)iterator.next();
        EnumSet<Enum> enumSet = EnumSet.of(enum_);
        while (iterator.hasNext()) {
            enumSet.add((Enum)iterator.next());
        }
        return new ImmutableEnumSet<Enum>(enumSet);
    }

    public static <E extends Enum<E>> EnumSet<E> newEnumSet(Iterable<E> iterable, Class<E> clazz) {
        Preconditions.checkNotNull(iterable);
        EnumSet<E> enumSet = EnumSet.noneOf(clazz);
        Iterables.addAll(enumSet, iterable);
        return enumSet;
    }

    public static <E> HashSet<E> newHashSet() {
        return new HashSet();
    }

    public static <E> HashSet<E> newHashSet(E ... EArray) {
        int n = Maps.capacity(EArray.length);
        HashSet hashSet = new HashSet(n);
        Collections.addAll(hashSet, EArray);
        return hashSet;
    }

    public static <E> HashSet<E> newHashSetWithExpectedSize(int n) {
        return new HashSet(Maps.capacity(n));
    }

    public static <E> HashSet<E> newHashSet(Iterable<? extends E> iterable) {
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            return new HashSet(collection);
        }
        return Sets.newHashSet(iterable.iterator());
    }

    public static <E> HashSet<E> newHashSet(Iterator<? extends E> iterator) {
        HashSet<E> hashSet = Sets.newHashSet();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        return hashSet;
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet(Iterable<? extends E> iterable) {
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            return new LinkedHashSet(collection);
        }
        LinkedHashSet<E> linkedHashSet = Sets.newLinkedHashSet();
        for (E e : iterable) {
            linkedHashSet.add(e);
        }
        return linkedHashSet;
    }

    public static <E extends Comparable> TreeSet<E> newTreeSet() {
        return new TreeSet();
    }

    public static <E extends Comparable> TreeSet<E> newTreeSet(Iterable<? extends E> iterable) {
        TreeSet<Comparable> treeSet = Sets.newTreeSet();
        for (Comparable comparable : iterable) {
            treeSet.add(comparable);
        }
        return treeSet;
    }

    public static <E> TreeSet<E> newTreeSet(Comparator<? super E> comparator) {
        return new TreeSet<E>(Preconditions.checkNotNull(comparator));
    }

    public static <E extends Enum<E>> EnumSet<E> complementOf(Collection<E> collection) {
        if (collection instanceof EnumSet) {
            return EnumSet.complementOf((EnumSet)collection);
        }
        Preconditions.checkArgument(!collection.isEmpty(), "collection is empty; use the other version of this method");
        Class clazz = ((Enum)collection.iterator().next()).getDeclaringClass();
        return Sets.makeComplementByHand(collection, clazz);
    }

    public static <E extends Enum<E>> EnumSet<E> complementOf(Collection<E> collection, Class<E> clazz) {
        Preconditions.checkNotNull(collection);
        return collection instanceof EnumSet ? EnumSet.complementOf((EnumSet)collection) : Sets.makeComplementByHand(collection, clazz);
    }

    private static <E extends Enum<E>> EnumSet<E> makeComplementByHand(Collection<E> collection, Class<E> clazz) {
        EnumSet<E> enumSet = EnumSet.allOf(clazz);
        enumSet.removeAll(collection);
        return enumSet;
    }

    public static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
        return new SetFromMap<E>(map);
    }

    public static <E> SetView<E> union(final Set<? extends E> set, final Set<? extends E> set2) {
        Preconditions.checkNotNull(set, "set1");
        Preconditions.checkNotNull(set2, "set2");
        final SetView<? extends E> setView = Sets.difference(set2, set);
        return new SetView<E>(){

            @Override
            public int size() {
                return set.size() + setView.size();
            }

            @Override
            public boolean isEmpty() {
                return set.isEmpty() && set2.isEmpty();
            }

            @Override
            public Iterator<E> iterator() {
                return Iterators.unmodifiableIterator(Iterators.concat(set.iterator(), setView.iterator()));
            }

            @Override
            public boolean contains(Object object) {
                return set.contains(object) || set2.contains(object);
            }

            @Override
            public <S extends Set<E>> S copyInto(S s) {
                s.addAll(set);
                s.addAll(set2);
                return s;
            }

            @Override
            public ImmutableSet<E> immutableCopy() {
                return ((ImmutableSet.Builder)((ImmutableSet.Builder)new ImmutableSet.Builder().addAll((Iterable)set)).addAll((Iterable)set2)).build();
            }
        };
    }

    public static <E> SetView<E> intersection(final Set<E> set, final Set<?> set2) {
        Preconditions.checkNotNull(set, "set1");
        Preconditions.checkNotNull(set2, "set2");
        final Predicate<?> predicate = Predicates.in(set2);
        return new SetView<E>(){

            @Override
            public Iterator<E> iterator() {
                return Iterators.filter(set.iterator(), predicate);
            }

            @Override
            public int size() {
                return Iterators.size(this.iterator());
            }

            @Override
            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }

            @Override
            public boolean contains(Object object) {
                return set.contains(object) && set2.contains(object);
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                return set.containsAll(collection) && set2.containsAll(collection);
            }
        };
    }

    public static <E> SetView<E> difference(final Set<E> set, final Set<?> set2) {
        Preconditions.checkNotNull(set, "set1");
        Preconditions.checkNotNull(set2, "set2");
        final Predicate<?> predicate = Predicates.not(Predicates.in(set2));
        return new SetView<E>(){

            @Override
            public Iterator<E> iterator() {
                return Iterators.filter(set.iterator(), predicate);
            }

            @Override
            public int size() {
                return Iterators.size(this.iterator());
            }

            @Override
            public boolean isEmpty() {
                return set2.containsAll(set);
            }

            @Override
            public boolean contains(Object object) {
                return set.contains(object) && !set2.contains(object);
            }
        };
    }

    public static <E> Set<E> filter(Set<E> set, Predicate<? super E> predicate) {
        if (set instanceof FilteredSet) {
            FilteredSet filteredSet = (FilteredSet)set;
            Predicate<? super E> predicate2 = Predicates.and(filteredSet.predicate, predicate);
            return new FilteredSet<E>((Set)filteredSet.unfiltered, predicate2);
        }
        return new FilteredSet<E>(Preconditions.checkNotNull(set), Preconditions.checkNotNull(predicate));
    }

    public static <B> Set<List<B>> cartesianProduct(List<? extends Set<? extends B>> list) {
        CartesianSet cartesianSet = new CartesianSet(list);
        return cartesianSet.isEmpty() ? ImmutableSet.of() : cartesianSet;
    }

    public static <B> Set<List<B>> cartesianProduct(Set<? extends B> ... setArray) {
        return Sets.cartesianProduct(Arrays.asList(setArray));
    }

    static int hashCodeImpl(Set<?> set) {
        int n = 0;
        for (Object obj : set) {
            n += obj != null ? obj.hashCode() : 0;
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CartesianSet<B>
    extends AbstractSet<List<B>> {
        final ImmutableList<Axis> axes;
        final int size;

        CartesianSet(List<? extends Set<? extends B>> list) {
            long l = 1L;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Set<B> set : list) {
                Axis axis = new Axis(set, (int)l);
                builder.add(axis);
                l *= (long)axis.size();
            }
            this.axes = builder.build();
            this.size = Ints.checkedCast(l);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public UnmodifiableIterator<List<B>> iterator() {
            return new UnmodifiableIterator<List<B>>(){
                int index;

                @Override
                public boolean hasNext() {
                    return this.index < CartesianSet.this.size;
                }

                @Override
                public List<B> next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Object[] objectArray = new Object[CartesianSet.this.axes.size()];
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray[i] = ((Axis)CartesianSet.this.axes.get(i)).getForIndex(this.index);
                    }
                    ++this.index;
                    ImmutableList<Object> immutableList = ImmutableList.of(objectArray);
                    return immutableList;
                }
            };
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof List)) {
                return false;
            }
            List list = (List)object;
            int n = this.axes.size();
            if (list.size() != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (((Axis)this.axes.get(i)).contains(list.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof CartesianSet) {
                CartesianSet cartesianSet = (CartesianSet)object;
                return this.axes.equals(cartesianSet.axes);
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n = this.size - 1;
            for (int i = 0; i < this.axes.size(); ++i) {
                n *= 31;
            }
            return this.axes.hashCode() + n;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class Axis {
            final ImmutableSet<? extends B> choices;
            final int dividend;

            Axis(Set<? extends B> set, int n) {
                this.choices = ImmutableSet.copyOf(set);
                this.dividend = n;
            }

            int size() {
                return this.choices.size();
            }

            B getForIndex(int n) {
                return this.choices.asList().get(n / this.dividend % this.size());
            }

            boolean contains(Object object) {
                return this.choices.contains(object);
            }

            public boolean equals(Object object) {
                if (object instanceof Axis) {
                    Axis axis = (Axis)object;
                    return this.choices.equals(axis.choices);
                }
                return false;
            }

            public int hashCode() {
                return CartesianSet.this.size / this.choices.size() * this.choices.hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteredSet<E>
    extends Collections2.FilteredCollection<E>
    implements Set<E> {
        FilteredSet(Set<E> set, Predicate<? super E> predicate) {
            super(set, predicate);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            return Collections2.setEquals(this, object);
        }

        @Override
        public int hashCode() {
            return Sets.hashCodeImpl(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class SetView<E>
    extends AbstractSet<E> {
        private SetView() {
        }

        public ImmutableSet<E> immutableCopy() {
            return ImmutableSet.copyOf(this);
        }

        public <S extends Set<E>> S copyInto(S s) {
            s.addAll(this);
            return s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetFromMap<E>
    extends AbstractSet<E>
    implements Set<E>,
    Serializable {
        private final Map<E, Boolean> m;
        private transient Set<E> s;
        private static final long serialVersionUID = 0L;

        SetFromMap(Map<E, Boolean> map) {
            Preconditions.checkArgument(map.isEmpty(), "Map is non-empty");
            this.m = map;
            this.s = map.keySet();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.m.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.m.remove(object) != null;
        }

        @Override
        public boolean add(E e) {
            return this.m.put(e, Boolean.TRUE) == null;
        }

        @Override
        public Iterator<E> iterator() {
            return this.s.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.s.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.s.toArray(TArray);
        }

        @Override
        public String toString() {
            return this.s.toString();
        }

        @Override
        public int hashCode() {
            return ((Object)this.s).hashCode();
        }

        @Override
        public boolean equals(@Nullable Object object) {
            return this == object || ((Object)this.s).equals(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.s.containsAll(collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.s.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.s.retainAll(collection);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.s = this.m.keySet();
        }
    }
}

