/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;

class AppendableWriter
extends Writer {
    private final Appendable target;
    private boolean closed;

    AppendableWriter(Appendable appendable) {
        this.target = appendable;
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.checkNotClosed();
        this.target.append(new String(cArray, n, n2));
    }

    public void flush() throws IOException {
        this.checkNotClosed();
        if (this.target instanceof Flushable) {
            ((Flushable)((Object)this.target)).flush();
        }
    }

    public void close() throws IOException {
        this.closed = true;
        if (this.target instanceof Closeable) {
            ((Closeable)((Object)this.target)).close();
        }
    }

    public void write(int n) throws IOException {
        this.checkNotClosed();
        this.target.append((char)n);
    }

    public void write(String string) throws IOException {
        this.checkNotClosed();
        this.target.append(string);
    }

    public void write(String string, int n, int n2) throws IOException {
        this.checkNotClosed();
        this.target.append(string, n, n + n2);
    }

    public Writer append(char c) throws IOException {
        this.checkNotClosed();
        this.target.append(c);
        return this;
    }

    public Writer append(CharSequence charSequence) throws IOException {
        this.checkNotClosed();
        this.target.append(charSequence);
        return this;
    }

    public Writer append(CharSequence charSequence, int n, int n2) throws IOException {
        this.checkNotClosed();
        this.target.append(charSequence, n, n2);
        return this;
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed writer.");
        }
    }
}

