/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import com.google.common.io.LineProcessor;
import com.google.common.io.OutputSupplier;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.List;
import java.util.zip.Checksum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Files {
    private static final int TEMP_DIR_ATTEMPTS = 10000;

    private Files() {
    }

    public static BufferedReader newReader(File file, Charset charset) throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
    }

    public static BufferedWriter newWriter(File file, Charset charset) throws FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));
    }

    public static InputSupplier<FileInputStream> newInputStreamSupplier(final File file) {
        Preconditions.checkNotNull(file);
        return new InputSupplier<FileInputStream>(){

            @Override
            public FileInputStream getInput() throws IOException {
                return new FileInputStream(file);
            }
        };
    }

    public static OutputSupplier<FileOutputStream> newOutputStreamSupplier(File file) {
        return Files.newOutputStreamSupplier(file, false);
    }

    public static OutputSupplier<FileOutputStream> newOutputStreamSupplier(final File file, final boolean bl) {
        Preconditions.checkNotNull(file);
        return new OutputSupplier<FileOutputStream>(){

            @Override
            public FileOutputStream getOutput() throws IOException {
                return new FileOutputStream(file, bl);
            }
        };
    }

    public static InputSupplier<InputStreamReader> newReaderSupplier(File file, Charset charset) {
        return CharStreams.newReaderSupplier(Files.newInputStreamSupplier(file), charset);
    }

    public static OutputSupplier<OutputStreamWriter> newWriterSupplier(File file, Charset charset) {
        return Files.newWriterSupplier(file, charset, false);
    }

    public static OutputSupplier<OutputStreamWriter> newWriterSupplier(File file, Charset charset, boolean bl) {
        return CharStreams.newWriterSupplier(Files.newOutputStreamSupplier(file, bl), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(File file) throws IOException {
        Preconditions.checkArgument(file.length() <= Integer.MAX_VALUE);
        if (file.length() == 0L) {
            return ByteStreams.toByteArray(Files.newInputStreamSupplier(file));
        }
        byte[] byArray = new byte[(int)file.length()];
        boolean bl = true;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            ByteStreams.readFully(fileInputStream, byArray);
            bl = false;
        }
        finally {
            Closeables.close(fileInputStream, bl);
        }
        return byArray;
    }

    public static String toString(File file, Charset charset) throws IOException {
        return new String(Files.toByteArray(file), charset.name());
    }

    public static void copy(InputSupplier<? extends InputStream> inputSupplier, File file) throws IOException {
        ByteStreams.copy(inputSupplier, Files.newOutputStreamSupplier(file));
    }

    public static void write(byte[] byArray, File file) throws IOException {
        ByteStreams.write(byArray, Files.newOutputStreamSupplier(file));
    }

    public static void copy(File file, OutputSupplier<? extends OutputStream> outputSupplier) throws IOException {
        ByteStreams.copy(Files.newInputStreamSupplier(file), outputSupplier);
    }

    public static void copy(File file, OutputStream outputStream) throws IOException {
        ByteStreams.copy(Files.newInputStreamSupplier(file), outputStream);
    }

    public static void copy(File file, File file2) throws IOException {
        Files.copy(Files.newInputStreamSupplier(file), file2);
    }

    public static <R extends Readable & Closeable> void copy(InputSupplier<R> inputSupplier, File file, Charset charset) throws IOException {
        CharStreams.copy(inputSupplier, Files.newWriterSupplier(file, charset));
    }

    public static void write(CharSequence charSequence, File file, Charset charset) throws IOException {
        Files.write(charSequence, file, charset, false);
    }

    public static void append(CharSequence charSequence, File file, Charset charset) throws IOException {
        Files.write(charSequence, file, charset, true);
    }

    private static void write(CharSequence charSequence, File file, Charset charset, boolean bl) throws IOException {
        CharStreams.write(charSequence, Files.newWriterSupplier(file, charset, bl));
    }

    public static <W extends Appendable & Closeable> void copy(File file, Charset charset, OutputSupplier<W> outputSupplier) throws IOException {
        CharStreams.copy(Files.newReaderSupplier(file, charset), outputSupplier);
    }

    public static void copy(File file, Charset charset, Appendable appendable) throws IOException {
        CharStreams.copy(Files.newReaderSupplier(file, charset), appendable);
    }

    public static boolean equal(File file, File file2) throws IOException {
        if (file == file2 || file.equals(file2)) {
            return true;
        }
        long l = file.length();
        long l2 = file2.length();
        if (l != 0L && l2 != 0L && l != l2) {
            return false;
        }
        return ByteStreams.equal(Files.newInputStreamSupplier(file), Files.newInputStreamSupplier(file2));
    }

    public static File createTempDir() {
        File file = new File(System.getProperty("java.io.tmpdir"));
        String string = System.currentTimeMillis() + "-";
        for (int i = 0; i < 10000; ++i) {
            File file2 = new File(file, string + i);
            if (!file2.mkdir()) continue;
            return file2;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + string + "0 to " + string + 9999 + ')');
    }

    public static void touch(File file) throws IOException {
        if (!file.createNewFile() && !file.setLastModified(System.currentTimeMillis())) {
            throw new IOException("Unable to update modification time of " + file);
        }
    }

    public static void move(File file, File file2) throws IOException {
        Preconditions.checkNotNull(file2);
        Preconditions.checkArgument(!file.equals(file2), "Source %s and destination %s must be different", file, file2);
        if (!file.renameTo(file2)) {
            Files.copy(file, file2);
            if (!file.delete()) {
                if (!file2.delete()) {
                    throw new IOException("Unable to delete " + file2);
                }
                throw new IOException("Unable to delete " + file);
            }
        }
    }

    public static void deleteDirectoryContents(File file) throws IOException {
        Preconditions.checkArgument(file.isDirectory(), "Not a directory: %s", file);
        if (!file.getCanonicalPath().equals(file.getAbsolutePath())) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException("Error listing files for " + file);
        }
        for (File file2 : fileArray) {
            Files.deleteRecursively(file2);
        }
    }

    public static void deleteRecursively(File file) throws IOException {
        if (file.isDirectory()) {
            Files.deleteDirectoryContents(file);
        }
        if (!file.delete()) {
            throw new IOException("Failed to delete " + file);
        }
    }

    public static String readFirstLine(File file, Charset charset) throws IOException {
        return CharStreams.readFirstLine(Files.newReaderSupplier(file, charset));
    }

    public static List<String> readLines(File file, Charset charset) throws IOException {
        return CharStreams.readLines(Files.newReaderSupplier(file, charset));
    }

    public static <T> T readLines(File file, Charset charset, LineProcessor<T> lineProcessor) throws IOException {
        return CharStreams.readLines(Files.newReaderSupplier(file, charset), lineProcessor);
    }

    public static <T> T readBytes(File file, ByteProcessor<T> byteProcessor) throws IOException {
        return ByteStreams.readBytes(Files.newInputStreamSupplier(file), byteProcessor);
    }

    public static long getChecksum(File file, Checksum checksum) throws IOException {
        return ByteStreams.getChecksum(Files.newInputStreamSupplier(file), checksum);
    }

    public static byte[] getDigest(File file, MessageDigest messageDigest) throws IOException {
        return ByteStreams.getDigest(Files.newInputStreamSupplier(file), messageDigest);
    }

    public static MappedByteBuffer map(File file) throws IOException {
        return Files.map(file, FileChannel.MapMode.READ_ONLY);
    }

    public static MappedByteBuffer map(File file, FileChannel.MapMode mapMode) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        return Files.map(file, mapMode, file.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MappedByteBuffer map(File file, FileChannel.MapMode mapMode, long l) throws FileNotFoundException, IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, mapMode == FileChannel.MapMode.READ_ONLY ? "r" : "rw");
        boolean bl = true;
        try {
            MappedByteBuffer mappedByteBuffer = Files.map(randomAccessFile, mapMode, l);
            bl = false;
            MappedByteBuffer mappedByteBuffer2 = mappedByteBuffer;
            return mappedByteBuffer2;
        }
        finally {
            Closeables.close(randomAccessFile, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MappedByteBuffer map(RandomAccessFile randomAccessFile, FileChannel.MapMode mapMode, long l) throws IOException {
        FileChannel fileChannel = randomAccessFile.getChannel();
        boolean bl = true;
        try {
            MappedByteBuffer mappedByteBuffer = fileChannel.map(mapMode, 0L, l);
            bl = false;
            MappedByteBuffer mappedByteBuffer2 = mappedByteBuffer;
            return mappedByteBuffer2;
        }
        finally {
            Closeables.close(fileChannel, bl);
        }
    }
}

