/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import com.google.common.io.LineProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Resources {
    public static InputSupplier<InputStream> newInputStreamSupplier(final URL uRL) {
        Preconditions.checkNotNull(uRL);
        return new InputSupplier<InputStream>(){

            @Override
            public InputStream getInput() throws IOException {
                return uRL.openStream();
            }
        };
    }

    public static InputSupplier<InputStreamReader> newReaderSupplier(URL uRL, Charset charset) {
        return CharStreams.newReaderSupplier(Resources.newInputStreamSupplier(uRL), charset);
    }

    public static byte[] toByteArray(URL uRL) throws IOException {
        return ByteStreams.toByteArray(Resources.newInputStreamSupplier(uRL));
    }

    public static String toString(URL uRL, Charset charset) throws IOException {
        return CharStreams.toString(Resources.newReaderSupplier(uRL, charset));
    }

    public static <T> T readLines(URL uRL, Charset charset, LineProcessor<T> lineProcessor) throws IOException {
        return CharStreams.readLines(Resources.newReaderSupplier(uRL, charset), lineProcessor);
    }

    public static List<String> readLines(URL uRL, Charset charset) throws IOException {
        return CharStreams.readLines(Resources.newReaderSupplier(uRL, charset));
    }

    public static void copy(URL uRL, OutputStream outputStream) throws IOException {
        ByteStreams.copy(Resources.newInputStreamSupplier(uRL), outputStream);
    }

    public static URL getResource(String string) {
        URL uRL = Resources.class.getClassLoader().getResource(string);
        Preconditions.checkArgument(uRL != null, "resource %s not found.", string);
        return uRL;
    }

    public static URL getResource(Class<?> clazz, String string) {
        URL uRL = clazz.getResource(string);
        Preconditions.checkArgument(uRL != null, "resource %s relative to %s not found.", string, clazz.getName());
        return uRL;
    }
}

