/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCheckedFuture<V, E extends Exception>
implements CheckedFuture<V, E> {
    protected final ListenableFuture<V> delegate;

    protected AbstractCheckedFuture(ListenableFuture<V> listenableFuture) {
        this.delegate = listenableFuture;
    }

    protected abstract E mapException(Exception var1);

    @Override
    public V checkedGet() throws E {
        try {
            return this.get();
        }
        catch (InterruptedException interruptedException) {
            this.cancel(true);
            throw this.mapException(interruptedException);
        }
        catch (CancellationException cancellationException) {
            throw this.mapException(cancellationException);
        }
        catch (ExecutionException executionException) {
            throw this.mapException(executionException);
        }
    }

    @Override
    public V checkedGet(long l, TimeUnit timeUnit) throws TimeoutException, E {
        try {
            return this.get(l, timeUnit);
        }
        catch (InterruptedException interruptedException) {
            this.cancel(true);
            throw this.mapException(interruptedException);
        }
        catch (CancellationException cancellationException) {
            throw this.mapException(cancellationException);
        }
        catch (ExecutionException executionException) {
            throw this.mapException(executionException);
        }
    }

    @Override
    public boolean cancel(boolean bl) {
        return this.delegate.cancel(bl);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.delegate.get();
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.get(l, timeUnit);
    }

    @Override
    public void addListener(Runnable runnable, Executor executor) {
        this.delegate.addListener(runnable, executor);
    }
}

