/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFuture<V>
implements Future<V> {
    private final Sync<V> sync = new Sync();

    @Override
    public V get(long l, TimeUnit timeUnit) throws InterruptedException, TimeoutException, ExecutionException {
        return this.sync.get(timeUnit.toNanos(l));
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.sync.get();
    }

    @Override
    public boolean isDone() {
        return this.sync.isDone();
    }

    @Override
    public boolean isCancelled() {
        return this.sync.isCancelled();
    }

    @Override
    public boolean cancel(boolean bl) {
        return false;
    }

    protected boolean set(V v) {
        boolean bl = this.sync.set(v);
        if (bl) {
            this.done();
        }
        return bl;
    }

    protected boolean setException(Throwable throwable) {
        boolean bl = this.sync.setException(throwable);
        if (bl) {
            this.done();
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        return bl;
    }

    protected final boolean cancel() {
        boolean bl = this.sync.cancel();
        if (bl) {
            this.done();
        }
        return bl;
    }

    protected void done() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Sync<V>
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 0L;
        static final int RUNNING = 0;
        static final int COMPLETING = 1;
        static final int COMPLETED = 2;
        static final int CANCELLED = 4;
        private V value;
        private ExecutionException exception;

        Sync() {
        }

        @Override
        protected int tryAcquireShared(int n) {
            if (this.isDone()) {
                return 1;
            }
            return -1;
        }

        @Override
        protected boolean tryReleaseShared(int n) {
            this.setState(n);
            return true;
        }

        V get(long l) throws TimeoutException, CancellationException, ExecutionException, InterruptedException {
            if (!this.tryAcquireSharedNanos(-1, l)) {
                throw new TimeoutException("Timeout waiting for task.");
            }
            return this.getValue();
        }

        V get() throws CancellationException, ExecutionException, InterruptedException {
            this.acquireSharedInterruptibly(-1);
            return this.getValue();
        }

        private V getValue() throws CancellationException, ExecutionException {
            int n = this.getState();
            switch (n) {
                case 2: {
                    if (this.exception != null) {
                        throw this.exception;
                    }
                    return this.value;
                }
                case 4: {
                    throw new CancellationException("Task was cancelled.");
                }
            }
            throw new IllegalStateException("Error, synchronizer in invalid state: " + n);
        }

        boolean isDone() {
            return (this.getState() & 6) != 0;
        }

        boolean isCancelled() {
            return this.getState() == 4;
        }

        boolean set(V v) {
            return this.complete(v, null, 2);
        }

        boolean setException(Throwable throwable) {
            return this.complete(null, throwable, 2);
        }

        boolean cancel() {
            return this.complete(null, null, 4);
        }

        private boolean complete(V v, Throwable throwable, int n) {
            if (this.compareAndSetState(0, 1)) {
                this.value = v;
                this.exception = throwable == null ? null : new ExecutionException(throwable);
                this.releaseShared(n);
                return true;
            }
            return false;
        }
    }
}

