/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Service;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.AbstractService;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIdleService
implements Service {
    private final Service delegate = new AbstractService(){

        protected final void doStart() {
            AbstractIdleService.this.executor(Service.State.STARTING).execute(new Runnable(){

                public void run() {
                    try {
                        AbstractIdleService.this.startUp();
                        this.notifyStarted();
                    }
                    catch (Throwable throwable) {
                        this.notifyFailed(throwable);
                        throw Throwables.propagate(throwable);
                    }
                }
            });
        }

        protected final void doStop() {
            AbstractIdleService.this.executor(Service.State.STOPPING).execute(new Runnable(){

                public void run() {
                    try {
                        AbstractIdleService.this.shutDown();
                        this.notifyStopped();
                    }
                    catch (Throwable throwable) {
                        this.notifyFailed(throwable);
                        throw Throwables.propagate(throwable);
                    }
                }
            });
        }
    };

    protected abstract void startUp() throws Exception;

    protected abstract void shutDown() throws Exception;

    protected Executor executor(final Service.State state) {
        return new Executor(){

            public void execute(Runnable runnable) {
                new Thread(runnable, AbstractIdleService.this.toString() + " " + (Object)((Object)state)).start();
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public final Future<Service.State> start() {
        return this.delegate.start();
    }

    @Override
    public final Service.State startAndWait() {
        return this.delegate.startAndWait();
    }

    @Override
    public final boolean isRunning() {
        return this.delegate.isRunning();
    }

    @Override
    public final Service.State state() {
        return this.delegate.state();
    }

    @Override
    public final Future<Service.State> stop() {
        return this.delegate.stop();
    }

    @Override
    public final Service.State stopAndWait() {
        return this.delegate.stopAndWait();
    }
}

