/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractCheckedFuture;
import com.google.common.util.concurrent.AbstractListenableFuture;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.Executors;
import com.google.common.util.concurrent.ForwardingFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.UninterruptibleFuture;
import com.google.common.util.concurrent.ValueFuture;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Futures {
    private Futures() {
    }

    public static <V> UninterruptibleFuture<V> makeUninterruptible(final Future<V> future) {
        Preconditions.checkNotNull(future);
        if (future instanceof UninterruptibleFuture) {
            return (UninterruptibleFuture)future;
        }
        return new UninterruptibleFuture<V>(){

            @Override
            public boolean cancel(boolean bl) {
                return future.cancel(bl);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            @Override
            public V get(long l, TimeUnit timeUnit) throws TimeoutException, ExecutionException {
                boolean bl = false;
                try {
                    long l2 = timeUnit.toNanos(l);
                    long l3 = System.nanoTime() + l2;
                    long l4 = l2;
                    while (l4 > 0L) {
                        Object v;
                        try {
                            v = future.get(l4, TimeUnit.NANOSECONDS);
                        }
                        catch (InterruptedException interruptedException) {
                            bl = true;
                            l4 = l3 - System.nanoTime();
                            continue;
                        }
                        return v;
                    }
                    throw new TimeoutException();
                }
                finally {
                    if (bl) {
                        Thread.currentThread().interrupt();
                    }
                }
            }

            @Override
            public V get() throws ExecutionException {
                boolean bl = false;
                while (true) {
                    try {
                        Object v = future.get();
                        return v;
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                        continue;
                    }
                    break;
                }
                finally {
                    if (bl) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
    }

    public static <T> ListenableFuture<T> makeListenable(Future<T> future) {
        if (future instanceof ListenableFuture) {
            return (ListenableFuture)future;
        }
        return new ListenableFutureAdapter<T>(future);
    }

    public static <T, E extends Exception> CheckedFuture<T, E> makeChecked(Future<T> future, Function<Exception, E> function) {
        return new MappingCheckedFuture<T, E>(Futures.makeListenable(future), function);
    }

    public static <T> ListenableFuture<T> immediateFuture(@Nullable T t) {
        ValueFuture valueFuture = ValueFuture.create();
        valueFuture.set(t);
        return valueFuture;
    }

    public static <T, E extends Exception> CheckedFuture<T, E> immediateCheckedFuture(@Nullable T t) {
        ValueFuture valueFuture = ValueFuture.create();
        valueFuture.set(t);
        return Futures.makeChecked(valueFuture, new Function<Exception, E>(){

            @Override
            public E apply(Exception exception) {
                throw new AssertionError((Object)"impossible");
            }
        });
    }

    public static <T> ListenableFuture<T> immediateFailedFuture(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        ValueFuture valueFuture = ValueFuture.create();
        valueFuture.setException(throwable);
        return valueFuture;
    }

    public static <T, E extends Exception> CheckedFuture<T, E> immediateFailedCheckedFuture(final E e) {
        Preconditions.checkNotNull(e);
        return Futures.makeChecked(Futures.immediateFailedFuture(e), new Function<Exception, E>(){

            @Override
            public E apply(Exception exception) {
                return e;
            }
        });
    }

    public static <I, O> ListenableFuture<O> chain(ListenableFuture<I> listenableFuture, Function<? super I, ? extends ListenableFuture<? extends O>> function) {
        return Futures.chain(listenableFuture, function, Executors.sameThreadExecutor());
    }

    public static <I, O> ListenableFuture<O> chain(ListenableFuture<I> listenableFuture, Function<? super I, ? extends ListenableFuture<? extends O>> function, Executor executor) {
        ChainingListenableFuture chainingListenableFuture = new ChainingListenableFuture(function, listenableFuture);
        listenableFuture.addListener(chainingListenableFuture, executor);
        return chainingListenableFuture;
    }

    public static <I, O> ListenableFuture<O> compose(ListenableFuture<I> listenableFuture, Function<? super I, ? extends O> function) {
        return Futures.compose(listenableFuture, function, Executors.sameThreadExecutor());
    }

    public static <I, O> ListenableFuture<O> compose(ListenableFuture<I> listenableFuture, final Function<? super I, ? extends O> function, Executor executor) {
        Function function2 = new Function<I, ListenableFuture<O>>(){

            @Override
            public ListenableFuture<O> apply(I i) {
                Object t = function.apply(i);
                return Futures.immediateFuture(t);
            }
        };
        return Futures.chain(listenableFuture, function2, executor);
    }

    public static <I, O> Future<O> compose(final Future<I> future, final Function<? super I, ? extends O> function) {
        return new Future<O>(){
            private final Object lock = new Object();
            private boolean set = false;
            private O value = null;

            @Override
            public O get() throws InterruptedException, ExecutionException {
                return this.apply(future.get());
            }

            @Override
            public O get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.apply(future.get(l, timeUnit));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private O apply(I i) {
                Object object = this.lock;
                synchronized (object) {
                    if (!this.set) {
                        this.value = function.apply(i);
                        this.set = true;
                    }
                    return this.value;
                }
            }

            @Override
            public boolean cancel(boolean bl) {
                return future.cancel(bl);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListenableFutureAdapter<T>
    extends ForwardingFuture<T>
    implements ListenableFuture<T> {
        private static final Executor adapterExecutor = java.util.concurrent.Executors.newCachedThreadPool();
        private final ExecutionList executionList = new ExecutionList();
        private final AtomicBoolean hasListeners = new AtomicBoolean(false);
        private final Future<T> delegate;

        ListenableFutureAdapter(Future<T> future) {
            this.delegate = future;
        }

        @Override
        protected Future<T> delegate() {
            return this.delegate;
        }

        @Override
        public void addListener(Runnable runnable, Executor executor) {
            if (!this.hasListeners.get() && this.hasListeners.compareAndSet(false, true)) {
                adapterExecutor.execute(new Runnable(){

                    public void run() {
                        try {
                            ListenableFutureAdapter.this.delegate.get();
                        }
                        catch (CancellationException cancellationException) {
                        }
                        catch (InterruptedException interruptedException) {
                            throw new IllegalStateException("Adapter thread interrupted!", interruptedException);
                        }
                        catch (ExecutionException executionException) {
                            // empty catch block
                        }
                        ListenableFutureAdapter.this.executionList.run();
                    }
                });
            }
            this.executionList.add(runnable, executor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MappingCheckedFuture<T, E extends Exception>
    extends AbstractCheckedFuture<T, E> {
        final Function<Exception, E> mapper;

        MappingCheckedFuture(ListenableFuture<T> listenableFuture, Function<Exception, E> function) {
            super(listenableFuture);
            this.mapper = function;
        }

        @Override
        protected E mapException(Exception exception) {
            return (E)((Exception)this.mapper.apply(exception));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChainingListenableFuture<I, O>
    extends AbstractListenableFuture<O>
    implements Runnable {
        private final Function<? super I, ? extends ListenableFuture<? extends O>> function;
        private final UninterruptibleFuture<? extends I> inputFuture;

        private ChainingListenableFuture(Function<? super I, ? extends ListenableFuture<? extends O>> function, ListenableFuture<? extends I> listenableFuture) {
            this.function = function;
            this.inputFuture = Futures.makeUninterruptible(listenableFuture);
        }

        @Override
        public void run() {
            try {
                I i;
                try {
                    i = this.inputFuture.get();
                }
                catch (CancellationException cancellationException) {
                    this.cancel();
                    return;
                }
                catch (ExecutionException executionException) {
                    this.setException(executionException.getCause());
                    return;
                }
                final ListenableFuture<O> listenableFuture = this.function.apply(i);
                listenableFuture.addListener(new Runnable(){

                    public void run() {
                        try {
                            ChainingListenableFuture.this.set(Futures.makeUninterruptible(listenableFuture).get());
                        }
                        catch (ExecutionException executionException) {
                            ChainingListenableFuture.this.setException(executionException.getCause());
                        }
                    }
                }, Executors.sameThreadExecutor());
            }
            catch (UndeclaredThrowableException undeclaredThrowableException) {
                this.setException(undeclaredThrowableException.getCause());
            }
            catch (RuntimeException runtimeException) {
                this.setException(runtimeException);
            }
            catch (Error error) {
                this.setException(error);
                throw error;
            }
        }
    }
}

