/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamingThreadFactory
implements ThreadFactory {
    private final ThreadFactory backingFactory;
    private final String format;
    private final AtomicInteger count = new AtomicInteger(0);
    public static final ThreadFactory DEFAULT_FACTORY = Executors.defaultThreadFactory();

    public NamingThreadFactory(String string) {
        this(string, DEFAULT_FACTORY);
    }

    public NamingThreadFactory(String string, ThreadFactory threadFactory) {
        this.format = string;
        this.backingFactory = threadFactory;
        this.makeName(0);
    }

    public Thread newThread(Runnable runnable) {
        Thread thread = this.backingFactory.newThread(runnable);
        thread.setName(this.makeName(this.count.getAndIncrement()));
        return thread;
    }

    private String makeName(int n) {
        return String.format(this.format, n);
    }
}

